/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.GnomeThemeDetector;
import com.jthemedetecor.OsThemeDetector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GnomeThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(GnomeThemeDetector.class);
    private static final String MONITORING_CMD = "gsettings monitor org.gnome.desktop.interface gtk-theme";
    private static final String GET_CMD = "gsettings get org.gnome.desktop.interface gtk-theme";
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private final Pattern darkThemeNamePattern = Pattern.compile(".*dark.*", 2);
    private DetectorThread detectorThread;

    GnomeThemeDetector() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDark() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(GET_CMD);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String readLine = reader.readLine();
                if (readLine == null) return false;
                boolean bl = this.isDarkTheme(readLine);
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("Couldn't detect Linux OS theme", (Throwable)e);
        }
        return false;
    }

    private boolean isDarkTheme(String gtkTheme) {
        return this.darkThemeNamePattern.matcher(gtkTheme).matches();
    }

    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener);
        boolean listenerAdded = this.listeners.add(darkThemeListener);
        boolean singleListener = listenerAdded && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (singleListener || threadInterrupted) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    public synchronized void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }
}

