/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfHeader;
import com.tutego.jrtf.RtfHeaderFont;
import java.io.IOException;

public class RtfHeaderFont
extends RtfHeader {
    public static final String COURIER = "Courier";
    public static final String HELVETICA = "Arial";
    public static final String ARIAL = "Arial";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times New Roman";
    public static final String ZAPFDINGBATS = "Windings";
    public static final String WINDINGS = "Windings";
    private final String fontname;
    private int fontnum;
    private FontFamily fontfamily = FontFamily.NIL;
    private CharSet charSet = CharSet.ANSI;
    private Pitch pitch;

    RtfHeaderFont(String fontname) {
        this.fontname = fontname;
    }

    public RtfHeaderFont family(FontFamily fontfamily) {
        if (fontfamily == null) {
            throw new IllegalArgumentException("Font family can't be null");
        }
        this.fontfamily = fontfamily;
        return this;
    }

    public RtfHeaderFont charset(CharSet charSet) {
        if (charSet == null) {
            throw new IllegalArgumentException("Char set can't be null");
        }
        this.charSet = charSet;
        return this;
    }

    public RtfHeaderFont pitch(Pitch pitch) {
        if (pitch == null) {
            throw new IllegalArgumentException("Pitch can't be null");
        }
        this.pitch = pitch;
        return this;
    }

    public RtfHeader at(int fontnum) {
        if (fontnum < 0) {
            throw new IllegalArgumentException("Font number is not allowed to be negative");
        }
        this.fontnum = fontnum;
        return this;
    }

    void writeFontInfo(Appendable out) throws IOException {
        out.append("{\\f").append(Integer.toString(this.fontnum)).append("\\f").append(this.fontfamily.toString().toLowerCase()).append((CharSequence)(this.charSet != null ? "\\fcharset" + String.valueOf(this.charSet) : "")).append((CharSequence)(this.pitch != null ? "\\fprq" + String.valueOf(this.pitch) : "")).append(" ").append(this.fontname).append(";}");
    }
}

