/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.Rtf;
import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfPicture;
import com.tutego.jrtf.RtfTemplate;
import com.tutego.jrtf.RtfText;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/*
 * Exception performing whole class analysis ignored.
 */
public class RtfText {
    private final CharSequence rtf;

    RtfText(CharSequence rtf) {
        this.rtf = rtf;
    }

    public static RtfText text(Object ... texts) {
        return RtfText.textJoinWithSpace((boolean)false, (Object[])texts);
    }

    public static RtfText textJoinWithSpace(boolean joinWithSpace, Object ... texts) {
        if (texts == null || texts.length == 0) {
            return new RtfText((CharSequence)"");
        }
        StringBuilder result = new StringBuilder(1024);
        for (int i = 0; i < texts.length; ++i) {
            if (texts[i] == null) continue;
            if (joinWithSpace && i > 0 && texts[i - 1] != null) {
                result.append(' ');
            }
            try {
                if (texts[i] instanceof RtfText) {
                    ((RtfText)texts[i]).rtf((Appendable)result);
                    continue;
                }
                if (texts[i] instanceof RtfTemplate) {
                    result.append(((RtfTemplate)texts[i]).out());
                    continue;
                }
                if (texts[i] instanceof RtfPara) {
                    throw new RtfException("RtfPara in method text() is not allowed. There is no sensible toString() method declared");
                }
                Rtf.asRtf((Appendable)result, (String)texts[i].toString());
                continue;
            }
            catch (IOException e) {
                throw new RtfException((Throwable)e);
            }
        }
        return new RtfText((CharSequence)result);
    }

    public static RtfText text(String text) {
        if (text == null) {
            text = "";
        }
        return new RtfText((CharSequence)Rtf.asRtf((String)text));
    }

    public static RtfText font(int fontnum, Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 8);
        sb.append("{\\f").append(fontnum).append(' ').append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText italic(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 5);
        sb.append("{\\i ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText bold(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 5);
        sb.append("{\\b ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText underline(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 6);
        sb.append("{\\ul ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText dottedUnderline(String text) {
        RtfText rtfText = RtfText.text((String)text);
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 7);
        sb.append("{\\uld ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText doubleUnderline(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 8);
        sb.append("{\\uldb ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText wordUnderline(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 7);
        sb.append("{\\ulw ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText subscript(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 7);
        sb.append("{\\sub ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText revised(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 11);
        sb.append("{\\revised ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText superscript(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 9);
        sb.append("{\\super ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText strikethru(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 10);
        sb.append("{\\strike ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText shadow(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 8);
        sb.append("{\\shad ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText smallCapitals(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 9);
        sb.append("{\\scaps ").append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText fontSize(int fontSize, Object text) {
        if (fontSize < 0) {
            throw new IllegalArgumentException("Font size can't be negative");
        }
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 10);
        sb.append("{\\fs").append(fontSize).append(' ').append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText color(int colorindex, Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        StringBuilder sb = new StringBuilder(rtfText.rtf.length() + 10);
        sb.append("{\\cf").append(colorindex).append(' ').append(rtfText.rtf).append('}');
        return new RtfText((CharSequence)sb);
    }

    public static RtfText color(int colorindex, String text) {
        return RtfText.color((int)colorindex, (Object)RtfText.text((String)text));
    }

    public static RtfText currentDate() {
        return new RtfText((CharSequence)"\\chdate\n");
    }

    public static RtfText currentDateLong() {
        return new RtfText((CharSequence)"\\chdpl\n");
    }

    public static RtfText currentDateAbbreviated() {
        return new RtfText((CharSequence)"\\chdpa\n");
    }

    public static RtfText currentTime() {
        return new RtfText((CharSequence)"\\chtime\n");
    }

    public static RtfText currentPageNumber() {
        return new RtfText((CharSequence)"\\chpgn\n");
    }

    public static RtfText currentSectionNumber() {
        return new RtfText((CharSequence)"\\sectnum\n");
    }

    public static RtfText pageBreak() {
        return new RtfText((CharSequence)"\\page\n");
    }

    public static RtfText columnBreak() {
        return new RtfText((CharSequence)"\\column\n");
    }

    public static RtfText lineBreak() {
        return new RtfText((CharSequence)"\\line\n");
    }

    public static RtfText softPageBreak() {
        return new RtfText((CharSequence)"\\softpage\n");
    }

    public static RtfText softColumnBreak() {
        return new RtfText((CharSequence)"\\softcol\n");
    }

    public static RtfText softLineBreak() {
        return new RtfText((CharSequence)"\\softline\n");
    }

    public static RtfText tab() {
        return new RtfText((CharSequence)"\\tab\n");
    }

    public static RtfText longHyphen() {
        return new RtfText((CharSequence)"\\emdash\n");
    }

    public static RtfText shortHyphen() {
        return new RtfText((CharSequence)"\\endash\n");
    }

    public static RtfText bullet() {
        return new RtfText((CharSequence)"\\bullet\n");
    }

    public static RtfText leftQuotationMark() {
        return new RtfText((CharSequence)"\\lquote\n");
    }

    public static RtfText rightQuotationMark() {
        return new RtfText((CharSequence)"\\rquote\n");
    }

    public static RtfText qoute(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        return new RtfText((CharSequence)("\\lquote\n" + String.valueOf(rtfText.rtf) + "\\rquote\n"));
    }

    public static RtfText leftDoubleQuotationMark() {
        return new RtfText((CharSequence)"\\ldblquote\n");
    }

    public static RtfText rightDoubleQuotationMark() {
        return new RtfText((CharSequence)"\\rdblquote\n");
    }

    public static RtfText doubleQuote(Object text) {
        RtfText rtfText = RtfText.text((Object[])new Object[]{text});
        return new RtfText((CharSequence)("\\ldblquote\n" + String.valueOf(rtfText.rtf) + "\\rdblquote\n"));
    }

    public static RtfText nonBreakingSpace() {
        return new RtfText((CharSequence)"\\~\n");
    }

    public static RtfPicture picture(URL source) {
        try {
            return new RtfPicture(source.openStream());
        }
        catch (IOException e) {
            throw new RtfException((Throwable)e);
        }
    }

    public static RtfPicture picture(InputStream source) {
        try {
            return new RtfPicture(source);
        }
        catch (IOException e) {
            throw new RtfException((Throwable)e);
        }
    }

    public static RtfText footnote(RtfPara ... paras) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static RtfText footnote(Object para) {
        return RtfText.footnote((RtfPara[])new RtfPara[]{RtfPara.p((Object[])new Object[]{para})});
    }

    public static RtfText field(RtfPara fieldInstructions, RtfPara recentResult, FieldModifier fieldModifier) {
        if (fieldInstructions == null) {
            throw new IllegalArgumentException("Field instructions are missing");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static RtfText field(RtfPara fieldInstructions, RtfPara recentResult) {
        return RtfText.field((RtfPara)fieldInstructions, (RtfPara)recentResult, null);
    }

    public static RtfText hyperlink(String url, RtfPara text) {
        try {
            StringBuilder sb = new StringBuilder(256);
            sb.append("{\\field{\\*\\fldinst{HYPERLINK \"").append(Rtf.asRtf((String)url)).append("\"}}{\\fldrslt{\\ul ");
            text.rtf((Appendable)sb, false);
            sb.append("}}}");
            return new RtfText((CharSequence)sb);
        }
        catch (IOException e) {
            throw new RtfException((Throwable)e);
        }
    }

    void rtf(Appendable out) throws IOException {
        out.append(this.rtf);
    }
}

