/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfPara;
import com.tutego.jrtf.RtfTextPara;
import com.tutego.jrtf.RtfUnit;

public abstract class RtfTextPara
extends RtfPara {
    private final StringBuilder parfmt = new StringBuilder(512);
    private final StringBuilder tabdef = new StringBuilder(512);
    private final StringBuilder brdrdef = new StringBuilder(512);
    StringBuilder cellfmt = new StringBuilder(32);

    CharSequence textparFormatRtf() {
        return new StringBuilder(512).append((CharSequence)this.brdrdef).append((CharSequence)this.parfmt).append((CharSequence)this.tabdef);
    }

    public RtfTextPara reset() {
        this.parfmt.append("\\pard\n");
        return this;
    }

    public RtfTextPara hyphenationOn() {
        this.parfmt.append("\\hyphpar1\n");
        return this;
    }

    public RtfTextPara hyphenationOff() {
        this.parfmt.append("\\hyphpar0\n");
        return this;
    }

    public RtfTextPara partOfTable() {
        this.parfmt.append("\\intbl\n");
        return this;
    }

    public RtfTextPara keep() {
        this.parfmt.append("\\keep\n");
        return this;
    }

    public RtfTextPara noWidowOrOrphanControl() {
        this.parfmt.append("\\nowidctlpar\n");
        return this;
    }

    public RtfTextPara keepWithNextParagraph() {
        this.parfmt.append("\\keepn\n");
        return this;
    }

    public RtfTextPara level(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Level is not allowed to be negative but is " + level);
        }
        this.parfmt.append("\\level").append(level).append('\n');
        return this;
    }

    public RtfTextPara noLineNumbering() {
        this.parfmt.append("\\noline\n");
        return this;
    }

    public RtfTextPara breakPageBeforeParagraph() {
        this.parfmt.append("\\pagebb\n");
        return this;
    }

    public RtfTextPara alignLeft() {
        this.parfmt.append("\\ql\n");
        return this;
    }

    public RtfTextPara alignRight() {
        this.parfmt.append("\\qr\n");
        return this;
    }

    public RtfTextPara alignJustified() {
        this.parfmt.append("\\qj\n");
        return this;
    }

    public RtfTextPara alignCentered() {
        this.parfmt.append("\\qc\n");
        return this;
    }

    public RtfTextPara indentFirstLine(double indentation, RtfUnit unit) {
        this.parfmt.append("\\fi").append(unit.toTwips(indentation)).append('\n');
        return this;
    }

    public RtfTextPara indentLeft(double indentation, RtfUnit unit) {
        this.parfmt.append("\\li").append(unit.toTwips(indentation)).append('\n');
        return this;
    }

    public RtfTextPara indentRight(double indentation, RtfUnit unit) {
        this.parfmt.append("\\ri").append(unit.toTwips(indentation)).append('\n');
        return this;
    }

    public RtfTextPara spaceBeforeLine(double space, RtfUnit unit) {
        this.parfmt.append("\\sb").append(unit.toTwips(space)).append('\n');
        return this;
    }

    public RtfTextPara spaceAfterLine(double space, RtfUnit unit) {
        this.parfmt.append("\\sa").append(unit.toTwips(space)).append('\n');
        return this;
    }

    public RtfTextPara spaceBetweenLines(double space, RtfUnit unit) {
        space = Math.abs(space);
        this.parfmt.append("\\sl").append(unit.toTwips(space)).append('\n');
        return this;
    }

    public RtfTextPara spaceBetweenLinesMultipleAtLeastOrExactly(double space, RtfUnit unit) {
        space = Math.abs(space);
        this.parfmt.append("\\sl").append(unit.toTwips(space)).append("\\slmult0\n");
        return this;
    }

    public RtfTextPara spaceBetweenLinesMultiple(double space, RtfUnit unit) {
        space = Math.abs(space);
        this.parfmt.append("\\sl").append(unit.toTwips(space)).append("\\slmult1\n");
        return this;
    }

    public RtfTextPara spaceBetweenLinesAutomatically() {
        this.parfmt.append("\\sl0\n");
        return this;
    }

    public RtfTextPara rightToLeft() {
        this.parfmt.append("\\rtlpar\n");
        return this;
    }

    public RtfTextPara leftToRight() {
        this.parfmt.append("\\ltrpar\n");
        return this;
    }

    public RtfTextPara tab(double tabPostion, RtfUnit unit) {
        return this.tab(null, null, tabPostion, unit);
    }

    public RtfTextPara tab(TabKind tabKind, double tabPostion, RtfUnit unit) {
        return this.tab(tabKind, null, tabPostion, unit);
    }

    public RtfTextPara tab(TabKind tabKind, TabLead tabLead, double tabPostion, RtfUnit unit) {
        if (tabKind != null && tabKind != TabKind.LEFT) {
            this.tabdef.append(tabKind);
        }
        if (tabLead != null) {
            this.tabdef.append(tabLead);
        }
        this.tabdef.append("\\tx").append(unit.toTwips(tabPostion)).append('\n');
        return this;
    }

    public RtfTextPara topBorder(BorderStyle borderStyle) {
        if (borderStyle == null) {
            throw new IllegalArgumentException("Border style is missing, can't be null");
        }
        this.brdrdef.append("\\brdrt").append(borderStyle);
        return this;
    }

    public RtfTextPara bottomBorder(BorderStyle borderStyle) {
        if (borderStyle == null) {
            throw new IllegalArgumentException("Border style is missing, can't be null");
        }
        this.brdrdef.append("\\brdrb").append(borderStyle);
        return this;
    }

    public RtfTextPara leftBorder(BorderStyle borderStyle) {
        if (borderStyle == null) {
            throw new IllegalArgumentException("Border style is missing, can't be null");
        }
        this.brdrdef.append("\\brdrl").append(borderStyle);
        return this;
    }

    public RtfTextPara rightBorder(BorderStyle borderStyle) {
        if (borderStyle == null) {
            throw new IllegalArgumentException("Border style is missing, can't be null");
        }
        this.brdrdef.append("\\brdrr").append(borderStyle);
        return this;
    }

    public RtfTextPara cellWidth(double width, RtfUnit unit) {
        this.cellfmt.append("\\clftsWidth3\\clwWidth").append(unit.toTwips(Math.abs(width))).append('\n');
        return this;
    }
}

