/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3;

import eu.ewerkzeug.easytranscript3.SpringBootJavaFxApplication;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.player.Player;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import javafx.application.Application;
import javafx.application.Platform;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxWeaver;
import org.apache.commons.exec.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@SpringBootApplication
@EnableScheduling
public class Main {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static Player player;
    private static File recentOpenedFileChooserPath;
    private final ExecutorService executorService;

    public static File getRecentOpenedFileChooserPath() {
        if (!recentOpenedFileChooserPath.exists() && !(recentOpenedFileChooserPath = new File(System.getProperty("user.home"))).exists()) {
            return null;
        }
        return recentOpenedFileChooserPath;
    }

    public static Path getEasytranscriptTempDirectory() {
        Path tmp = Path.of(Configuration.ET_HOME, new String[0]).resolve(".tmp");
        try {
            if (!Files.exists(tmp, new LinkOption[0])) {
                Files.createDirectories(tmp, new FileAttribute[0]);
                Utils.markAsHidden((Path)tmp);
            }
        }
        catch (IOException e) {
            log.error("Could not create temp directory", (Throwable)e);
        }
        return tmp;
    }

    public static void main(String[] args) {
        if (!OS.isFamilyWindows()) {
            System.setProperty("prism.lcdtext", "false");
        }
        Platform.setImplicitExit((boolean)false);
        Application.launch(SpringBootJavaFxApplication.class, (String[])args);
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onShutdown() {
        log.info("Context closed event received, starting grace period timer...");
        this.executorService.shutdown();
        this.initiateForcedShutdown(30);
    }

    private void initiateForcedShutdown(int gracePeriodInSeconds) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setDaemon(true);
        taskScheduler.initialize();
        taskScheduler.schedule(() -> {
            if (!this.executorService.isTerminated()) {
                log.warn("Grace period expired. Forcing shutdown...");
                this.executorService.shutdownNow();
            } else {
                log.info("All tasks completed before grace period expired.");
            }
            log.info("{} Threads still active.", (Object)Thread.activeCount());
            Thread.getAllStackTraces().forEach((key, value) -> {
                log.info("");
                log.info("{} - {} - {}", new Object[]{key.getName(), key.getClass().getName(), key.getState()});
                for (StackTraceElement stackTraceElement : value) {
                    log.info(stackTraceElement.toString());
                }
            });
            log.error("Grace period over, forcefully shutting down the JVM.");
            Runtime.getRuntime().halt(1);
        }, Instant.now().plusSeconds(gracePeriodInSeconds));
    }

    @Bean
    public FxWeaver fxWeaver(ConfigurableApplicationContext applicationContext) {
        return new FxWeaver(arg_0 -> ((ConfigurableApplicationContext)applicationContext).getBean(arg_0), () -> ((ConfigurableApplicationContext)applicationContext).close());
    }

    @Generated
    public Main(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Generated
    public static Player getPlayer() {
        return player;
    }

    @Generated
    public static void setPlayer(Player player) {
        Main.player = player;
    }

    @Generated
    public static void setRecentOpenedFileChooserPath(File recentOpenedFileChooserPath) {
        Main.recentOpenedFileChooserPath = recentOpenedFileChooserPath;
    }

    static {
        recentOpenedFileChooserPath = new File(System.getProperty("user.home"));
    }
}

