/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import eu.ewerkzeug.easytranscript3.commons.AESUtil;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class CredentialsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CredentialsUtils.class);
    public static final Path CREDS_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve(".creds");
    public static final Path DEVICE_ID_FILE = Path.of(Configuration.ET_HOME, new String[0]).resolve(".instance_info.dat");

    public static void storeCredentials(byte[] auth) throws IOException {
        Files.write(CREDS_PATH, auth, new OpenOption[0]);
        Utils.markAsHidden((Path)CREDS_PATH);
    }

    public static void clearCredentials() throws IOException {
        Files.deleteIfExists(CREDS_PATH);
    }

    public static byte[] getCredentials() throws IOException {
        if (Files.exists(CREDS_PATH, new LinkOption[0])) {
            return Files.readAllBytes(CREDS_PATH);
        }
        return null;
    }

    public static byte[] getDeviceId() throws IOException {
        if (Files.exists(DEVICE_ID_FILE, new LinkOption[0])) {
            return Files.readAllBytes(DEVICE_ID_FILE);
        }
        log.error("No device id file found.");
        return null;
    }

    public static Consumer<HttpHeaders> getAuthHeadersConsumer() {
        HashMap authHeaders = CredentialsUtils.getAuthHeaders();
        if (authHeaders == null) {
            return null;
        }
        return headers -> {
            for (Map.Entry authHeader : authHeaders.entrySet()) {
                headers.add((String)authHeader.getKey(), (String)authHeader.getValue());
            }
        };
    }

    public static HashMap<String, String> getAuthHeaders() {
        String deviceId;
        Pair authHeader = CredentialsUtils.getAuthenticationHeader();
        if (authHeader == null) {
            return null;
        }
        try {
            deviceId = (String)AESUtil.decrypt((byte[])CredentialsUtils.getDeviceId());
        }
        catch (IOException e) {
            log.error("Could not decrypt deviceId", (Throwable)e);
            return null;
        }
        HashMap<String, String> returner = new HashMap<String, String>();
        returner.put((String)authHeader.getKey(), (String)authHeader.getValue());
        returner.put("X-Device-ID", deviceId);
        return returner;
    }

    private static Pair<String, String> getAuthenticationHeader() {
        Pair credentials = LicenseService.getLicenseCredentials();
        if (credentials == null) {
            log.error("No credentials saved.");
            return null;
        }
        String header = "Authorization";
        String headerValue = "Basic " + Base64.getEncoder().encodeToString(((String)credentials.getLeft() + ":" + (String)credentials.getRight()).getBytes(StandardCharsets.UTF_8));
        return ImmutablePair.of((Object)header, (Object)headerValue);
    }
}

