/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.geometry.BoundingBox;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import org.apache.commons.exec.OS;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalPreferencesUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalPreferencesUtils.class);
    public static final String ET_IDENTIFIER = "/climbingperch/easytranscript";
    public static final String MAIN_WINDOW_IDENTIFIER = "/climbingperch/easytranscript/main";
    private static final String WINDOW_POSITION_X = "window_position_x";
    private static final String WINDOW_POSITION_Y = "window_position_y";
    private static final String WINDOW_WIDTH = "window_width";
    private static final String WINDOW_HEIGHT = "window_height";
    private static final String WINDOW_MAXIMIZED = "window_maximized";

    public static void storeSizeAndPosition(Window window, BoundingBox beforeMaximizing, String identifier) throws BackingStoreException {
        double height;
        double width;
        double y;
        double x;
        log.debug("Storing size and position for window with identifier {} ...", (Object)identifier);
        Preferences preferences = Preferences.userRoot().node(identifier);
        if (beforeMaximizing != null) {
            log.debug("Found before maximizing data...");
            x = beforeMaximizing.getMinX();
            y = beforeMaximizing.getMinY();
            width = beforeMaximizing.getWidth();
            height = beforeMaximizing.getHeight();
        } else {
            x = window.getX();
            y = window.getY();
            width = window.getWidth();
            height = window.getHeight();
        }
        preferences.putDouble(WINDOW_POSITION_X, x);
        preferences.putDouble(WINDOW_POSITION_Y, y);
        preferences.putDouble(WINDOW_WIDTH, width);
        preferences.putDouble(WINDOW_HEIGHT, height);
        preferences.putBoolean(WINDOW_MAXIMIZED, ((Stage)window).isMaximized());
        preferences.flush();
        log.debug("Stored Position and size: {},{},{},{} - {}", new Object[]{x, y, width, height, ((Stage)window).isMaximized()});
    }

    public static boolean hasStoredSizeAndPosition(String identifier) {
        try {
            return Preferences.userRoot().nodeExists(identifier);
        }
        catch (BackingStoreException e) {
            log.error("Could not check if there are sizes and positions stored.", (Throwable)e);
            return false;
        }
    }

    public static void setSizeAndPosition(Window window, String identifier) {
        Preferences pref = Preferences.userRoot().node(identifier);
        log.debug("Setting stored size and position for window with identifier {}: {}...", (Object)identifier, (Object)pref.toString());
        double x = pref.getDouble(WINDOW_POSITION_X, window.getX());
        double y = pref.getDouble(WINDOW_POSITION_Y, window.getY());
        double width = pref.getDouble(WINDOW_WIDTH, window.getWidth());
        double height = pref.getDouble(WINDOW_HEIGHT, window.getHeight());
        boolean maximized = pref.getBoolean(WINDOW_MAXIMIZED, ((Stage)window).isMaximized());
        log.debug("Restoring Position and size: {},{},{},{} - {}", new Object[]{x, y, width, height, maximized});
        Screen screen = Utils.getScreenForRectangle((Rectangle2D)new Rectangle2D(x, y, width, height));
        Rectangle2D bounds = screen.getVisualBounds();
        x = x + width > bounds.getMaxX() ? bounds.getMaxX() - width : x;
        y = y + height > bounds.getMaxY() ? bounds.getMaxY() - height : y;
        x = Math.max(bounds.getMinX(), x);
        y = Math.max(bounds.getMinY(), y);
        width = Math.min(bounds.getWidth(), width);
        height = Math.min(bounds.getHeight(), height);
        window.setX(x);
        window.setY(y);
        window.setWidth(width);
        window.setHeight(height);
        window.getProperties().put((Object)"beforeMaximizingHeight", (Object)height);
        window.getProperties().put((Object)"beforeMaximizingWidth", (Object)width);
        window.getProperties().put((Object)"beforeMaximizingX", (Object)x);
        window.getProperties().put((Object)"beforeMaximizingY", (Object)y);
        if (!OS.isFamilyMac()) {
            FxTimer.runLater((Duration)Duration.of(500L, ChronoUnit.MILLIS), () -> {
                ((Stage)window).setMaximized(maximized);
                GUIState.getController().show();
            });
        } else {
            GUIState.getController().show();
        }
    }
}

