/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import org.apache.commons.lang3.tuple.MutablePair;
import org.fxmisc.richtext.model.Paragraph;
import org.reactfx.EventStream;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FXUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FXUtils.class);

    private FXUtils() {
    }

    public static Path getInverseClip(Node highlightNode, Node root) {
        return FXUtils.getInverseClip((Shape)FXUtils.getShapeOnScreen((Node)highlightNode), (Shape)FXUtils.getShapeOnScreen((Node)root));
    }

    public static Path getInverseClip(Shape highlight, Shape root) {
        if (root == null) {
            return new Path();
        }
        if (highlight == null) {
            highlight = new Path();
        }
        return (Path)Shape.subtract((Shape)FXUtils.getShapeOnScreen((Node)root), (Shape)highlight);
    }

    public static Rectangle getShapeOnScreen(Node node) {
        return FXUtils.getShapeAsRectangle(node != null ? node.localToScene(node.getBoundsInLocal()) : null);
    }

    public static Rectangle getShapeOnScreen(Node node, Rectangle toAdd) {
        Rectangle shapeOnScreen = FXUtils.getShapeOnScreen((Node)node);
        if (toAdd != null && shapeOnScreen != null) {
            shapeOnScreen = FXUtils.addRectangles((Rectangle)shapeOnScreen, (Rectangle)toAdd);
        }
        return shapeOnScreen;
    }

    public static Rectangle getShapeAsRectangle(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        rectangle.setWidth(bounds.getWidth());
        rectangle.setHeight(bounds.getHeight());
        rectangle.setX(bounds.getMinX());
        rectangle.setY(bounds.getMinY());
        return rectangle;
    }

    public static Rectangle addRectangles(Rectangle a, Rectangle b) {
        Rectangle returner = new Rectangle();
        returner.setX(a.getX() + b.getX());
        returner.setY(a.getY() + b.getY());
        returner.setWidth(a.getWidth() + b.getWidth());
        returner.setHeight(a.getHeight() + b.getHeight());
        return returner;
    }

    public static Bounds addRectangleToBounds(Bounds bounds, Rectangle update) {
        if (bounds == null || update == null) {
            return bounds;
        }
        return new BoundingBox(bounds.getMinX() + update.getX(), bounds.getMinY() + update.getY(), bounds.getWidth() + update.getWidth(), bounds.getHeight() + update.getHeight());
    }

    public static void setRectangleTo(Rectangle rectangle, Rectangle update) {
        if (update == null) {
            return;
        }
        rectangle.setX(update.getX());
        rectangle.setY(update.getY());
        rectangle.setWidth(update.getWidth());
        rectangle.setHeight(update.getHeight());
    }

    public static ObservableValue<Boolean> asBooleanBinding(EventStream<?> eventStream) {
        return eventStream.map(Objects::nonNull).cast(Boolean.class).toBinding((Object)false);
    }

    public static void centerNodeInScrollPane(ScrollPane scrollPane, Node node) {
        Bounds nodeInScrollPane = scrollPane.getContent().sceneToLocal(node.localToScene(node.getBoundsInLocal()));
        double contentHeight = scrollPane.getContent().getBoundsInLocal().getHeight();
        double nodeCenterY = nodeInScrollPane.getCenterY();
        double viewportHeight = scrollPane.getViewportBounds().getHeight();
        double vValue = (nodeCenterY - 0.5 * viewportHeight) / (contentHeight - viewportHeight);
        System.out.println(nodeCenterY);
        vValue = Math.max(0.0, Math.min(1.0, vValue));
        scrollPane.setVvalue(vValue);
        if (vValue == 1.0) {
            scrollPane.setVvalue(scrollPane.getVmax());
        }
    }

    public static ScrollPane findScrollPaneParent(Node node) {
        Node parent = node;
        while (parent.getParent() != null && !(parent instanceof ScrollPane)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)parent;
            return scrollPane;
        }
        return null;
    }

    public static void runOnePulseLater(Runnable runnable) {
        FxTimer.runLater((Duration)Duration.ofMillis(20L), (Runnable)runnable);
    }

    public static Screen getScreenWithBiggestOverlap() {
        return FXUtils.getScreenWithBiggestOverlap((Window)GUIState.getMainStage());
    }

    public static Screen getScreenWithBiggestOverlap(Window window) {
        ObservableList screensForRectangle = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)window.getWidth(), (double)window.getHeight());
        MutablePair screenWithBiggestOverlap = new MutablePair((Object)0.0, (Object)Screen.getPrimary());
        for (Screen s : screensForRectangle) {
            Rectangle2D screenRect2d = s.getBounds();
            Rectangle screenRect = new Rectangle(screenRect2d.getMinX(), screenRect2d.getMinY(), screenRect2d.getWidth(), screenRect2d.getHeight());
            Rectangle windowRect = new Rectangle(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            Path subtract = (Path)Shape.intersect((Shape)screenRect, (Shape)windowRect);
            double horizontalOverlap = subtract.getBoundsInLocal().getWidth();
            if (!((Double)screenWithBiggestOverlap.getKey() < horizontalOverlap)) continue;
            screenWithBiggestOverlap.setLeft((Object)horizontalOverlap);
            screenWithBiggestOverlap.setRight((Object)s);
        }
        return (Screen)screenWithBiggestOverlap.getValue();
    }

    public static Optional<Window> findOpenWindowByController(Class<? extends ExtendedController> controllerClass) {
        return Window.getWindows().stream().filter(window -> window.getUserData() != null && window.getUserData().equals(controllerClass.getName())).findFirst();
    }

    public static void addIconsToStage(Stage stage, boolean dark) {
        String folder = !dark ? "dark" : "light";
        Platform.runLater(() -> {
            stage.getIcons().clear();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(FXUtils.class.getResourceAsStream("/images/" + folder + "/favicon_16.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(FXUtils.class.getResourceAsStream("/images/" + folder + "/favicon_32.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(FXUtils.class.getResourceAsStream("/images/" + folder + "/favicon_64.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(FXUtils.class.getResourceAsStream("/images/" + folder + "/favicon_96.png"))));
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(FXUtils.class.getResourceAsStream("/images/" + folder + "/favicon_512.png"))));
        });
    }

    public static int findAbsolutePositionOfSegment(AbstractSegment segment) {
        TranscriptTextArea area = TranscriptTextArea.get();
        Paragraph currentParagraph = area.getParagraph(area.getCurrentParagraph());
        List segments = currentParagraph.getSegments();
        int index = segments.stream().takeWhile(seg -> !seg.equals((Object)segment)).mapToInt(AbstractSegment::length).sum();
        int absoluteParPosition = area.getAbsolutePosition(area.getCurrentParagraph(), 0);
        return index += absoluteParPosition;
    }
}

