/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.commons.fx.FXUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import java.util.HashMap;
import java.util.List;
import javafx.scene.control.IndexRange;
import lombok.Generated;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.collection.LiveList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpeakerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerUtils.class);

    public static void replaceSpeakerWithText(Speaker speaker) {
        boolean hasChanges = false;
        MultiChangeBuilder multiChange = TranscriptTextArea.get().createMultiChange();
        LiveList paragraphs = TranscriptTextArea.get().getParagraphs();
        int pos = 0;
        for (Paragraph p : paragraphs) {
            List styledSegments = p.getStyledSegments();
            if (styledSegments.stream().anyMatch(f -> f.getSegment() instanceof SpeakerSegment)) {
                for (StyledSegment s : styledSegments) {
                    pos += ((AbstractSegment)s.getSegment()).length();
                    if (!(s.getSegment() instanceof SpeakerSegment) || !((SpeakerSegment)s.getSegment()).getUuid().equals(speaker.getUuid().toString())) continue;
                    multiChange.replaceText(pos - 1, pos, ((AbstractSegment)s.getSegment()).getRealText());
                    hasChanges = true;
                }
            } else {
                pos += p.length();
            }
            ++pos;
        }
        if (hasChanges) {
            TranscriptTextArea.get().commitMultiChange(multiChange);
        }
    }

    public static void updateSpeaker(Speaker speaker) {
        log.debug("Updating speaker with uuid {}", (Object)speaker.getUuid());
        SpeakerUtils.updateSpeakers(List.of(speaker));
    }

    public static void updateSpeakerSegmentStyle() {
        log.debug("Updating style of speaker segments ...");
        TranscriptTextArea.get().getParagraphs().stream().flatMap(paragraph -> paragraph.getStyledSegments().stream()).map(StyledSegment::getSegment).filter(SpeakerSegment.class::isInstance).map(SpeakerSegment.class::cast).forEach(SpeakerSegment::updateStyle);
    }

    public static void updateSpeakers(List<Speaker> speakers) {
        HashMap speakerMap = new HashMap();
        speakers.forEach(f -> speakerMap.put(f.getUuid().toString(), f));
        boolean hasChanges = false;
        MultiChangeBuilder multiChange = TranscriptTextArea.get().createMultiChange();
        LiveList paragraphs = TranscriptTextArea.get().getParagraphs();
        int pos = 0;
        for (Paragraph p : paragraphs) {
            List styledSegments = p.getStyledSegments();
            if (styledSegments.stream().anyMatch(f -> f.getSegment() instanceof SpeakerSegment)) {
                for (StyledSegment s : styledSegments) {
                    Speaker speaker;
                    pos += ((AbstractSegment)s.getSegment()).length();
                    if (!(s.getSegment() instanceof SpeakerSegment) || (speaker = (Speaker)speakerMap.get(((SpeakerSegment)s.getSegment()).getUuid())) == null) continue;
                    multiChange.deleteText(pos - 1, pos);
                    multiChange.insert(pos, (StyledDocument)SpeakerUtils.getSpeakerDoc((Speaker)speaker));
                    hasChanges = true;
                }
            } else {
                pos += p.length();
            }
            ++pos;
        }
        if (hasChanges) {
            TranscriptTextArea.get().commitMultiChange(multiChange);
        }
    }

    public static void insertSpeaker(Speaker speaker) {
        SpeakerUtils.insertSpeaker((Speaker)speaker, (boolean)true);
    }

    public static void insertSpeaker(Speaker speaker, boolean showSpeakerPopup) {
        log.debug("Inserting Speaker {} at pos {} ", (Object)speaker.getUuid(), (Object)TranscriptTextArea.get().getCaretPosition());
        ReadOnlyStyledDocument speakerDoc = SpeakerUtils.getSpeakerDoc((Speaker)speaker);
        IndexRange selection = TranscriptTextArea.get().getSelection();
        TranscriptTextArea.get().replace(selection.getStart(), selection.getEnd(), (StyledDocument)speakerDoc);
        TranscriptTextArea.get().deselect();
        if (showSpeakerPopup) {
            SpeakerSegment speakerSegment = (SpeakerSegment)((Paragraph)speakerDoc.getParagraphs().getFirst()).getSegments().getFirst();
            FXUtils.runOnePulseLater(() -> ((SpeakerSegment)speakerSegment).showSpeakerPopup());
        }
    }

    public static ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> getSpeakerDoc(Speaker speaker) {
        SpeakerSegment seg = new SpeakerSegment((Object)speaker.getUuid());
        return ReadOnlyStyledDocument.fromSegment((Object)seg, (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    @Generated
    private SpeakerUtils() {
    }
}

