/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.alerts;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.FXUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.Placement;
import eu.ewerkzeug.easytranscript3.commons.fx.Position;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.TutorialEvent;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Highlight;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialSection;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactfx.Change;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.Subscription;
import org.reactfx.SuspendableNo;
import org.reactfx.util.Either;
import org.reactfx.value.Val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@FxmlView(value="etTutorialModal.fxml")
public class ETTutorialModal {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETTutorialModal.class);
    private final SimpleIntegerProperty currentStep = new SimpleIntegerProperty(0);
    private final BooleanProperty isPopup = new SimpleBooleanProperty();
    private final EventSource<TutorialEvent> closingEvents = new EventSource();
    private final SimpleObjectProperty<TutorialSection> currentSection = new SimpleObjectProperty();
    private final SuspendableNo intentionalClosing = new SuspendableNo();
    @FXML
    private VBox container;
    @FXML
    private SVGPath arrow;
    @FXML
    private Button nextButton;
    @FXML
    private Button backButton;
    @FXML
    private Label content;
    @FXML
    private SpacedText headline;
    @FXML
    private HBox stepper;
    @FXML
    private VBox root;
    private Subscription listenerSubscription;
    private Subscription currentPositioningSubscription;
    private Subscription conditionForNextSubscription;
    private Stage stage;
    private Subscription closeSubscription;
    private int rootPadding = 0;

    public static ETTutorialModal createDialog(@NotNull Window owner, @NotNull TutorialSection startSection, boolean isPopup) {
        log.debug("Creating dialog...");
        try {
            ETTutorialModal etDialog = ETTutorialModal.loadScene((Window)owner);
            etDialog.currentSection.set((Object)startSection);
            etDialog.initStepListener();
            etDialog.initStyle(isPopup);
            EventStreams.changesOf((ObservableValue)etDialog.stage.showingProperty()).subscribeForOne(c -> etDialog.updateDialog());
            log.debug("Dialog created.");
            return etDialog;
        }
        catch (IOException exception) {
            log.error("Could not create dialog.", (Throwable)exception);
            ExceptionAlert.get().showModal();
            return null;
        }
    }

    @NotNull
    private static ETTutorialModal loadScene(@NotNull Window owner) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(ETTutorialModal.class.getClassLoader().getResource(ETTutorialModal.class.getPackageName().replace(".", "/") + "/etTutorialModal.fxml"));
        fxmlLoader.setResources(Utils.getLocaleBundle());
        Parent node = (Parent)fxmlLoader.load();
        ETTutorialModal etDialog = (ETTutorialModal)fxmlLoader.getController();
        Scene scene = new Scene(node);
        etDialog.stage = ETTutorialModal.initStage((Window)owner, (ETTutorialModal)etDialog, (Scene)scene);
        etDialog.backButton.managedProperty().bind((ObservableValue)etDialog.backButton.visibleProperty());
        Utils.setStyleSheets((Scene)scene);
        return etDialog;
    }

    @NotNull
    private static Stage initStage(@NotNull Window owner, ETTutorialModal etDialog, Scene scene) {
        Stage stage = new Stage();
        stage.initOwner(owner);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setResizable(false);
        stage.setScene(scene);
        stage.sizeToScene();
        etDialog.closeSubscription = EventStreams.eventsOf((Window)owner, (EventType)WindowEvent.WINDOW_CLOSE_REQUEST).suppressWhen((ObservableValue)etDialog.intentionalClosing).subscribe(closeRequest -> etDialog.cancel());
        if (Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
            stage.initStyle(StageStyle.TRANSPARENT);
            scene.setFill((Paint)Color.TRANSPARENT);
            etDialog.rootPadding = 5;
            etDialog.root.setPadding(new Insets(0.0, (double)etDialog.rootPadding, (double)etDialog.rootPadding, (double)etDialog.rootPadding));
        } else {
            stage.initStyle(StageStyle.UNDECORATED);
        }
        return stage;
    }

    private List<Integer> getLengthsOfPossiblePaths(List<TutorialSection> sections, boolean stopWhenBackNotPossible) {
        return this.getLengthsOfPossiblePaths(new TutorialSection(null, List.of(), sections, null), stopWhenBackNotPossible);
    }

    private List<Integer> getLengthsOfPossiblePaths(TutorialSection tutorialSection, boolean stopWhenBackNotPossible) {
        int size = 0;
        boolean goingBackNotAllowedFound = false;
        for (TutorialStep step : tutorialSection.getSteps()) {
            if (stopWhenBackNotPossible && step.getFlowControl() != null && !step.getFlowControl().isGoingBackAllowed()) {
                goingBackNotAllowedFound = true;
                break;
            }
            ++size;
        }
        if (tutorialSection.getNextSections().isEmpty() || stopWhenBackNotPossible && goingBackNotAllowedFound) {
            return List.of(Integer.valueOf(size));
        }
        ArrayList<Integer> returner = new ArrayList<Integer>();
        for (TutorialSection nextSection : tutorialSection.getNextSections()) {
            int finalSize = size;
            returner.addAll(this.getLengthsOfPossiblePaths(nextSection, stopWhenBackNotPossible).stream().map(steps -> steps + finalSize).toList());
        }
        return returner;
    }

    public void changeOwner(Window owner) {
        this.checkIfDialogIsInitialized();
        Scene scene = this.stage.getScene();
        boolean visible = this.stage.isShowing();
        try (Guard ignored = this.intentionalClosing.suspend();){
            this.stage.hide();
            this.stage.setScene(null);
            this.stage = ETTutorialModal.initStage((Window)owner, (ETTutorialModal)this, (Scene)scene);
            if (visible) {
                this.show();
            }
        }
        this.updateDialog();
    }

    public void show() {
        this.checkIfDialogIsInitialized();
        this.stage.show();
    }

    public boolean isShowing() {
        this.checkIfDialogIsInitialized();
        return this.stage.isShowing();
    }

    public void back() {
        this.checkIfDialogIsInitialized();
        if (this.currentStep.get() - 1 < 0) {
            TutorialSection previousSection = ((TutorialSection)this.currentSection.get()).getPreviousSection();
            if (previousSection != null) {
                this.currentSection.set((Object)previousSection);
                this.currentStep.set(((TutorialSection)this.currentSection.get()).getSteps().size() - 1);
            }
        } else {
            this.currentStep.set(this.currentStep.get() - 1);
        }
    }

    public void next() {
        this.checkIfDialogIsInitialized();
        log.debug("Triggered next.");
        if (this.currentStep.get() + 1 >= ((TutorialSection)this.currentSection.get()).getSteps().size()) {
            Optional<TutorialSection> firstThatMatchesCondition = ((TutorialSection)this.currentSection.get()).getNextSections().stream().filter(section -> section.getCondition() == null || (Boolean)section.getCondition().get() != false).findFirst();
            if (firstThatMatchesCondition.isEmpty()) {
                this.closingEvents.push((Object)TutorialEvent.FINISHED);
                this.close();
            } else {
                TutorialSection nextSection = firstThatMatchesCondition.get();
                nextSection.setPreviousSection((TutorialSection)this.currentSection.get());
                this.currentSection.set((Object)nextSection);
                this.currentStep.set(0);
                log.debug("Switched to next section.");
            }
        } else {
            this.currentStep.set(this.currentStep.get() + 1);
        }
    }

    public void cancel() {
        this.closingEvents.push((Object)TutorialEvent.CANCELLED);
        this.close();
    }

    private void initStyle(boolean isPopupBoolean) {
        this.isPopup.setValue(Boolean.valueOf(isPopupBoolean));
        this.arrow.managedProperty().bind((ObservableValue)this.isPopup);
        this.arrow.visibleProperty().bind((ObservableValue)this.isPopup);
        if (this.isPopup.get()) {
            this.container.getStyleClass().setAll((Object[])new String[]{"tutorial-popup"});
        } else {
            this.container.getStyleClass().setAll((Object[])new String[]{"tutorial-dialog"});
        }
    }

    private Pair<Integer, Integer> getStepsBeforeAndAfterCurrent() {
        TutorialSection section = (TutorialSection)this.currentSection.get();
        int previous = this.getReachableStepsBeforeCurrent(section);
        int following = this.getReachableStepsAfterCurrent();
        return new ImmutablePair((Object)previous, (Object)following);
    }

    private int getReachableStepsBeforeCurrent(TutorialSection section) {
        int previous = 0;
        while ((section = section.getPreviousSection()) != null) {
            boolean stepDoesNotAllowBack = false;
            for (int i = section.getSteps().size() - 1; i >= 0; --i) {
                ++previous;
                TutorialStep tutorialStep = (TutorialStep)section.getSteps().get(i);
                if (tutorialStep.getFlowControl() == null || tutorialStep.getFlowControl().isGoingBackAllowed()) continue;
                stepDoesNotAllowBack = true;
                break;
            }
            if (!stepDoesNotAllowBack) continue;
            break;
        }
        for (int i = 0; i <= this.currentStep.get(); ++i) {
            TutorialStep step = (TutorialStep)((TutorialSection)this.currentSection.get()).getSteps().get(i);
            if (step.getFlowControl() != null && !step.getFlowControl().isGoingBackAllowed()) {
                previous = 0;
            }
            if (i >= this.currentStep.get()) continue;
            ++previous;
        }
        return previous;
    }

    private int getReachableStepsAfterCurrent() {
        int following = 0;
        boolean reachedStopAfterCurrent = false;
        for (int i = this.currentStep.get() + 1; i < ((TutorialSection)this.currentSection.get()).getSteps().size(); ++i) {
            TutorialStep step = (TutorialStep)((TutorialSection)this.currentSection.get()).getSteps().get(i);
            if (step.getFlowControl() != null && !step.getFlowControl().isGoingBackAllowed()) {
                reachedStopAfterCurrent = true;
                continue;
            }
            ++following;
        }
        if (!reachedStopAfterCurrent) {
            following += ((Integer)Collections.min(this.getLengthsOfPossiblePaths(((TutorialSection)this.currentSection.get()).getNextSections(), true))).intValue();
        }
        return following;
    }

    private void updateStepper() {
        this.stepper.getChildren().clear();
        Pair stepsBeforeAtCurrentAndAfter = this.getStepsBeforeAndAfterCurrent();
        int previous = (Integer)stepsBeforeAtCurrentAndAfter.getLeft();
        int following = (Integer)stepsBeforeAtCurrentAndAfter.getRight();
        int total = previous + 1 + following;
        if (total == 1) {
            return;
        }
        IntStream.range(0, total).forEach(i -> {
            Rectangle stepperRectangle = new Rectangle(20.0, 6.0);
            this.stepper.getChildren().add((Object)stepperRectangle);
            if (i != previous) {
                stepperRectangle.getStyleClass().setAll((Object[])new String[]{"inactive-step"});
            } else {
                stepperRectangle.getStyleClass().setAll((Object[])new String[]{"active-step"});
            }
        });
    }

    private void initStepListener() {
        this.listenerSubscription = EventStreams.changesOf((ObservableValue)this.currentStep).or(EventStreams.changesOf((ObservableValue)this.currentSection)).subscribe(stepChange -> Platform.runLater(() -> this.updateDialog()));
    }

    private void updateDialog() {
        log.debug("Updating dialog ...");
        TutorialSection previousSection = ((TutorialSection)this.currentSection.get()).getPreviousSection();
        TutorialStep tutorialStep = (TutorialStep)((TutorialSection)this.currentSection.get()).getSteps().get(this.currentStep.get());
        boolean goingBackAllowed = tutorialStep.getFlowControl() == null || tutorialStep.getFlowControl().isGoingBackAllowed();
        this.backButton.setVisible(goingBackAllowed && (this.currentStep.get() > 0 || previousSection != null));
        if (tutorialStep.getContent() != null) {
            this.headline.setText(tutorialStep.getContent().getTitle());
            this.content.setText(tutorialStep.getContent().getDescription());
            this.backButton.setText(this.getSetStringOrDefault(tutorialStep.getContent().getBackButtonText(), Utils.getLocaleBundle().getString("general.back")));
            this.nextButton.setText(this.getSetStringOrDefault(tutorialStep.getContent().getNextButtonText(), Utils.getLocaleBundle().getString("general.next")));
        } else {
            log.error("No content defined in tutorial step.");
        }
        this.updateConditionForNextHandling(tutorialStep);
        this.updateStepper();
        this.updatePositionSubscription(tutorialStep.getHighlight());
    }

    private void updateConditionForNextHandling(TutorialStep tutorialStep) {
        if (this.conditionForNextSubscription != null) {
            this.conditionForNextSubscription.unsubscribe();
        }
        this.nextButton.disableProperty().unbind();
        if (tutorialStep.getFlowControl() != null && tutorialStep.getFlowControl().getConditionForNext() != null) {
            this.nextButton.disableProperty().bind((ObservableValue)Val.orElseConst((ObservableValue)((ObservableValue)tutorialStep.getFlowControl().getConditionForNext().get()), (Object)true).map(b -> b == false));
            if (tutorialStep.getFlowControl().isGoToNextImmediately()) {
                this.conditionForNextSubscription = EventStreams.changesOf((ObservableValue)((ObservableValue)tutorialStep.getFlowControl().getConditionForNext().get())).subscribeForOne(change -> this.next());
            }
        } else {
            this.nextButton.setDisable(false);
        }
    }

    private String getSetStringOrDefault(String text, String defaultText) {
        if (text == null || text.isBlank()) {
            return defaultText;
        }
        return text;
    }

    private void updatePositionSubscription(Highlight highlight) {
        if (this.currentPositioningSubscription != null) {
            this.currentPositioningSubscription.unsubscribe();
        }
        Node highlightNode = null;
        if (Highlight.isNodeHighlightable((Highlight)highlight)) {
            highlightNode = (Node)Utils.getFromNonNullableSupplier((Supplier)highlight.getNode());
        }
        if (highlightNode != null) {
            if (!this.isPopup.get()) {
                this.placeDialogNextToHighlight(highlight);
                this.currentPositioningSubscription = this.getPositioningStream(highlightNode).subscribe(bounds -> this.placeDialogNextToHighlight(highlight));
            } else {
                this.placePopupBelowHighlight(highlight);
                this.currentPositioningSubscription = this.getPositioningStream(highlightNode).subscribe(bounds -> this.placePopupBelowHighlight(highlight));
            }
        } else {
            this.centerDialog();
            this.currentPositioningSubscription = this.getPositioningStream(this.stage.getOwner().getScene().getWindow()).subscribe(bounds -> this.centerDialog());
        }
    }

    private void close() {
        if (this.stage != null) {
            this.stage.close();
        }
        if (this.listenerSubscription != null) {
            this.listenerSubscription.unsubscribe();
        }
        if (this.currentPositioningSubscription != null) {
            this.currentPositioningSubscription.unsubscribe();
        }
        if (this.conditionForNextSubscription != null) {
            this.conditionForNextSubscription.unsubscribe();
        }
        if (this.closeSubscription != null) {
            this.closeSubscription.unsubscribe();
        }
        this.stage = null;
    }

    private EventStream<Either<Either<Change<Bounds>, Change<Number>>, Change<Number>>> getPositioningStream(@NotNull Node node) {
        if (node.getScene() != null && node.getScene().getWindow() != null) {
            return EventStreams.changesOf((ObservableValue)node.boundsInParentProperty()).or(EventStreams.changesOf((ObservableValue)node.getScene().getWindow().xProperty())).or(EventStreams.changesOf((ObservableValue)node.getScene().getWindow().yProperty()));
        }
        log.warn("Cannot listen to positioning stream of node as the node is not a child of a scene or the scene was not added to a window.");
        return EventStreams.never();
    }

    private EventStream<Either<Either<Either<Change<Number>, Change<Number>>, Change<Number>>, Change<Number>>> getPositioningStream(Window window) {
        return EventStreams.changesOf((ObservableValue)window.widthProperty()).or(EventStreams.changesOf((ObservableValue)window.heightProperty())).or(EventStreams.changesOf((ObservableValue)window.xProperty())).or(EventStreams.changesOf((ObservableValue)window.yProperty()));
    }

    private void placeDialogNextToHighlight(@NotNull Highlight highlight) {
        Bounds highlightBounds = this.getHighlightBounds(highlight);
        if (highlightBounds == null) {
            return;
        }
        int distanceToHighlight = 6;
        Placement placement = new Placement((Window)this.stage, highlightBounds, this.rootPadding - distanceToHighlight, 0);
        Double x = this.getPositionViaPriorities(placement, List.of(Double.valueOf(placement.toTheRight()), Double.valueOf(placement.toTheLeft()), Double.valueOf(placement.insideRight()), Double.valueOf(placement.insideLeft())), false);
        ArrayList<Double> positionPriorities = new ArrayList<Double>(List.of(Double.valueOf(placement.above()), Double.valueOf(placement.below()), Double.valueOf(placement.insideBottom()), Double.valueOf(placement.insideTop())));
        if (placement.getWindow().getHeight() > placement.getToAlignTo().getHeight()) {
            Collections.swap(positionPriorities, 0, 1);
        }
        this.stage.setX(x.doubleValue());
        this.stage.setY(this.getPositionViaPriorities(placement, positionPriorities, true).doubleValue());
    }

    @Nullable
    private Bounds getHighlightBounds(@NotNull Highlight highlight) {
        Node highlightNode = (Node)Utils.getFromNonNullableSupplier((Supplier)highlight.getNode());
        Bounds highlightBounds = FXUtils.addRectangleToBounds((Bounds)highlightNode.localToScreen(highlightNode.getBoundsInLocal()), highlight.getTransformation() != null ? (Rectangle)highlight.getTransformation().get() : null);
        if (highlightBounds == null) {
            log.warn("Highlight bounds are null. Is the highlight not visible yet?");
            this.centerDialog();
            return null;
        }
        return highlightBounds;
    }

    private Double getPositionViaPriorities(Placement placement, List<Double> priorities, boolean vertical) {
        Double pos = null;
        DoubleFunction<Position> getPosition = position -> {
            if (vertical) {
                return placement.getVerticalOverlap(Double.valueOf(position));
            }
            return placement.getHorizontalOverlap(Double.valueOf(position));
        };
        for (Double position2 : priorities) {
            if (getPosition.apply(position2) != null) continue;
            pos = position2;
            break;
        }
        if (pos == null) {
            pos = priorities.get(priorities.size() - 1);
        }
        return pos;
    }

    private void placePopupBelowHighlight(@NotNull Highlight highlight) {
        Bounds boundsInScreen = this.getHighlightBounds(highlight);
        if (boundsInScreen == null) {
            return;
        }
        int distanceToHighlight = 10;
        this.stage.setX(boundsInScreen.getCenterX() - VBox.getMargin((Node)this.arrow).getLeft() - this.arrow.getBoundsInLocal().getWidth() / 2.0);
        this.stage.setY(boundsInScreen.getMaxY() + (double)distanceToHighlight);
    }

    private void centerDialog() {
        this.stage.setX(this.stage.getOwner().getX() + this.stage.getOwner().getWidth() / 2.0 - this.stage.getWidth() / 2.0);
        this.stage.setY(this.stage.getOwner().getY() + this.stage.getOwner().getHeight() / 2.0 - this.stage.getHeight() / 2.0 - (double)this.rootPadding);
    }

    private void checkIfDialogIsInitialized() {
        if (this.stage == null) {
            throw new IllegalStateException("Dialog is already closed or was never initialized.");
        }
    }

    @Generated
    public SimpleIntegerProperty getCurrentStep() {
        return this.currentStep;
    }

    @Generated
    public BooleanProperty getIsPopup() {
        return this.isPopup;
    }

    @Generated
    public EventSource<TutorialEvent> getClosingEvents() {
        return this.closingEvents;
    }

    @Generated
    public SimpleObjectProperty<TutorialSection> getCurrentSection() {
        return this.currentSection;
    }
}

