/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.DurationPicker;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationPicker
extends HBox {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DurationPicker.class);
    @FXML
    private JFXTextField hourTextField;
    @FXML
    private JFXTextField minuteTextField;
    @FXML
    private JFXTextField secondTextField;
    @FXML
    private JFXTextField millisecondTextField;

    public DurationPicker() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setLocation(this.getClass().getClassLoader().getResource(this.getClass().getPackageName().replace(".", "/") + "/durationPicker.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setResources(Utils.getLocaleBundle());
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.hourTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.hourTextField, 2, 24));
        this.minuteTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.minuteTextField, 2, 59));
        this.secondTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.secondTextField, 2, 59));
        this.millisecondTextField.textProperty().addListener((ChangeListener)new EnsuresOnlyDigitsListener((TextField)this.millisecondTextField, 3, 999));
        this.hourTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.hourTextField));
        this.minuteTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.minuteTextField));
        this.secondTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.secondTextField));
        this.millisecondTextField.focusedProperty().addListener((ChangeListener)new EnsuresNotEmptyListener((TextField)this.millisecondTextField));
        List<TextField> collect = this.getChildren().stream().filter(f -> f instanceof TextField).map(f -> (TextField)f).toList();
        for (TextField node : collect) {
            node.setOnKeyPressed(event -> {
                if (event.getCode() == KeyCode.UP) {
                    this.modifyNumberOfTextField(node, 1);
                } else if (event.getCode() == KeyCode.DOWN) {
                    this.modifyNumberOfTextField(node, -1);
                }
            });
        }
    }

    public Duration getDuration() {
        return Duration.ofMillis((long)Integer.parseInt(this.millisecondTextField.getText()) + (long)Integer.parseInt(this.secondTextField.getText()) * 1000L + (long)Integer.parseInt(this.minuteTextField.getText()) * 1000L * 60L + (long)Integer.parseInt(this.hourTextField.getText()) * 1000L * 60L * 60L);
    }

    private void modifyNumberOfTextField(TextField node, int add) {
        try {
            node.setText("" + (Integer.valueOf(node.getText()) + add));
        }
        catch (NumberFormatException e) {
            node.setText("00");
            log.debug("Could not modify number.", (Throwable)e);
        }
    }
}

