/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.PopOverControls;
import java.io.IOException;
import javafx.animation.FadeTransition;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.jetbrains.annotations.NotNull;
import org.reactfx.Change;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Either;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@FxmlView(value="etPopOver.fxml")
public class ETPopOver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETPopOver.class);
    private final SimpleBooleanProperty showArrow = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty closeOnFocusLost = new SimpleBooleanProperty(true);
    private final SimpleDoubleProperty width = new SimpleDoubleProperty(310.0);
    @FXML
    private VBox container;
    @FXML
    private VBox content;
    @FXML
    private SVGPath arrow;
    @FXML
    private VBox root;
    private Stage stage;
    private int rootPadding = 0;
    private Node highlight;
    private Subscription positioningSubscription;

    public static ETPopOver create(@NotNull Window owner, Node highlight) {
        log.debug("Creating dialog...");
        try {
            ETPopOver etDialog = ETPopOver.loadScene((Window)owner);
            etDialog.highlight = highlight;
            log.debug("Dialog created.");
            return etDialog;
        }
        catch (IOException exception) {
            log.error("Could not open etPopOver.", (Throwable)exception);
            ExceptionAlert.get().showModal();
            return null;
        }
    }

    public static ETPopOver showSnackbar(String title, String content, java.time.Duration duration) {
        ETPopOver etPopOver = ETPopOver.create((Window)GUIState.getMainStage(), null);
        if (etPopOver == null) {
            return null;
        }
        etPopOver.setWidth(450.0);
        etPopOver.setShowArrow(false);
        etPopOver.setCloseOnFocusLost(false);
        etPopOver.getContent().getChildren().addAll((Object[])new Node[]{PopOverControls.createHeadline((String)title), PopOverControls.createText((String)content)});
        etPopOver.show();
        FadeTransition ft = new FadeTransition(Duration.millis((double)300.0), (Node)etPopOver.getRoot());
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.play();
        FxTimer.runLater((java.time.Duration)duration, () -> {
            FadeTransition fadeOut = new FadeTransition(Duration.millis((double)300.0), (Node)etPopOver.getRoot());
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            fadeOut.play();
            fadeOut.setOnFinished(e -> etPopOver.hide());
        });
        return etPopOver;
    }

    @NotNull
    private static ETPopOver loadScene(@NotNull Window owner) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(ETPopOver.class.getClassLoader().getResource(ETPopOver.class.getPackageName().replace(".", "/") + "/etPopOver.fxml"));
        fxmlLoader.setResources(Utils.getLocaleBundle());
        Parent node = (Parent)fxmlLoader.load();
        ETPopOver etPopOver = (ETPopOver)fxmlLoader.getController();
        Scene scene = new Scene(node);
        etPopOver.stage = ETPopOver.initStage((Window)owner, (ETPopOver)etPopOver, (Scene)scene);
        Utils.setStyleSheets((Scene)scene);
        return etPopOver;
    }

    @NotNull
    private static Stage initStage(@NotNull Window owner, ETPopOver etPopOver, Scene scene) {
        if (etPopOver.stage != null) {
            throw new IllegalStateException("State is already initialized.");
        }
        Stage stage = new Stage();
        stage.initOwner(owner);
        stage.setResizable(false);
        stage.setScene(scene);
        stage.sizeToScene();
        EventStreams.changesOf((ObservableValue)stage.focusedProperty()).subscribe(focused -> {
            if (!((Boolean)focused.getNewValue()).booleanValue() && etPopOver.closeOnFocusLost.get()) {
                stage.hide();
            }
        });
        etPopOver.arrow.visibleProperty().bind((ObservableValue)etPopOver.showArrow);
        etPopOver.container.prefWidthProperty().bind((ObservableValue)etPopOver.widthProperty());
        if (Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
            stage.initStyle(StageStyle.TRANSPARENT);
            scene.setFill((Paint)Color.TRANSPARENT);
            etPopOver.rootPadding = 5;
            etPopOver.root.setPadding(new Insets(0.0, (double)etPopOver.rootPadding, (double)etPopOver.rootPadding, (double)etPopOver.rootPadding));
        } else {
            stage.initStyle(StageStyle.UNDECORATED);
        }
        return stage;
    }

    public void show() throws IllegalStateException {
        this.checkIfDialogIsInitialized();
        this.stage.show();
        this.stage.toFront();
        if (this.positioningSubscription == null) {
            VBox.setMargin((Node)this.arrow, (Insets)new Insets(0.0, 0.0, 0.0, this.stage.getWidth() - 60.0));
            this.updatePositionSubscription();
        }
        this.stage.setOnHidden(windowEvent -> {
            this.positioningSubscription.unsubscribe();
            this.positioningSubscription = null;
        });
    }

    public void hide() throws IllegalStateException {
        this.checkIfDialogIsInitialized();
        this.stage.hide();
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    private void updatePositionSubscription() {
        if (this.highlight != null) {
            this.placePopupAboveHighlight(this.highlight);
            this.positioningSubscription = this.getPositioningStream(this.highlight).subscribe(bounds -> this.placePopupAboveHighlight(this.highlight));
        } else {
            this.placePopupInOwner();
            this.positioningSubscription = this.getPositioningStream((Node)this.stage.getOwner().getScene().getRoot()).subscribe(bounds -> this.placePopupInOwner());
        }
    }

    private EventStream<Either<Either<Change<Bounds>, Change<Number>>, Change<Number>>> getPositioningStream(Node node) {
        return EventStreams.changesOf((ObservableValue)node.boundsInParentProperty()).or(EventStreams.changesOf((ObservableValue)node.getScene().getWindow().xProperty())).or(EventStreams.changesOf((ObservableValue)node.getScene().getWindow().yProperty()));
    }

    private void placePopupAboveHighlight(@NotNull Node highlight) {
        Bounds boundsInScreen = highlight.localToScreen(highlight.getBoundsInLocal());
        int distanceToHighlight = -5;
        this.stage.setX(boundsInScreen.getCenterX() - VBox.getMargin((Node)this.arrow).getLeft() - this.arrow.getBoundsInLocal().getWidth() / 1.5);
        this.stage.setY(boundsInScreen.getMinY() - this.stage.getHeight() - (double)distanceToHighlight);
    }

    private void placePopupInOwner() {
        Window owner = this.stage.getOwner();
        Rectangle bounds = new Rectangle(owner.getX(), owner.getY(), owner.getWidth(), owner.getHeight());
        int distanceToHighlight = -5;
        this.stage.setX(bounds.getX() + bounds.getWidth() / 2.0 - this.stage.getWidth() / 2.0);
        this.stage.setY(bounds.getY() + this.stage.getHeight() + (double)distanceToHighlight);
    }

    private void checkIfDialogIsInitialized() {
        if (this.stage == null) {
            throw new IllegalStateException("Dialog is already closed or was never initialized.");
        }
    }

    public boolean getShowArrow() {
        return this.showArrow.get();
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow.set(showArrow);
    }

    public SimpleBooleanProperty showArrowProperty() {
        return this.showArrow;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost.get();
    }

    public void setCloseOnFocusLost(boolean closeOnFocusLost) {
        this.closeOnFocusLost.set(closeOnFocusLost);
    }

    public SimpleBooleanProperty closeOnFocusLostProperty() {
        return this.closeOnFocusLost;
    }

    public double getWidth() {
        return this.width.get();
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public SimpleDoubleProperty widthProperty() {
        return this.width;
    }

    @Generated
    public VBox getContent() {
        return this.content;
    }

    @Generated
    public VBox getRoot() {
        return this.root;
    }
}

