/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.ProgressBarSkin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import lombok.Generated;
import org.reactfx.EventStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETProgressBar
extends AnchorPane {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETProgressBar.class);
    private final BooleanProperty changeable = new SimpleBooleanProperty(true);
    @FXML
    private Slider progressSlider;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Pane progressPane;
    private Rectangle progressPaneClip;

    public ETProgressBar() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setLocation(this.getClass().getClassLoader().getResource(this.getClass().getPackageName().replace(".", "/") + "/etProgressBar.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setResources(Utils.getLocaleBundle());
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        EventStreams.changesOf((ObservableValue)this.progressBar.skinProperty()).subscribeForOne(skinChange -> {
            ProgressBarSkin skin = (ProgressBarSkin)this.progressBar.getSkin();
            Node bar = (Node)skin.getChildren().get(1);
            this.progressPaneClip = new Rectangle(bar.getLayoutBounds().getWidth(), 20.0);
            this.progressPaneClip.setLayoutX(bar.getLayoutX());
            this.progressPaneClip.setLayoutY(bar.getLayoutY());
            this.progressPane.setClip((Node)this.progressPaneClip);
            this.progressPane.setViewOrder(-100.0);
        });
        this.progressSlider.valueProperty().addListener((observableValue, number, newValue) -> Platform.runLater(() -> {
            if (!this.progressSlider.isValueChanging()) {
                this.progressBar.setProgress((Double)newValue / this.progressSlider.getMax());
            }
            this.progressPaneClip.setWidth(this.progressSlider.getWidth() * this.progressSlider.getValue() / this.progressSlider.getMax());
        }));
        this.progressSlider.setOnMousePressed(event -> {
            if (!this.isChangeable()) {
                return;
            }
            this.progressSlider.setValueChanging(true);
            double value = event.getX() / this.progressSlider.getWidth() * this.progressSlider.getMax();
            this.progressSlider.setValue(value);
        });
        this.progressSlider.setOnMouseReleased(event -> {
            if (!this.isChangeable()) {
                return;
            }
            this.progressSlider.setValueChanging(false);
        });
        this.progressSlider.mouseTransparentProperty().bind((ObservableValue)this.changeable.not());
        this.progressSlider.setCursor(Cursor.HAND);
    }

    public double getValue() {
        return this.progressSlider.getValue();
    }

    public void setValue(double value) {
        this.progressSlider.setValue(value);
        this.progressBar.setProgress(value);
    }

    public DoubleProperty valueProperty() {
        return this.progressSlider.valueProperty();
    }

    public BooleanProperty valueChangingProperty() {
        return this.progressSlider.valueChangingProperty();
    }

    public boolean isValueChanging() {
        return this.progressSlider.isValueChanging();
    }

    public void setMax(double max) {
        this.progressSlider.setMax(max);
    }

    public boolean isChangeable() {
        return this.changeable.get();
    }

    public void setChangeable(boolean changeable) {
        this.changeable.setValue(Boolean.valueOf(changeable));
    }

    public BooleanProperty changeableProperty() {
        return this.changeable;
    }

    @Generated
    public Slider getProgressSlider() {
        return this.progressSlider;
    }

    @Generated
    public ProgressBar getProgressBar() {
        return this.progressBar;
    }
}

