/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXComboBox;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.CustomJFXComboBox;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextFormattingControl
extends VBox {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextFormattingControl.class);
    public SimpleBooleanProperty hideAlignment = new SimpleBooleanProperty(false);
    @FXML
    private CustomJFXComboBox<String> textFontComboBox;
    @FXML
    private CustomJFXComboBox<String> textFontSizeComboBox;
    @FXML
    private ToggleButton textBoldToggleButton;
    @FXML
    private ToggleButton textItalicToggleButton;
    @FXML
    private ToggleButton textUnderlineToggleButton;
    @FXML
    private HBox textOrientationHBox;
    @FXML
    private ToggleButton textLeftToRightToggleButton;
    @FXML
    private ToggleButton textCenterToggleButton;
    @FXML
    private ToggleButton textJustifyToggleButton;
    @FXML
    private ToggleButton textRightToLeftToggleButton;
    @FXML
    private VBox root;
    @FXML
    private ToggleGroup textOrientationToggleGroup;

    public TextFormattingControl() {
        this(false);
    }

    public TextFormattingControl(@NamedArg(value="hideAlignment", defaultValue="false") boolean hideAlignment) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setLocation(this.getClass().getClassLoader().getResource(this.getClass().getPackageName().replace(".", "/") + "/textFormatting.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setResources(Utils.getLocaleBundle());
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.textOrientationToggleGroup = new ToggleGroup();
        this.textOrientationToggleGroup.getToggles().add((Object)this.textLeftToRightToggleButton);
        this.textOrientationToggleGroup.getToggles().add((Object)this.textRightToLeftToggleButton);
        this.textOrientationToggleGroup.getToggles().add((Object)this.textCenterToggleButton);
        this.textOrientationToggleGroup.getToggles().add((Object)this.textJustifyToggleButton);
        this.textOrientationToggleGroup.selectToggle((Toggle)this.textLeftToRightToggleButton);
        this.textOrientationToggleGroup.selectedToggleProperty().addListener((obsVal, oldVal, newVal) -> {
            if (newVal == null) {
                oldVal.setSelected(true);
            }
        });
        this.textOrientationHBox.managedProperty().bind((ObservableValue)this.hideAlignmentProperty().not());
        this.textOrientationHBox.visibleProperty().bind((ObservableValue)this.hideAlignmentProperty().not());
        ObservableList fonts = FXCollections.observableList((List)Utils.getFontFamilies());
        this.textFontComboBox.getItems().addAll((Object[])((String[])fonts.toArray((Object[])new String[0])));
        this.textFontSizeComboBox.getItems().addAll(Utils.getFontSizes().stream().map(String::valueOf).toList());
        TextFormattingControl.addAutoCompletePopup((JFXComboBox)this.textFontComboBox);
        this.textFontComboBox.getEditor().focusedProperty().addListener((observableValue, aBoolean, t1) -> {
            if (!t1.booleanValue()) {
                this.ensureSetFontExists();
            }
        });
        this.setHideAlignment(hideAlignment);
    }

    public void ensureSetFontExists() {
        String font = this.textFontComboBox.getEditor().getText();
        if (TranscriptTextArea.get().getSelection().getLength() > 0 && font.equals(Utils.getLocaleBundle().getString("drawer.fontsMixed"))) {
            return;
        }
        if (!this.textFontComboBox.getItems().contains((Object)font)) {
            if (this.textFontComboBox.getItems().contains((Object)"Monospaced")) {
                this.textFontComboBox.setValue((Object)"Monospaced");
            } else if (this.textFontComboBox.getItems().contains((Object)"Arial")) {
                this.textFontComboBox.setValue((Object)"Arial");
            } else {
                this.textFontComboBox.setValue((Object)((String)this.textFontComboBox.getItems().getFirst()));
            }
        }
    }

    public static <T> JFXAutoCompletePopup<T> addAutoCompletePopup(JFXComboBox<T> combobox) {
        JFXAutoCompletePopup autoCompletePopup = new JFXAutoCompletePopup();
        autoCompletePopup.setFixedCellSize(36.0);
        autoCompletePopup.getSuggestions().addAll((Collection)combobox.getItems());
        autoCompletePopup.setSelectionHandler(event -> combobox.setValue(event.getObject()));
        TextField editor = combobox.getEditor();
        editor.addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.ESCAPE || event.getCode() == KeyCode.ENTER) {
                event.consume();
            } else if (!event.getCode().isArrowKey() && !editor.getText().isEmpty()) {
                autoCompletePopup.filter(item -> item.toString().toLowerCase().contains(editor.getText().toLowerCase()));
                if (autoCompletePopup.getFilteredSuggestions().isEmpty()) {
                    autoCompletePopup.hide();
                } else {
                    autoCompletePopup.show((Node)editor);
                    combobox.hide();
                }
            }
        });
        combobox.showingProperty().addListener((observableValue, aBoolean, t1) -> {
            if (t1.booleanValue()) {
                autoCompletePopup.hide();
            }
        });
        return autoCompletePopup;
    }

    public final boolean isHideAlignment() {
        return this.hideAlignmentProperty().get();
    }

    public final void setHideAlignment(boolean hideAlignment) {
        this.hideAlignmentProperty().set(hideAlignment);
    }

    public final SimpleBooleanProperty hideAlignmentProperty() {
        return this.hideAlignment;
    }

    public int getFontSizeValue() {
        String value = (String)this.textFontSizeComboBox.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 12;
        }
    }

    public void setFontSizeValue(int number) {
        this.textFontSizeComboBox.setValue((Object)String.valueOf(number));
    }

    @Generated
    public SimpleBooleanProperty getHideAlignment() {
        return this.hideAlignment;
    }

    @Generated
    public CustomJFXComboBox<String> getTextFontComboBox() {
        return this.textFontComboBox;
    }

    @Generated
    public CustomJFXComboBox<String> getTextFontSizeComboBox() {
        return this.textFontSizeComboBox;
    }

    @Generated
    public ToggleButton getTextBoldToggleButton() {
        return this.textBoldToggleButton;
    }

    @Generated
    public ToggleButton getTextItalicToggleButton() {
        return this.textItalicToggleButton;
    }

    @Generated
    public ToggleButton getTextUnderlineToggleButton() {
        return this.textUnderlineToggleButton;
    }

    @Generated
    public HBox getTextOrientationHBox() {
        return this.textOrientationHBox;
    }

    @Generated
    public ToggleButton getTextLeftToRightToggleButton() {
        return this.textLeftToRightToggleButton;
    }

    @Generated
    public ToggleButton getTextCenterToggleButton() {
        return this.textCenterToggleButton;
    }

    @Generated
    public ToggleButton getTextJustifyToggleButton() {
        return this.textJustifyToggleButton;
    }

    @Generated
    public ToggleButton getTextRightToLeftToggleButton() {
        return this.textRightToLeftToggleButton;
    }

    @Generated
    public VBox getRoot() {
        return this.root;
    }

    @Generated
    public ToggleGroup getTextOrientationToggleGroup() {
        return this.textOrientationToggleGroup;
    }
}

