/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.SpeakerPopup;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import lombok.Generated;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeakerSegment
extends AbstractSegment<Object>
implements HasPreDefinedStyle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerSegment.class);
    public static final String TAG = "Speaker";
    public static final String UUID_ATTRIBUTE = "uuid";
    private String text = "";
    private String uuid = "";
    private Label item;

    public SpeakerSegment(Object data) {
        super(data);
        Speaker speaker;
        if (data instanceof UUID) {
            this.uuid = data.toString();
        } else if (data instanceof String) {
            String string;
            this.uuid = string = (String)data;
        }
        if (this.uuid != null && (speaker = this.findSpeaker()) != null) {
            this.text = speaker.getName();
        }
    }

    private Speaker findSpeaker() {
        Optional<Speaker> first = Transcript.get().getSpeakers().stream().filter(f -> f.getUuid().toString().equals(this.uuid)).findFirst();
        return first.orElse(null);
    }

    public Node createNode(TextStyle style) {
        this.item = new Label(this.text);
        Nodes.addInputMap((Node)this.item, (InputMap)InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.PRIMARY).onlyIf(f -> TranscriptTextArea.get().getSelection().getLength() == 0), e -> this.showSpeakerPopup()));
        this.item.getStyleClass().add((Object)"speaker");
        this.updateStyle();
        this.item.setUserData(this.getData());
        return this.item;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void updateStyle() {
        if (this.item != null) {
            this.item.setStyle(Transcript.get().getSpeakerTextStyle().toCss());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpeakerSegment)) {
            return false;
        }
        SpeakerSegment that = (SpeakerSegment)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return "SpeakerSegment{uuid='" + this.uuid + "'}";
    }

    public void showSpeakerPopup() {
        Speaker speaker = this.findSpeaker();
        if (speaker == null) {
            log.warn("Did not find any speaker with uuid {}", (Object)this.uuid);
            speaker = (Speaker)Transcript.get().getSpeakers().getFirst();
        }
        ArrayList<Speaker> list = new ArrayList<Speaker>();
        int startIndex = Transcript.get().getSpeakers().indexOf(speaker);
        while (list.size() < Transcript.get().getSpeakers().size()) {
            list.add((Speaker)Transcript.get().getSpeakers().get(startIndex));
            startIndex = (startIndex + 1) % Transcript.get().getSpeakers().size();
        }
        if (list.size() > 1) {
            SpeakerPopup.getInstance().setSpeakers(list);
            SpeakerPopup.getInstance().show(this);
        }
    }

    public Label getLabel() {
        return this.item;
    }

    public String getRealText() {
        return this.text + " ";
    }

    public TextStyle getTextStyle() {
        return Transcript.get().getSpeakerTextStyle();
    }

    @Generated
    public Label getItem() {
        return this.item;
    }
}

