/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.net.URISyntaxException;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import lombok.Generated;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimestampSegment
extends AbstractSegment<Object>
implements HasPreDefinedStyle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimestampSegment.class);
    public static final String TAG = "Timestamp";
    public static final String MS_ATTRIBUTE = "ms";
    private static TextStyle timestampTextStyle;
    private String text;
    private long millis;
    private Label item;

    public TimestampSegment(Object millis) {
        super(millis);
        if (millis instanceof Long) {
            Long time = (Long)millis;
            this.millis = time;
            this.text = Utils.millisToTimestamp((long)time);
        }
    }

    private static TextStyle getTimestampTextStyle() {
        if (timestampTextStyle == null) {
            timestampTextStyle = new TextStyle();
            try {
                timestampTextStyle = timestampTextStyle.updateTextColor((Color)Utils.getCssVariable((String)"-fx-highlight-timestamp")).updateFontFamily("Monospaced").updateFontSize(10);
            }
            catch (URISyntaxException e) {
                log.error("Could not create timestamp style.", (Throwable)e);
                ExceptionAlert.get().showModal();
            }
        }
        return timestampTextStyle;
    }

    public Node createNode(TextStyle style) {
        this.item = new Label(this.text);
        this.item.getStyleClass().add((Object)"timestamp");
        this.item.setStyle(TimestampSegment.getTimestampTextStyle().toCss());
        this.item.setUserData(this.getData());
        Nodes.addInputMap((Node)this.item, (InputMap)InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.PRIMARY).onlyIf(f -> TranscriptTextArea.get().getSelection().getLength() == 0), event -> {
            log.debug("Clicked on timestamp, ms: {}", (Object)this.millis);
            Main.getPlayer().setTime(this.millis);
            Main.getPlayer().play();
        }));
        return this.item;
    }

    public void updateFormat() {
        this.item.setText(Utils.millisToTimestamp((long)this.millis));
    }

    public long getMillis() {
        return this.millis;
    }

    public String getRealText() {
        return " " + this.text + " ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimestampSegment)) {
            return false;
        }
        TimestampSegment that = (TimestampSegment)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.millis == that.millis;
    }

    public int hashCode() {
        return Objects.hash(this.millis);
    }

    public TextStyle getTextStyle() {
        return TimestampSegment.getTimestampTextStyle();
    }

    @Generated
    public Label getItem() {
        return this.item;
    }
}

