/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.io.ETReplaceExistingFailedException;
import eu.ewerkzeug.easytranscript3.commons.io.ZipService;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Lazy
public class SaveTranscriptService
extends Service<Boolean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveTranscriptService.class);
    private final StatusService statusService;
    private final LicenseService licenseService;
    private final ZipService zipService;
    private final ExecutorService executorService;
    private final List<Triple<Transcript, String, Boolean>> queue = new ArrayList();
    private Transcript transcript;
    private String richDocument;
    private boolean isShallowCopy;

    @PostConstruct
    public void setup() {
        this.setOnFailed(workerStateEvent -> {
            log.error("SaveTranscriptService has failed.", this.getException());
            this.getNextAndStart();
        });
        this.setOnSucceeded(workerStateEvent -> this.getNextAndStart());
    }

    protected Task<Boolean> createTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Pair<Long, Long> getAvailableAndNeededSpace(Transcript transcript) throws IOException {
        if (transcript.getTranscriptLocation() == null) {
            log.warn("Transcript location is null. Could not determine available and needed space.");
            return null;
        }
        if (!transcript.getTranscriptLocation().toFile().exists()) {
            log.warn("Transcript file does not exist. Could not determine needed space.");
        }
        FileStore fileStore = Files.getFileStore(transcript.getTranscriptLocation());
        long availableSpace = fileStore.getUsableSpace();
        long neededSpace = this.getEstimatedFileSize(transcript);
        log.debug("Space needed: {}, space available: {}", (Object)neededSpace, (Object)availableSpace);
        return new ImmutablePair((Object)availableSpace, (Object)neededSpace);
    }

    private long getEstimatedFileSize(Transcript transcript) {
        Path mediaLocation = transcript.getMediaLocation();
        if (mediaLocation.getParent() == null) {
            mediaLocation = transcript.getTemporaryTranscriptLocation().resolve(transcript.getMediaLocation());
        }
        Path transcriptLocation = transcript.getTemporaryDocumentLocation();
        Path propertiesLocation = transcript.getTemporaryPropertiesLocation();
        return Stream.of(mediaLocation, transcriptLocation, propertiesLocation).filter(p -> p.toFile().exists()).map(p -> FileUtils.sizeOf((File)p.toFile())).reduce(0L, Long::sum);
    }

    private boolean saveAction(Transcript transcript, String richDocument) {
        log.debug("Started transcript save action.");
        boolean returner = false;
        if (transcript == null) {
            transcript = this.transcript;
        }
        if (richDocument == null) {
            richDocument = this.richDocument;
        }
        if (transcript == null) {
            log.warn("Transcript is not set.");
            Platform.runLater(() -> this.statusService.setSaving(false));
            return false;
        }
        if (transcript.getUuid().isBlank()) {
            log.error("Transcript uuid is empty!");
            Platform.runLater(() -> this.statusService.setSaving(false));
            ExceptionAlert.get().showModal();
            return false;
        }
        try {
            Pair spaceLeftAndNeeded = this.getAvailableAndNeededSpace(transcript);
            if (spaceLeftAndNeeded != null && (Long)spaceLeftAndNeeded.getLeft() < (Long)spaceLeftAndNeeded.getRight()) {
                log.warn("Not enough space left on device.");
                Platform.runLater(() -> ETDialog.get((String)MessageFormat.format(Utils.getLocaleBundle().getString("problems.notEnoughSpace"), FileUtils.byteCountToDisplaySize((Number)((Number)spaceLeftAndNeeded.getLeft())), FileUtils.byteCountToDisplaySize((Number)((Number)spaceLeftAndNeeded.getRight())))).showAndWait());
                return false;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            log.error("Could not determine if there is enough space left on device.", (Throwable)e);
        }
        Platform.runLater(() -> {
            this.statusService.setSaving(true);
            this.statusService.setSavingProgress(0);
        });
        try {
            log.debug("Setting transcript properties...");
            if (transcript.getTranscriptLocation() == null) {
                Platform.runLater(() -> this.statusService.setSaving(false));
                log.warn("Transcript location unset. Not saved.");
                return false;
            }
            if (Main.getPlayer() != null && Main.getPlayer().getMediaPlayer() != null) {
                transcript.setLastPlayerTime(Main.getPlayer().getTime());
            }
            transcript.setUsedETVersion(Configuration.get().getVersion());
            transcript.getAuthor().add(Configuration.get().getAuthor());
            ArrayList<File> toZip = new ArrayList<File>();
            toZip.add(transcript.getTemporaryPropertiesLocation().toFile());
            toZip.add(transcript.getTemporaryDocumentLocation().toFile());
            Platform.runLater(() -> this.statusService.setSavingProgress(5));
            if (!this.isShallowCopy) {
                this.copyMediaFile(transcript);
                toZip.add(transcript.getTemporaryTranscriptLocation().resolve(transcript.getMediaLocation()).toFile());
            }
            Platform.runLater(() -> this.statusService.setSavingProgress(15));
            returner = transcript.saveProperties();
            Platform.runLater(() -> this.statusService.setSavingProgress(20));
            if (richDocument != null) {
                transcript.setDocument(richDocument);
            } else {
                transcript.setDocument("");
                log.warn("Rich document is null.");
            }
            Platform.runLater(() -> this.statusService.setSavingProgress(25));
            Files.writeString(transcript.getTemporaryDocumentLocation(), (CharSequence)transcript.getDocument(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            Platform.runLater(() -> this.statusService.setSavingProgress(35));
            this.zipService.zipFiles(toZip, transcript.getTranscriptLocation().toFile());
            Platform.runLater(() -> this.statusService.setSavingProgress(95));
            if (!this.isShallowCopy) {
                Platform.runLater(() -> {
                    this.statusService.setRecovered(false);
                    this.statusService.setSaved(true);
                });
            }
            Platform.runLater(() -> this.statusService.setSavingProgress(100));
        }
        catch (Exception e) {
            if (e instanceof ETReplaceExistingFailedException) {
                Platform.runLater(() -> ETDialog.get((String)Utils.getLocaleBundle().getString("problems.cannotSaveFileExists")).showAndWait());
            }
            if (e instanceof NoSuchFileException) {
                log.error("", (Throwable)e);
                Platform.runLater(() -> ETDialog.get((String)Utils.getLocaleBundle().getString("problems.cannotSaveFileDestinationDoesNotExist")).showAndWait());
            }
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
        Platform.runLater(() -> this.statusService.setSaving(false));
        log.info("Transcript save action completed. Response is {}", (Object)returner);
        return returner;
    }

    private void copyMediaFile(Transcript transcript) throws IOException {
        Path mediaLocation = transcript.getMediaLocation();
        if (mediaLocation.getParent() == null) {
            return;
        }
        String extension = StringUtils.getFilenameExtension((String)mediaLocation.toString());
        Path newLocation = transcript.getTemporaryTranscriptLocation().resolve("media." + extension);
        Files.createDirectories(newLocation.getParent(), new FileAttribute[0]);
        Files.copy(mediaLocation, newLocation, StandardCopyOption.REPLACE_EXISTING);
        transcript.setMediaLocation(newLocation.getFileName());
    }

    public void save(Transcript transcript, String richDocument, boolean blocking, boolean isShallowCopy, boolean skipLicenseCheck, boolean skipQueue) {
        log.debug("Saving transcript properties with document.");
        log.debug("Blocking: {}", (Object)blocking);
        log.debug("Shallow: {}", (Object)isShallowCopy);
        log.debug("Skip license check: {}", (Object)skipLicenseCheck);
        log.debug("Path: {}", (Object)transcript.getTranscriptLocation().toString());
        if (!LicenseService.isUserLicenseValid() && !skipLicenseCheck) {
            log.warn("License is not valid anymore.");
            Platform.runLater(() -> ((LicenseService)this.licenseService).showLicenseNotValidDialog());
            return;
        }
        if (richDocument == null) {
            log.warn("Rich document was null when trying to save.");
        }
        if (!blocking) {
            if (skipQueue) {
                log.info("Skipping queue and saving transcript in a separate thread...");
                this.executorService.execute(() -> this.saveAction(transcript, richDocument));
            } else {
                log.info("Adding entry to save queue...");
                this.queue.add(new ImmutableTriple((Object)transcript, (Object)richDocument, (Object)isShallowCopy));
                if (!this.isRunning()) {
                    this.getNextAndStart();
                }
            }
        } else {
            this.saveAction(transcript, richDocument);
        }
    }

    public void save(Transcript transcript, String richDocument, boolean blocking) {
        this.save(transcript, richDocument, blocking, false, false, false);
    }

    private void getNextAndStart() {
        try {
            if (this.queue.isEmpty()) {
                log.info("Save queue is empty, all done.");
                return;
            }
            log.info("Getting next entry of save queue ({} total)...", (Object)this.queue.size());
            Triple next = (Triple)this.queue.removeFirst();
            this.transcript = (Transcript)next.getLeft();
            this.richDocument = (String)next.getMiddle();
            this.isShallowCopy = (Boolean)next.getRight();
            this.restart();
        }
        catch (Exception e) {
            log.error("Error processing save queue", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
    }

    public void clearQueue() {
        log.info("Clearing save queue...");
        this.queue.clear();
    }

    @Generated
    public SaveTranscriptService(StatusService statusService, LicenseService licenseService, ZipService zipService, ExecutorService executorService) {
        this.statusService = statusService;
        this.licenseService = licenseService;
        this.zipService = zipService;
        this.executorService = executorService;
    }
}

