/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.Exporter;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.TableExporter;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class ExportUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportUtils.class);
    private final List<DocumentExporter> documentExporters;
    private final List<TableExporter> tableExporters;
    private final LicenseService licenseService;
    private final FileChooser fileChooser = new FileChooser();

    @Autowired
    public ExportUtils(List<DocumentExporter> documentExporters, List<TableExporter> tableExporters, LicenseService licenseService) {
        this.documentExporters = documentExporters;
        this.tableExporters = tableExporters;
        this.licenseService = licenseService;
    }

    public void showExportDialog(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> document) {
        this.prepareExportDialog(document, this.documentExporters.stream().map(Exporter::getFilter).toList(), this.documentExporters);
    }

    public void showExportDialog(List<TimeTrackingEntry> document) {
        this.prepareExportDialog(document, this.tableExporters.stream().map(Exporter::getFilter).toList(), this.tableExporters);
    }

    private void prepareExportDialog(Object document, List<FileChooser.ExtensionFilter> filters, List<? extends Exporter<?>> exporters) {
        log.debug("Preparing export dialog...");
        log.debug("Filters: {}", filters.stream().map(FileChooser.ExtensionFilter::getExtensions).toList());
        if (!LicenseService.isUserLicenseValid()) {
            log.warn("License is not valid anymore.");
            this.licenseService.showLicenseNotValidDialog();
            return;
        }
        log.debug("Opening file chooser...");
        if (Main.getRecentOpenedFileChooserPath() != null) {
            this.fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        this.fileChooser.getExtensionFilters().clear();
        this.fileChooser.getExtensionFilters().addAll(filters);
        File file = this.fileChooser.showSaveDialog((Window)GUIState.getController().getStage());
        if (file != null) {
            log.debug("File selected. Exporting...");
            this.export(exporters, file, document);
            Main.setRecentOpenedFileChooserPath((File)file.getParentFile());
            log.info("File exported.");
        }
    }

    private void export(List<? extends Exporter> exporters, File file, Object document) {
        log.debug("Exporting with Exporters: {}", exporters.stream().map(f -> f.getClass().getSimpleName()).toList());
        if (file == null) {
            log.debug("No file selected.");
            return;
        }
        try {
            for (Exporter exporter : exporters) {
                if (!((String)exporter.getFilter().getExtensions().getFirst()).equals(this.fileChooser.getSelectedExtensionFilter().getExtensions().getFirst())) continue;
                this.tryToExport(file, document, exporter);
            }
        }
        catch (FileNotFoundException e) {
            log.error("", (Throwable)e);
            this.showProblem("problems.cannotCreateOrOpen", e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            log.error("", (Throwable)e);
            this.showProblem("problems.cannotWrite", e.getLocalizedMessage());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            this.showProblem("problems.genericIOError", e.getLocalizedMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
    }

    private void tryToExport(File file, Object document, Exporter<Object> exporter) throws Exception {
        try {
            exporter.export(document, file.toPath());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            log.warn("Importer does not support class of document: " + String.valueOf(document.getClass()), (Throwable)e);
        }
    }

    private void showProblem(String s, String localizedMessage) {
        ETDialog.get((String)(Utils.getLocaleBundle().getString(s) + "\n\n" + Utils.getLocaleBundle().getString("general.error") + ": " + localizedMessage), (Alert.AlertType)Alert.AlertType.ERROR).showAndWait();
    }
}

