/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.apache.poi.EmptyFileException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class DOCXImporter
extends DocumentImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DOCXImporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("formats.docx") + " (*.docx)", new String[]{"*.docx"});

    public void importTranscript(Path file, String timestampFormat) throws Exception {
        log.debug("Importing docx file as a transcript document...");
        TimestampProcessor timestampProcessor = new TimestampProcessor(timestampFormat);
        Document document = this.createDocument();
        Element body = this.createCaseSensitiveElement("StyledDocument");
        document.appendChild((Node)body);
        try (XWPFDocument xwpfDocument = new XWPFDocument((InputStream)new FileInputStream(file.toFile()));){
            for (XWPFParagraph paragraph : xwpfDocument.getParagraphs()) {
                Element para = this.createCaseSensitiveElement("Paragraph");
                body.appendChild((Node)para);
                for (XWPFRun run : paragraph.getRuns()) {
                    ETStyle etStyle = this.getStyle(xwpfDocument, run);
                    String content = run.text();
                    if (content.isEmpty()) {
                        log.debug("Run appears to be empty. Searching for emoji.");
                        Document doc = Jsoup.parse((String)run.getCTR().xmlText(), (String)"", (Parser)Parser.xmlParser());
                        Elements elements = doc.getElementsByTag("w16se:symEx");
                        if (!elements.isEmpty()) {
                            log.debug("Found tag for emoji.");
                            Element symEx = (Element)elements.getFirst();
                            String font = symEx.attr("w16se:font");
                            if (!font.isEmpty()) {
                                etStyle.setFontFamily(font);
                            }
                            String chara = symEx.attr("w16se:char");
                            try {
                                content = new String(Character.toChars(Integer.parseInt(chara, 16)));
                            }
                            catch (NumberFormatException e) {
                                log.warn("Apparently this run doesn't include emoji after all. An invalid string was found for the assumed Unicode attribute.", (Throwable)e);
                            }
                        }
                    }
                    this.processText(para, content, etStyle, timestampProcessor);
                }
            }
            this.optimize((Element)document);
            log.debug("Creating transcriptTextArea document.");
            Transcript.get().setDocument(this.documentToString(document));
        }
        catch (EmptyFileException e) {
            log.error("File seems to be empty.");
            throw new IOException(Utils.getLocaleBundle().getString("problems.poiEmptyFile"));
        }
        catch (NotOfficeXmlFileException e) {
            log.error("File is not a valid docx document.");
            throw new IOException(Utils.getLocaleBundle().getString("problems.invalidPoiFile"));
        }
        catch (Exception e) {
            log.error("Could not import docx document.");
            throw e;
        }
        log.info("Imported docx file as a transcript document.");
    }

    private ETStyle getStyle(XWPFDocument doc, XWPFRun run) {
        ETStyle etStyle = new ETStyle();
        etStyle.setBold(run.isBold());
        etStyle.setItalic(run.isItalic());
        etStyle.setUnderlined(run.getUnderline() != UnderlinePatterns.NONE);
        etStyle.setFontFamily(run.getFontFamily());
        Double fontSizeAsDouble = run.getFontSizeAsDouble();
        etStyle.setFontSize(fontSizeAsDouble != null ? fontSizeAsDouble.intValue() : Configuration.get().getFormattingSize());
        CTRPr rPr = run.getCTR().getRPr();
        if (rPr != null && rPr.getRStyleArray().length > 0 && rPr.getRStyleArray(0) != null) {
            XWPFStyle style = doc.getStyles().getStyle(rPr.getRStyleArray(0).getVal());
            if (style != null) {
                String styleId = style.getStyleId();
                while (styleId != null) {
                    style = doc.getStyles().getStyle(styleId);
                    if (style != null) {
                        if (etStyle.getFontSize() == -1) {
                            etStyle.setFontSize(this.getFontSize(style.getCTStyle().getRPr()));
                        }
                        if (etStyle.getFontFamily() == null) {
                            etStyle.setFontFamily(this.getFontFamily(style.getCTStyle().getRPr()));
                        }
                        if (etStyle.getFontFamily() == null || etStyle.getFontSize() <= -1) {
                            styleId = style.getBasisStyleID();
                            continue;
                        }
                        break;
                    }
                    log.warn("Did not find style or base style of this run in styles section.");
                }
            } else {
                log.warn("Did not find style or base style of this run in styles section.");
            }
        }
        if (etStyle.getFontSize() == -1) {
            etStyle.setFontSize(Configuration.get().getFormattingSize());
            log.warn("Could not determine font size of this run. Falling back to default size.");
        }
        if (etStyle.getFontFamily() == null) {
            etStyle.setFontFamily(Configuration.get().getFormattingFont());
            log.warn("Could not determine font family of this run. Falling back to default font.");
        }
        return etStyle;
    }

    private int getFontSize(CTRPr pr) {
        if (pr == null || pr.getSzArray() == null) {
            return -1;
        }
        return (Integer)pr.getSzArray(0).getVal() / 2;
    }

    private String getFontFamily(CTRPr pr) {
        if (pr == null || pr.getRFontsArray().length == 0) {
            return null;
        }
        CTFonts fonts = pr.getRFontsArray(0);
        return fonts.getAscii();
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

