/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.ZipService;
import eu.ewerkzeug.easytranscript3.commons.io.importers.RTFImporter;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.migrations.MigrationService;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class ETPMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETPMigrator.class);
    private final RTFImporter rtfImporter;
    private final ZipService zipService;
    private final SaveTranscriptService saveTranscriptService;
    private Properties etpTranscript;
    private Path transcriptPath;

    public Transcript migrate(Path transcriptPath) throws IOException {
        log.debug("Importing etp transcript ...");
        this.setTranscriptPath(transcriptPath);
        this.etpTranscript = this.getProperties();
        log.debug("Properties: {}", (Object)this.etpTranscript);
        Transcript transcript = new Transcript();
        Path media = this.getAbsolutePathOfProperty("media");
        Path document = this.getAbsolutePathOfProperty("transcript");
        transcript.setMediaLocation(media);
        transcript.setTranscriptLocation(transcriptPath.getParent().resolve(this.getTranscriptName() + ".ett"));
        try {
            this.rtfImporter.importTranscript(document, "#HH:mm:ss-S#", transcript);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Could not import transcript.", e);
        }
        this.saveTranscriptService.save(transcript, transcript.getDocument(), true);
        MigrationService.loadTranscriptProperties((ZipService)this.zipService, (Transcript)transcript);
        return transcript;
    }

    @NotNull
    private Properties getProperties() throws IOException {
        Properties etpTranscript = new Properties();
        etpTranscript.load(new FileInputStream(this.transcriptPath.toFile()));
        return etpTranscript;
    }

    private Path getAbsolutePathOfProperty(String prefix) throws IOException {
        String pathProperty = this.etpTranscript.getProperty(prefix + "Path");
        String nameProperty = this.etpTranscript.getProperty(prefix + "Name");
        log.debug("Path property for prefix {}: {}", (Object)pathProperty, (Object)prefix);
        log.debug("name property for prefix {}: {}", (Object)nameProperty, (Object)prefix);
        Path path = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pathProperty})) {
            path = Path.of(pathProperty, new String[0]);
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nameProperty})) {
            path = this.transcriptPath.getParent().resolve(this.getTranscriptName() + "_Data").resolve(nameProperty);
            log.debug("Resolved path: {}", (Object)path);
        }
        if (this.doesFileNotExist(path)) {
            throw new IOException("Could not find media file.");
        }
        return path;
    }

    private boolean doesFileNotExist(Path path) {
        return path == null || !path.toFile().exists();
    }

    private String getTranscriptName() {
        String fileName = this.transcriptPath.getFileName().toString();
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    @Generated
    public ETPMigrator(RTFImporter rtfImporter, ZipService zipService, SaveTranscriptService saveTranscriptService) {
        this.rtfImporter = rtfImporter;
        this.zipService = zipService;
        this.saveTranscriptService = saveTranscriptService;
    }

    @Generated
    public void setTranscriptPath(Path transcriptPath) {
        this.transcriptPath = transcriptPath;
    }
}

