/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ETStyle {
    private Optional<String> fontFamily = Optional.empty();
    private Optional<Integer> fontSize = Optional.empty();
    private Optional<Boolean> bold = Optional.empty();
    private Optional<Boolean> italic = Optional.empty();
    private Optional<Boolean> underlined = Optional.empty();
    private Optional<String> color = Optional.empty();

    public String toFullString() {
        return "-fx-font-family: " + this.getFontFamily() + ";-fx-font-size: " + this.getFontSize() + "px;-fx-font-weight: " + (this.isBold() ? "bold" : "normal") + ";-fx-font-style: " + (this.isItalic() ? "italic" : "normal") + ";-fx-underline: " + this.isUnderlined() + ";" + (String)(this.color.isPresent() ? "-fx-fill: " + this.getColor() + ";" : "");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.fontFamily.ifPresent(f -> builder.append("-fx-font-family: ").append(this.getFontFamily()).append(";"));
        this.fontSize.ifPresent(f -> builder.append("-fx-font-size: ").append(this.getFontSize()).append("px;"));
        this.bold.ifPresent(f -> builder.append("-fx-font-weight: ").append(this.isBold() ? "bold" : "normal").append(";"));
        this.italic.ifPresent(f -> builder.append("-fx-font-style: ").append(this.isItalic() ? "italic" : "normal").append(";"));
        this.underlined.ifPresent(f -> builder.append("-fx-underline: ").append(this.isUnderlined()).append(";"));
        this.color.ifPresent(f -> builder.append("-fx-fill: ").append(this.getColor()).append(";"));
        return builder.toString();
    }

    public Optional<Boolean> getBold() {
        return this.bold;
    }

    public Optional<Boolean> getItalic() {
        return this.italic;
    }

    public Optional<Boolean> getUnderlined() {
        return this.underlined;
    }

    public String getFontFamily() {
        return this.fontFamily.orElse(Configuration.get().getFormattingFont());
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = Optional.ofNullable(fontFamily);
    }

    public int getFontSize() {
        return this.fontSize.orElse(Configuration.get().getFormattingSize());
    }

    public void setFontSize(int fontSize) {
        this.fontSize = Optional.of(fontSize);
    }

    public boolean isBold() {
        return this.bold.orElse(Configuration.get().isFormattingBold());
    }

    public void setBold(boolean bold) {
        this.bold = Optional.of(bold);
    }

    public boolean isItalic() {
        return this.italic.orElse(Configuration.get().isFormattingItalic());
    }

    public void setItalic(boolean italic) {
        this.italic = Optional.of(italic);
    }

    public boolean isUnderlined() {
        return this.underlined.orElse(Configuration.get().isFormattingUnderlined());
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = Optional.of(underlined);
    }

    public String getColor() {
        return this.color.orElse("rgb(0,0,0)");
    }

    public void setColor(String color) {
        this.color = Optional.ofNullable(color);
    }

    public void overwriteWith(ETStyle other) {
        if (this.fontFamily.isEmpty() && other.fontFamily.isPresent()) {
            this.setFontFamily(other.getFontFamily());
        }
        if (this.fontSize.isEmpty() && other.fontSize.isPresent()) {
            this.setFontSize(other.getFontSize());
        }
        if (this.bold.isEmpty() && other.bold.isPresent()) {
            this.setBold(other.isBold());
        }
        if (this.italic.isEmpty() && other.italic.isPresent()) {
            this.setItalic(other.isItalic());
        }
        if (this.underlined.isEmpty() && other.underlined.isPresent()) {
            this.setUnderlined(other.isUnderlined());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ETStyle etStyle = (ETStyle)o;
        return Objects.equals(this.fontFamily, etStyle.fontFamily) && Objects.equals(this.fontSize, etStyle.fontSize) && Objects.equals(this.bold, etStyle.bold) && Objects.equals(this.italic, etStyle.italic) && Objects.equals(this.underlined, etStyle.underlined);
    }

    public int hashCode() {
        return Objects.hash(this.fontFamily, this.fontSize, this.bold, this.italic, this.underlined);
    }

    @Generated
    public ETStyle() {
    }
}

