/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.ETStyle;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Lazy
public class HTMLImporter
extends DocumentImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTMLImporter.class);
    private static final String STYLE_ATTRIBUTE = "style";
    private final List<String> styledElements = List.of("h1", "h2", "h3", "h4", "h5", "h6", "b", "u", "i", "em", "strong", "small");
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("formats.html") + " (*.htm, *.html)", new String[]{"*.html", "*.htm"});
    private final List<String> textElements = List.of("a", "em", "strong", "small", "s", "cite", "q", "dfn", "abbr", "data", "time", "code", "var", "samp", "kbd", "sub", "sup", "mark", "ruby", "rt", "rp", "bdi", "bdo", "span", "br", "wbr", "StyledText", "Speaker", "Timestamp", "lct");

    private static String readLineByLine(String filePath, Charset cs) throws IOException {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Path.of(filePath, new String[0]), cs);){
            stream.forEach(contentBuilder::append);
        }
        return contentBuilder.toString();
    }

    public void importTranscript(Path file, String timestampFormat) throws Exception {
        String html;
        log.debug("Importing html file as a transcript document...");
        try {
            html = HTMLImporter.readLineByLine((String)file.toFile().getAbsolutePath(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | UncheckedIOException e) {
            log.warn("Could not read html file with UTF 8. Trying ISO 8859-1.");
            html = HTMLImporter.readLineByLine((String)file.toFile().getAbsolutePath(), (Charset)StandardCharsets.ISO_8859_1);
        }
        String content = this.htmlToTranscript(html, timestampFormat);
        Transcript.get().setDocument(content);
        log.info("Imported html file as a transcript document.");
    }

    String htmlToTranscript(String html, String timestampFormat) {
        log.debug("Initializing importer...");
        TimestampProcessor timestampProcessor = new TimestampProcessor(timestampFormat);
        Parser customParser = Parser.htmlParser();
        customParser = customParser.settings(new ParseSettings(true, true));
        Document doc = customParser.parseInput(html, "");
        Element body = doc.body();
        log.debug("Parsing...");
        body = body.tagName("StyledDocument");
        Elements allElements = body.getAllElements();
        this.removeComments((Node)body);
        log.debug("Removed comments.");
        allElements.stream().filter(element -> !this.textElements.contains(element.tagName()) && !this.styledElements.contains(element.tagName())).forEach(element -> {
            element.tagName("Paragraph");
            element.clearAttributes();
        });
        log.debug("Renamed all non special blocks to generic paragraphs.");
        allElements.stream().filter(element -> this.styledElements.contains(element.tagName())).forEach(element -> {
            element.clearAttributes();
            ETStyle etStyle = this.convertStyledTextToETStyle(element);
            element.attr("style", etStyle.toString());
            element.tagName("StyledText");
        });
        log.debug("Renamed all styled elements to StyledText.");
        allElements.stream().filter(element -> !element.ownText().isEmpty() && !this.textElements.contains(element.tagName())).forEach(element -> element.textNodes().forEach(node -> {
            Element wrapper = new Element("StyledText");
            wrapper.html(node.getWholeText());
            node.replaceWith((Node)wrapper);
        }));
        log.debug("Wrapped all non tagged text in StyledText Tags.");
        allElements.stream().filter(element -> this.textElements.contains(element.tagName())).forEach(element -> {
            element.tagName("StyledText");
            element.attributes().asList().stream().filter(attribute -> !attribute.getKey().equals("style")).forEach(entry -> element.removeAttr(entry.getKey()));
            if (element.hasAttr("style")) {
                ETStyle etStyle = this.convertStyledTextToETStyle(element);
                element.attr("style", etStyle.toString());
            }
        });
        log.debug("Renamed all text Elements to StyledText.");
        body.getElementsByTag("StyledText").forEach(styledText -> styledText.children().forEach(child -> {
            if (!child.tagName().equals("StyledText")) {
                child.remove();
            }
        }));
        log.debug("Removed all children (except StyledTexts) of StyledText.");
        this.flattenTexts(body);
        allElements.stream().filter(f -> !f.ownText().isEmpty() && !f.tagName().equals("StyledText")).forEach(f -> f.textNodes().forEach(node -> {
            Element wrapper = new Element("StyledText");
            wrapper.html(node.getWholeText());
            node.replaceWith((Node)wrapper);
        }));
        log.debug("Wrapped all text not owned by a StyledText in StyledText Tags.");
        body.getElementsByTag("StyledText").forEach(element -> {
            String style = element.attr("style");
            ETStyle etStyle = this.parseStyle(style);
            List contentParts = timestampProcessor.getContentParts(element.wholeText());
            if (contentParts.size() > 1) {
                contentParts.forEach(part -> {
                    Element styledText = element.appendElement("StyledText");
                    this.applyContentPartStyle(etStyle, part, styledText);
                    styledText.text(part.getValue());
                });
            } else if (contentParts.size() == 1) {
                this.applyContentPartStyle(etStyle, (TimestampProcessor.Content)contentParts.getFirst(), element);
                element.text(((TimestampProcessor.Content)contentParts.getFirst()).getValue());
            }
        });
        log.debug("Split text up in content parts.");
        log.debug("Document fully prepared. Transfer elements into a new document for finalization.");
        Document newDocument = this.createDocument();
        Element newBody = this.createCaseSensitiveElement("StyledDocument");
        newDocument.appendChild((Node)newBody);
        log.debug("Flattening paragraphs...");
        this.flattenParagraphs(body).forEach(arg_0 -> ((Element)newBody).appendChild(arg_0));
        log.debug("Flattened paragraphs.");
        this.flattenTexts(newBody);
        this.optimize((Element)newDocument);
        return this.documentToString(newDocument);
    }

    @NotNull
    private ETStyle convertStyledTextToETStyle(Element element) {
        ETStyle etStyle = this.parseStyle(element.attr("style"));
        switch (element.tagName()) {
            case "h1": {
                etStyle.setBold(true);
                etStyle.setFontSize(32);
                break;
            }
            case "h2": {
                etStyle.setBold(true);
                etStyle.setFontSize(24);
                break;
            }
            case "h3": {
                etStyle.setBold(true);
                etStyle.setFontSize(18);
                break;
            }
            case "h4": {
                etStyle.setBold(true);
                etStyle.setFontSize(16);
                break;
            }
            case "h5": {
                etStyle.setBold(true);
                etStyle.setFontSize(13);
                break;
            }
            case "h6": {
                etStyle.setBold(true);
                etStyle.setFontSize(10);
                break;
            }
            case "strong": 
            case "b": {
                etStyle.setBold(true);
                break;
            }
            case "em": 
            case "i": {
                etStyle.setItalic(true);
                break;
            }
            case "u": {
                etStyle.setUnderlined(true);
                break;
            }
            case "small": {
                etStyle.setFontSize(13);
                break;
            }
            default: {
                log.warn("Unknown tag {}", (Object)element.tagName());
            }
        }
        return etStyle;
    }

    private void applyContentPartStyle(ETStyle etStyle, TimestampProcessor.Content part, Element element) {
        String tag = "StyledText";
        if (part instanceof TimestampProcessor.TextContent) {
            element.attr("style", etStyle.toString());
        } else if (part instanceof TimestampProcessor.TimestampContent) {
            TimestampProcessor.TimestampContent timestampContent = (TimestampProcessor.TimestampContent)part;
            tag = "Timestamp";
            element.attr("ms", timestampContent.getValue());
        }
        element.tagName(tag);
    }

    private List<Element> flattenParagraphs(Element paragraph) {
        return this.flattenParagraphs(paragraph, 0);
    }

    private List<Element> flattenParagraphs(Element paragraph, int depth) {
        ArrayList<Element> elements = new ArrayList<Element>();
        ArrayList tmpTextHolder = new ArrayList();
        int finalDepth = ++depth;
        Runnable processTmpTextHolder = () -> {
            if (!tmpTextHolder.isEmpty()) {
                Element newP = new Element("Paragraph");
                tmpTextHolder.forEach(arg_0 -> ((Element)newP).appendChild(arg_0));
                elements.add(newP);
                tmpTextHolder.clear();
            }
        };
        paragraph.children().forEach(f -> {
            if (f.tagName().equals("StyledText")) {
                tmpTextHolder.add(f.clone());
            }
            if (f.tagName().equals("Paragraph")) {
                processTmpTextHolder.run();
                elements.addAll(this.flattenParagraphs(f, finalDepth));
            }
        });
        processTmpTextHolder.run();
        return elements;
    }

    private void flattenTexts(Element paragraph) {
        log.debug("Flattening text elements ...");
        List<Element> elementaryTexts = paragraph.getElementsByTag("StyledText").stream().filter(f -> f.children().isEmpty()).toList();
        ETStyle style = new ETStyle();
        elementaryTexts.forEach(f -> {
            Element parent = f.parent();
            while (parent != null && parent.tagName().equals("StyledText")) {
                Element grandParent = parent.parent();
                ETStyle parentStyle = this.parseStyle(parent.attr("style"));
                parent.children().forEach(child -> {
                    ETStyle childStyle = this.parseStyle(child.attr("style"));
                    if (!childStyle.equals((Object)style)) {
                        childStyle.overwriteWith(parentStyle);
                    }
                    child.attr("style", childStyle.toString());
                });
                Element finalParent = parent;
                parent.childNodes().forEach(c -> {
                    if (c instanceof TextNode) {
                        c.wrap("<StyledText></StyledText>").parent().attr("style", this.parseStyle(finalParent.attr("style")).toString());
                    }
                });
                parent.unwrap();
                parent = grandParent;
            }
        });
        log.debug("Flattened text elements.");
    }

    private void removeComments(Node node) {
        int i = 0;
        while (i < node.childNodeSize()) {
            Node child = node.childNode(i);
            if (child.nodeName().equals("#comment")) {
                child.remove();
                continue;
            }
            this.removeComments(child);
            ++i;
        }
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

