/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import javafx.beans.property.SimpleStringProperty;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimeTrackingEntry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeTrackingEntry.class);
    private LocalDateTime start = null;
    private LocalDateTime end = null;
    @JsonIgnore
    private SimpleStringProperty startProperty = new SimpleStringProperty();
    @JsonIgnore
    private SimpleStringProperty endProperty = new SimpleStringProperty();
    @JsonIgnore
    private SimpleStringProperty durationProperty = new SimpleStringProperty();

    @JsonCreator
    public TimeTrackingEntry(@JsonProperty(value="start") LocalDateTime start, @JsonProperty(value="end") LocalDateTime end) {
        this.setStart(start);
        this.setEnd(end);
        this.setProperties();
    }

    public long getDateDiff(TemporalUnit timeUnit) {
        if (this.end != null) {
            return this.start.until(this.end, timeUnit);
        }
        return 0L;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
        if (this.end != null && start.isAfter(this.end)) {
            this.end = start;
        }
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        if (end == null) {
            return;
        }
        this.end = end;
        if (this.start != null && end.isBefore(this.start)) {
            this.end = this.start;
        }
    }

    private void setProperties() {
        Locale locale = Locale.forLanguageTag(Configuration.get().getProgramLanguage());
        DateTimeFormatter df = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(locale);
        this.startProperty = new SimpleStringProperty(df.format(this.start));
        this.endProperty = new SimpleStringProperty(this.end != null ? df.format(this.end) : "");
        Duration duration = Duration.ofSeconds(this.getDateDiff((TemporalUnit)ChronoUnit.SECONDS));
        String time = this.end != null ? String.format("%02d:%02d:%02d", duration.toHours(), duration.toMinutesPart(), duration.toSecondsPart()) : "";
        this.durationProperty = new SimpleStringProperty(time);
    }

    public String getStartProperty() {
        return this.startProperty.get();
    }

    public String getEndProperty() {
        return this.endProperty.get();
    }

    public String getDurationProperty() {
        return this.durationProperty.get();
    }

    @Generated
    public TimeTrackingEntry() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeTrackingEntry)) {
            return false;
        }
        TimeTrackingEntry other = (TimeTrackingEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDateTime this$start = this.getStart();
        LocalDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDateTime this$end = this.getEnd();
        LocalDateTime other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        String this$startProperty = this.getStartProperty();
        String other$startProperty = other.getStartProperty();
        if (this$startProperty == null ? other$startProperty != null : !this$startProperty.equals(other$startProperty)) {
            return false;
        }
        String this$endProperty = this.getEndProperty();
        String other$endProperty = other.getEndProperty();
        if (this$endProperty == null ? other$endProperty != null : !this$endProperty.equals(other$endProperty)) {
            return false;
        }
        String this$durationProperty = this.getDurationProperty();
        String other$durationProperty = other.getDurationProperty();
        return !(this$durationProperty == null ? other$durationProperty != null : !this$durationProperty.equals(other$durationProperty));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeTrackingEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        String $startProperty = this.getStartProperty();
        result = result * 59 + ($startProperty == null ? 43 : $startProperty.hashCode());
        String $endProperty = this.getEndProperty();
        result = result * 59 + ($endProperty == null ? 43 : $endProperty.hashCode());
        String $durationProperty = this.getDurationProperty();
        result = result * 59 + ($durationProperty == null ? 43 : $durationProperty.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeTrackingEntry(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", startProperty=" + this.getStartProperty() + ", endProperty=" + this.getEndProperty() + ", durationProperty=" + this.getDurationProperty() + ")";
    }
}

