/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.configs;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.networking.license.service.NTPService;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javax.security.auth.login.AccountExpiredException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactor.core.Disposable;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
@Configuration
public class ScheduledLicenseValidation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledLicenseValidation.class);
    private final LicenseService licenseService;

    @Scheduled(fixedDelay=0x6DDD00L)
    public void validateLicense() {
        if (!Utils.isProgramInitialized()) {
            log.debug("Skipping license validation as program is not initialized yet.");
            return;
        }
        log.debug("Scheduled license validation starts...");
        NTPService.getNTPTime();
        if (!NTPService.isOffsetTolerable()) {
            log.error("Local time differs from NTP time by more than {} minutes!", (Object)(NTPService.getOffsetTolerance() / 1000L / 60L));
        }
        this.getLicense();
    }

    private void getLicense() {
        try {
            LicenseService.getLoading().set(true);
            Disposable disposable = this.licenseService.getLicenseFromServer(false).doOnError(WebClientRequestException.class, arg_0 -> this.handleConnectionError(arg_0)).subscribe(arg_0 -> this.handleLicenseResponse(arg_0), arg_0 -> this.handleUnexpectedError(arg_0), () -> this.onLicenseRequestComplete());
            LicenseService.getDisposableHashMap().put(this.getClass().getSimpleName(), disposable);
        }
        catch (NullPointerException e) {
            log.info("Unable to get license from server: No credentials saved.", (Throwable)e);
            LicenseService.getLoading().set(false);
            Platform.runLater(() -> ((LicenseService)this.licenseService).showTrialVersionDialog());
        }
        catch (Exception e) {
            log.error("Unexpected error while loading license.", (Throwable)e);
            LicenseService.getLoading().set(false);
            ExceptionAlert.get().showModal();
        }
    }

    /*
     * Exception decompiling
     */
    private void handleLicenseResponse(ResponseEntity<ByteArrayResource> response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=8,424
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleLicenseBody(ByteArrayResource body) {
        if (body == null || body.getByteArray() == null) {
            log.error("License body is empty.");
            return;
        }
        try {
            byte[] licenseBytes = body.getByteArray();
            this.licenseService.writeByteArrayLicense(licenseBytes);
            log.info("License downloaded and stored successfully.");
            this.loadLicense();
        }
        catch (Exception e) {
            log.error("Error processing license body", (Throwable)e);
        }
    }

    private void handleConnectionError(Throwable e) {
        log.error("Cannot connect to license server.", e);
    }

    private void handleUnexpectedError(Throwable e) {
        log.error("An unexpected error occurred when getting the license.", e);
        if (LicenseService.getUserLicense() == null) {
            log.warn("No loaded license found. Attempting to load existing license.");
            this.loadLicense();
        }
        LicenseService.getLoading().set(false);
    }

    private void onLicenseRequestComplete() {
        log.info("License validation request completed.");
        LicenseService.getDisposableHashMap().remove(this.getClass().getSimpleName());
    }

    private void showRevalidationDialog() {
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType toShop = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("licenseScreen.goToShop"), ButtonBar.ButtonData.HELP), false, false);
        ETButtonType enterLicense = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("licenseScreen.enterLicense"), ButtonBar.ButtonData.NEXT_FORWARD), true, true);
        buttons.add(toShop);
        buttons.add(enterLicense);
        ETDialog etDialog = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("general.licenseNeeded"), (String)"", (Modality)Modality.WINDOW_MODAL, buttons);
        etDialog.setText(Utils.getLocaleBundle().getString("licenseScreen.revalidationNeeded"));
        etDialog.showAndWait();
    }

    private void loadLicense() {
        try {
            this.licenseService.loadLicenseFromDisk();
        }
        catch (SignatureException e) {
            log.error("Signature of the license is invalid!", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
        catch (AccountExpiredException e) {
            log.warn("Account is expired.", (Throwable)e);
            Platform.runLater(() -> LicenseService.showLicenseNotValidDialog((boolean)false));
        }
        catch (IOException | IllegalArgumentException e) {
            log.error("", (Throwable)e);
        }
    }

    @Generated
    public ScheduledLicenseValidation(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}

