/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations.upgrademigrations;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.AESUtil;
import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.migrations.ProgramMigration;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class V3_1_0_BETA_1__Store_Device_ID
implements ProgramMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V3_1_0_BETA_1__Store_Device_ID.class);

    public void migrate() throws Exception {
        log.warn("Recreating device id ...");
        String deviceId = UUID.randomUUID().toString();
        Files.write(CredentialsUtils.DEVICE_ID_FILE, AESUtil.encrypt((Serializable)((Object)deviceId)), new OpenOption[0]);
        Utils.markAsHidden((Path)CredentialsUtils.DEVICE_ID_FILE);
        log.info("Device id created and stored.");
    }

    public boolean isApplicable() {
        return !Files.exists(CredentialsUtils.DEVICE_ID_FILE, new LinkOption[0]);
    }

    public Version getVersionOfChange() {
        return new Version.Builder().setVersionCore(3L, 1L, 0L).setPreReleaseVersion(new String[]{"BETA.1"}).build();
    }

    @Generated
    public V3_1_0_BETA_1__Store_Device_ID() {
    }
}

