/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.drawer;

import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.apache.commons.exec.OS;
import org.reactfx.SuspendableNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DrawerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DrawerService.class);
    private final SuspendableNo updatingToolbar = new SuspendableNo();
    private final SimpleBooleanProperty boldProperty = new SimpleBooleanProperty(Configuration.get().isFormattingBold());
    private final SimpleBooleanProperty italicProperty = new SimpleBooleanProperty(Configuration.get().isFormattingItalic());
    private final SimpleBooleanProperty underlineProperty = new SimpleBooleanProperty(Configuration.get().isFormattingUnderlined());
    private final SimpleObjectProperty<Integer> fontSizeProperty = new SimpleObjectProperty((Object)Configuration.get().getFormattingSize());
    private final SimpleStringProperty fontProperty = new SimpleStringProperty(Configuration.get().getFormattingFont());
    private final SimpleBooleanProperty drawerExpandedProperty = new SimpleBooleanProperty(Configuration.get().isDrawerExpanded());
    private final SimpleBooleanProperty shortcutsIndicatorVisibleProperty = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty changeOfSpeakerIndicatorVisibleProperty = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty textIndicatorVisibleProperty = new SimpleBooleanProperty(false);
    private final StatusService statusService;

    void updateFontSize(Integer size) {
        this.fontSizeProperty.set((Object)size);
        if (TranscriptTextArea.get() == null) {
            return;
        }
        if (!this.updatingToolbar.get() && TranscriptTextArea.get().getSelection().getLength() > 0) {
            TranscriptTextArea.get().getTextStyleManager().updateStyleInSelection(TextStyle.fontSize((int)size));
        }
        TranscriptTextArea.get().requestFocus();
    }

    void updateFontFamily(String family) {
        family = "\"" + (String)family + "\"";
        this.fontProperty.set((String)family);
        if (TranscriptTextArea.get() == null) {
            return;
        }
        if (!this.updatingToolbar.get()) {
            TranscriptTextArea.get().getTextStyleManager().updateStyleInSelection(TextStyle.fontFamily((String)family));
        }
        TranscriptTextArea.get().requestFocus();
    }

    public void toggleBold() {
        TextStyle styleAtCurrentPosition = this.getStyleAtCurrentPosition();
        if (styleAtCurrentPosition != null) {
            styleAtCurrentPosition.boldOptional.ifPresent(o -> this.boldProperty.set(o == false));
        }
        if (TranscriptTextArea.get() != null) {
            TranscriptTextArea.get().getTextStyleManager().toggleBold();
        }
    }

    public void toggleItalic() {
        TextStyle styleAtCurrentPosition = this.getStyleAtCurrentPosition();
        if (styleAtCurrentPosition != null) {
            styleAtCurrentPosition.italicOptional.ifPresent(o -> this.italicProperty.set(o == false));
        }
        if (TranscriptTextArea.get() != null) {
            TranscriptTextArea.get().getTextStyleManager().toggleItalic();
        }
    }

    public void toggleUnderline() {
        TextStyle styleAtCurrentPosition = this.getStyleAtCurrentPosition();
        if (styleAtCurrentPosition != null) {
            styleAtCurrentPosition.underlineOptional.ifPresent(o -> this.underlineProperty.set(o == false));
        }
        if (TranscriptTextArea.get() != null) {
            TranscriptTextArea.get().getTextStyleManager().toggleUnderline();
        }
    }

    public void setLeftToRight() {
        TranscriptTextArea.get().getParagraphStyleManager().setLeftToRight();
    }

    public void setCenter() {
        if (TranscriptTextArea.get() != null) {
            TranscriptTextArea.get().getParagraphStyleManager().setCenter();
        }
    }

    public void setRightToLeft() {
        if (TranscriptTextArea.get() != null) {
            TranscriptTextArea.get().getParagraphStyleManager().setRightToLeft();
        }
    }

    public void setJustify() {
        if (TranscriptTextArea.get() != null) {
            TranscriptTextArea.get().getParagraphStyleManager().setJustify();
        }
    }

    private TextStyle getStyleAtCurrentPosition() {
        int p = TranscriptTextArea.get().getCurrentParagraph();
        int col = TranscriptTextArea.get().getCaretColumn();
        return TranscriptTextArea.get() != null ? (TextStyle)TranscriptTextArea.get().getStyleAtPosition(p, col) : null;
    }

    public void validateAndSaveSpeakers(ObservableList<Node> gridNodes) {
        ArrayList<Speaker> speakers = new ArrayList<Speaker>();
        for (Node n : gridNodes) {
            Speaker speaker;
            String fullWord;
            if (!(n instanceof JFXTextField) || (fullWord = ((TextField)n).getText()).isEmpty() || speakers.contains(speaker = (Speaker)n.getUserData())) continue;
            speakers.add(speaker);
        }
        Transcript.get().getSpeakers().clear();
        Transcript.get().getSpeakers().addAll(speakers);
        log.info("Validated and saved speakers.");
        this.statusService.setSaved(false);
    }

    public void validateAndSetKeyCombinations(ObservableList<Node> gridNodes) {
        log.debug("Checking key combinations ...");
        String keyCombination = null;
        HashMap<String, String> forbidden = new HashMap<String, String>();
        ArrayList<KeyCombination> keyCombinations = new ArrayList<KeyCombination>();
        keyCombinations.add(Configuration.get().getPlayerFaster());
        keyCombinations.add(Configuration.get().getPlayerPlayPause());
        keyCombinations.add(Configuration.get().getPlayerFastForward());
        keyCombinations.add(Configuration.get().getPlayerLouder());
        keyCombinations.add(Configuration.get().getPlayerQuieter());
        keyCombinations.add(Configuration.get().getPlayerRewind());
        keyCombinations.add(Configuration.get().getPlayerSlower());
        for (KeyCombination combination : keyCombinations) {
            forbidden.put(combination.toString(), "");
            forbidden.put(KeyCombinationTextField.replacePlatformIndependentBySpecific((String)combination.toString()), "");
        }
        MainController controller = (MainController)GUIState.getController();
        if (controller != null && controller.getMenuBarController() != null) {
            ((MainController)GUIState.getController()).getMenuBarController().getMenuBar().getMenus().stream().flatMap(menu -> menu.getItems().stream()).filter(item -> item.getAccelerator() != null).forEach(item -> {
                forbidden.put(item.getAccelerator().toString().replace("'", ""), "");
                forbidden.put(KeyCombinationTextField.replacePlatformIndependentBySpecific((String)item.getAccelerator().toString().replace("'", "")), "");
            });
        }
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        for (Node n : gridNodes) {
            if (n instanceof KeyCombinationTextField) {
                KeyCombinationTextField textField = (KeyCombinationTextField)n;
                keyCombination = textField.getText();
                if (keyCombination.isEmpty() || !textField.validate()) {
                    keyCombination = null;
                    continue;
                }
                if (forbidden.containsKey(keyCombination) || textField.validateText() == KeyCombination.NO_MATCH) {
                    n.getStyleClass().add((Object)"error-in-field");
                } else {
                    n.getStyleClass().remove((Object)"error-in-field");
                    forbidden.put(keyCombination, "");
                }
                if (OS.isFamilyMac()) {
                    textField.setText(textField.getText().replace(KeyCode.META.getName(), KeyCode.COMMAND.getName()).replace(KeyCode.SHORTCUT.getName(), KeyCode.COMMAND.getName()));
                    continue;
                }
                if (!OS.isFamilyWindows()) continue;
                textField.setText(textField.getText().replace(KeyCode.META.getName(), KeyCode.WINDOWS.getName()));
                continue;
            }
            if (!(n instanceof JFXTextField)) continue;
            String fullWord = ((TextField)n).getText();
            if (keyCombination == null || fullWord.isEmpty() || tmp.containsKey(keyCombination)) continue;
            tmp.put(keyCombination, fullWord);
            forbidden.put(keyCombination, fullWord);
        }
        if (!tmp.equals(Transcript.get().getKeyCombinationFields())) {
            Transcript.get().getKeyCombinationFields().clear();
            Transcript.get().getKeyCombinationFields().putAll(tmp);
            this.statusService.setKeyCombinationNeedReload(true);
            this.statusService.setSaved(false);
            this.shortcutsIndicatorVisibleProperty.setValue(Boolean.valueOf(!tmp.isEmpty()));
            log.debug("Key combinations were changed.");
        } else {
            log.debug("Key combinations were not changed.");
        }
    }

    @Generated
    public SuspendableNo getUpdatingToolbar() {
        return this.updatingToolbar;
    }

    @Generated
    public SimpleBooleanProperty getBoldProperty() {
        return this.boldProperty;
    }

    @Generated
    public SimpleBooleanProperty getItalicProperty() {
        return this.italicProperty;
    }

    @Generated
    public SimpleBooleanProperty getUnderlineProperty() {
        return this.underlineProperty;
    }

    @Generated
    public SimpleObjectProperty<Integer> getFontSizeProperty() {
        return this.fontSizeProperty;
    }

    @Generated
    public SimpleStringProperty getFontProperty() {
        return this.fontProperty;
    }

    @Generated
    public SimpleBooleanProperty getDrawerExpandedProperty() {
        return this.drawerExpandedProperty;
    }

    @Generated
    public SimpleBooleanProperty getShortcutsIndicatorVisibleProperty() {
        return this.shortcutsIndicatorVisibleProperty;
    }

    @Generated
    public SimpleBooleanProperty getChangeOfSpeakerIndicatorVisibleProperty() {
        return this.changeOfSpeakerIndicatorVisibleProperty;
    }

    @Generated
    public SimpleBooleanProperty getTextIndicatorVisibleProperty() {
        return this.textIndicatorVisibleProperty;
    }

    @Generated
    public StatusService getStatusService() {
        return this.statusService;
    }

    @Generated
    public DrawerService(StatusService statusService) {
        this.statusService = statusService;
    }
}

