/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javafx.scene.control.IndexRange;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import lombok.Generated;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClipboardUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClipboardUtils.class);

    public static void addDisplayedRawTextSelectionToClipboardContent(ClipboardContent content) {
        content.putString(ClipboardUtils.getSelectedRawText());
    }

    public static void addDisplayedHtmlSelectionToClipboardContent(ClipboardContent content) {
        String html = Transcript.documentToHtml((StyledDocument)TranscriptTextArea.get().getDocument().subSequence(TranscriptTextArea.get().getSelection()));
        content.putHtml(html);
    }

    public static void addEncodedStyledTextSelectionToClipboardText(ClipboardContent content) {
        IndexRange selection = TranscriptTextArea.get().getSelection();
        TranscriptTextArea.get().getStyleCodecs().ifPresent(codecs -> {
            Codec codec = ReadOnlyStyledDocument.codec((Codec)((Codec)codecs._1), (Codec)((Codec)codecs._2), (SegmentOps)TranscriptTextArea.get().getSegOps());
            DataFormat format = Objects.requireNonNullElseGet(DataFormat.lookupMimeType((String)codec.getName()), () -> new DataFormat(new String[]{codec.getName()}));
            log.debug("Mimetype: " + String.valueOf(DataFormat.lookupMimeType((String)codec.getName())));
            StyledDocument doc = TranscriptTextArea.get().subDocument(selection.getStart(), selection.getEnd());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            try {
                codec.encode(dos, (Object)doc);
                content.put((Object)format, (Object)os.toByteArray());
            }
            catch (IOException e) {
                log.error("Codec error: Exception in encoding '{}'.", (Object)codec.getName(), (Object)e);
            }
        });
    }

    private static String getSelectedRawText() {
        CaretSelectionBind caretSelectionBind = TranscriptTextArea.get().getCaretSelectionBind();
        List paragraphs = TranscriptTextArea.get().getParagraphs().subList(caretSelectionBind.getStartParagraphIndex(), caretSelectionBind.getEndParagraphIndex() + 1);
        int realStartOffset = caretSelectionBind.getStartColumnPosition();
        int realEnd = caretSelectionBind.getEndPosition();
        int lengthPos = 0;
        boolean reachedStart = false;
        StringBuilder paragraphsText = new StringBuilder();
        for (Paragraph p : paragraphs) {
            for (AbstractSegment s : p.getSegments()) {
                lengthPos += s.getText().length();
                if (!(s instanceof StyledTextSegment)) {
                    if (!reachedStart && lengthPos <= caretSelectionBind.getStartColumnPosition()) {
                        realStartOffset += s.getRealText().length() - 1;
                    }
                    realEnd += s.getRealText().length() - 1;
                }
                if (lengthPos > caretSelectionBind.getStartColumnPosition()) {
                    reachedStart = true;
                }
                paragraphsText.append(s.getRealText());
                if (lengthPos <= caretSelectionBind.getStartColumnPosition() + caretSelectionBind.getLength()) continue;
                break;
            }
            paragraphsText.append("\n");
        }
        int realStart = caretSelectionBind.getStartPosition() + (realStartOffset - caretSelectionBind.getStartColumnPosition());
        int distance = realEnd - realStart;
        String text = paragraphsText.toString();
        text = text.substring(realStartOffset);
        text = text.substring(0, Math.min(text.length(), distance));
        return text;
    }

    @Generated
    private ClipboardUtils() {
    }
}

