/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ClipboardUtils;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.util.Arrays;
import java.util.Map;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.fxmisc.richtext.ClipboardActions;

public interface CustomClipboardActions<PS, SEG, S>
extends ClipboardActions<PS, SEG, S> {
    default public void cut() {
        if (!LicenseService.isUserLicenseValid()) {
            LicenseService.showLicenseNotValidDialog((boolean)true);
            return;
        }
        super.cut();
    }

    default public void copy() {
        if (!LicenseService.isUserLicenseValid()) {
            LicenseService.showLicenseNotValidDialog((boolean)true);
            return;
        }
        ClipboardContent content = new ClipboardContent();
        ClipboardUtils.addDisplayedRawTextSelectionToClipboardContent((ClipboardContent)content);
        ClipboardUtils.addDisplayedHtmlSelectionToClipboardContent((ClipboardContent)content);
        ClipboardUtils.addEncodedStyledTextSelectionToClipboardText((ClipboardContent)content);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    default public void paste() {
        super.paste();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String string = clipboard.getString();
        String[] words = string.split(Transcript.wordSeparator.pattern());
        Transcript.get().getAutocompletionWords().addAll(Arrays.stream(words).filter(f -> f.length() >= Configuration.get().getAutocompletionThreshold()).toList());
    }
}

