/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.FXUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.TimestampUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.KeyCombinationSubstitutionService;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.LocationUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.NavigationUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ZoomUtils;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InputMapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputMapService.class);
    private final KeyCombinationSubstitutionService keyCombinationSubstitutionService;
    private final DrawerService drawerService;
    private final TextAreaService textAreaService;

    private static void hideContextMenusAndMoveCaret(MouseEvent mouseEvent) {
        TextAreaService.hideAllContextPopups();
        CharacterHit hit = TranscriptTextArea.get().hit(mouseEvent.getX(), mouseEvent.getY());
        TranscriptTextArea.get().moveTo(hit.getInsertionIndex());
    }

    @NotNull
    private static ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> getLineBreakDoc(TextStyle oldTextStyle) {
        return ReadOnlyStyledDocument.fromString((String)"\n", (Object)((ParStyle)TranscriptTextArea.get().getParagraph(TranscriptTextArea.get().getCurrentParagraph()).getParagraphStyle()), (Object)oldTextStyle, (TextOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    private static EventPattern<Event, KeyEvent> typedPrintableCharacter() {
        return EventPattern.keyTyped().onlyIf(keyEvent -> StringUtils.isNotEmpty((CharSequence)keyEvent.getCharacter()) && keyEvent.getCharacter().charAt(0) >= ' ' && keyEvent.getCharacter().charAt(0) != '\u007f');
    }

    private static void showAutocompletePopup(KeyEvent keyEvent) {
        if (Configuration.get().isAutocompletionActive() && Character.isLetterOrDigit(keyEvent.getCharacter().charAt(0))) {
            TranscriptTextArea textArea = TranscriptTextArea.get();
            Triple lastWord = LocationUtils.findLastWord((int)textArea.getCaretPosition());
            if (textArea.getCaretBounds().isPresent() && LocationUtils.isCursorAtWordBoundary() && TranscriptTextArea.get().getAutocompletePopup().findWordSuggestions(Transcript.get().getAutocompletionWords(), (String)lastWord.getLeft())) {
                FXUtils.runOnePulseLater(() -> TranscriptTextArea.get().getAutocompletePopup().show(lastWord));
            }
        }
    }

    public void addInputMaps() {
        this.addKeyTypedInputMap();
        this.addNewParagraphInputMap();
        this.addMouseInputMap();
        this.addZoomShortcutInputMap();
        this.addArrowInputMaps();
    }

    private void addArrowInputMaps() {
        Nodes.addInputMap((Node)TranscriptTextArea.get(), (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.LEFT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToPrevWord((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.RIGHT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToNextWord((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.UP, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToPreviousParagraph((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.DOWN, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToNextParagraph((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.UP, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToPreviousParagraph((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.ADJUST)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.DOWN, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToNextParagraph((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.ADJUST)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.LEFT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToPrevWord((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.ADJUST)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.RIGHT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> NavigationUtils.skipToNextWord((NavigationActions.SelectionPolicy)NavigationActions.SelectionPolicy.ADJUST))}));
    }

    private void addMouseInputMap() {
        Nodes.addInputMap((Node)TranscriptTextArea.get(), (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.PRIMARY).onlyIf(f -> TranscriptTextArea.get().getSelection().getLength() == 0), mouseEvent -> InputMapService.hideContextMenusAndMoveCaret((MouseEvent)mouseEvent)), InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.SECONDARY).onlyIf(event -> TranscriptTextArea.get().getSelection().getLength() == 0), InputMapService::hideContextMenusAndMoveCaret)}));
    }

    private void addZoomShortcutInputMap() {
        Nodes.addInputMap((Node)TranscriptTextArea.get(), (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((String)"+", (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> ZoomUtils.zoom((boolean)true)), InputMap.consume((EventPattern)EventPattern.keyPressed((String)"-", (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> ZoomUtils.zoom((boolean)false))}));
    }

    private void addNewParagraphInputMap() {
        Nodes.addInputMap((Node)TranscriptTextArea.get(), (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ENTER, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.CONTROL_ANY}), e -> Platform.runLater(() -> {
            e.consume();
            if (!TranscriptTextArea.get().isEditable()) {
                return;
            }
            int caretPos = this.handleNewParagraph(e);
            if (LocationUtils.isCursorAtWordBoundary((int)caretPos)) {
                this.startKeyCombinationSubstitutionService(caretPos);
            }
        }))}));
    }

    private int handleNewParagraph(KeyEvent e) {
        int caretPos = TranscriptTextArea.get().getCaretPosition();
        TextStyle oldTextStyle = (TextStyle)TranscriptTextArea.get().getStyleAtPosition(caretPos);
        ReadOnlyStyledDocument doc = InputMapService.getLineBreakDoc((TextStyle)oldTextStyle);
        if (TranscriptTextArea.get().getSelection().getLength() > 0) {
            TranscriptTextArea.get().deleteText(TranscriptTextArea.get().getSelection());
        }
        if (!e.isShiftDown() && Configuration.get().isTimestampsOnEnd()) {
            TimestampUtils.insertTimestamp();
        }
        TranscriptTextArea.get().insert(TranscriptTextArea.get().getCaretPosition(), (StyledDocument)doc);
        if (!e.isShiftDown()) {
            if (Configuration.get().isAdditionalLineAfterEnter()) {
                TranscriptTextArea.get().insert(TranscriptTextArea.get().getCaretPosition(), (StyledDocument)doc);
            }
            if (Configuration.get().isTimestampsOnBeginning()) {
                TimestampUtils.insertTimestamp();
            }
            if (Transcript.get().getChangeOfSpeaker()) {
                this.textAreaService.insertSpeaker();
            }
        }
        TranscriptTextArea.get().requestFollowCaret();
        return caretPos;
    }

    private void addKeyTypedInputMap() {
        Nodes.addInputMap((Node)TranscriptTextArea.get(), (InputMap)InputMap.consume((EventPattern)InputMapService.typedPrintableCharacter(), keyEvent -> {
            if (!TranscriptTextArea.get().isEditable()) {
                return;
            }
            this.addWordToAutocompletionWordList(keyEvent);
            if (!keyEvent.isShortcutDown()) {
                this.insertTypedCharacter(keyEvent);
            }
            TranscriptTextArea.get().requestFollowCaret();
            this.startKeyCombinationSubstitutionIfApplicable(keyEvent);
            InputMapService.showAutocompletePopup((KeyEvent)keyEvent);
        }));
    }

    private void addWordToAutocompletionWordList(KeyEvent keyEvent) {
        Triple lastWord;
        String word;
        if (!Configuration.get().isAutocompletionActive() || !Transcript.wordSeparator.matcher(keyEvent.getCharacter()).matches()) {
            return;
        }
        TranscriptTextArea.get().getAutocompletePopup().hide();
        TranscriptTextArea textArea = TranscriptTextArea.get();
        int start = textArea.getCaretPosition() - 1;
        if (start >= 2 && Character.isLetterOrDigit(textArea.getText(start, start + 1).charAt(0)) && (word = (String)(lastWord = LocationUtils.findLastWord((int)textArea.getCaretPosition())).getLeft()).length() >= Configuration.get().getAutocompletionThreshold() && !this.keyCombinationSubstitutionService.getCharacterCombinations().containsKey(word) && !this.keyCombinationSubstitutionService.getMisspellingCorrections().containsKey(word.toLowerCase())) {
            Transcript.get().getAutocompletionWords().add(word);
        }
    }

    private void insertTypedCharacter(KeyEvent keyEvent) {
        Pair familyAndSize = this.getFamilyAndSizeForInsertion();
        ReadOnlyStyledDocument document = ReadOnlyStyledDocument.fromSegment((Object)new StyledTextSegment((Object)keyEvent.getCharacter()), (Object)((ParStyle)TranscriptTextArea.get().getParagraph(TranscriptTextArea.get().getCurrentParagraph()).getParagraphStyle()), (Object)TextStyle.EMPTY.updateFontFamily((String)familyAndSize.getLeft()).updateFontSize(((Integer)familyAndSize.getRight()).intValue()).updateBold(this.drawerService.getBoldProperty().getValue().booleanValue()).updateItalic(this.drawerService.getItalicProperty().getValue().booleanValue()).updateUnderline(this.drawerService.getUnderlineProperty().getValue().booleanValue()), (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
        if (TranscriptTextArea.get().getSelection().getLength() == 0) {
            try {
                TranscriptTextArea.get().insert(Math.min(TranscriptTextArea.get().getCaretPosition(), TranscriptTextArea.get().getDocument().length()), (StyledDocument)document);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        } else {
            TranscriptTextArea.get().replaceSelection((StyledDocument)document);
        }
    }

    @NotNull
    private Pair<String, Integer> getFamilyAndSizeForInsertion() {
        String fontFamily = null;
        int fontSize = 0;
        if (TranscriptTextArea.get().getSelection().getLength() > 0) {
            int atStart = TranscriptTextArea.get().getSelection().getStart();
            Optional fontFamily1 = ((TextStyle)TranscriptTextArea.get().getStyleAtPosition((int)atStart)).fontFamilyOptional;
            Optional fontSize1 = ((TextStyle)TranscriptTextArea.get().getStyleAtPosition((int)atStart)).fontSizeOptional;
            if (fontFamily1.isPresent()) {
                fontFamily = (String)fontFamily1.get();
            }
            if (fontSize1.isPresent()) {
                fontSize = (Integer)fontSize1.get();
            }
        } else {
            fontFamily = this.drawerService.getFontProperty().getValue();
            Integer selectedItem = (Integer)this.drawerService.getFontSizeProperty().getValue();
            int n = fontSize = selectedItem != null ? selectedItem : 0;
        }
        if (fontFamily == null) {
            fontFamily = Configuration.get().getFormattingFont();
        }
        if (fontSize <= 0) {
            fontSize = Configuration.get().getFormattingSize();
        }
        return new ImmutablePair((Object)fontFamily, (Object)fontSize);
    }

    private void startKeyCombinationSubstitutionIfApplicable(KeyEvent keyEvent) {
        if (LocationUtils.isCursorAtWordBoundary((int)Math.max(0, TranscriptTextArea.get().getCaretPosition() - 1)) && keyEvent.getCharacter().equals("\t") || keyEvent.getCharacter().equals(" ")) {
            this.startKeyCombinationSubstitutionService(TranscriptTextArea.get().getCaretPosition() - 1);
        }
    }

    private void startKeyCombinationSubstitutionService(int caretPosition) {
        this.keyCombinationSubstitutionService.setCaret(caretPosition);
        this.keyCombinationSubstitutionService.restart();
    }

    @Generated
    public InputMapService(KeyCombinationSubstitutionService keyCombinationSubstitutionService, DrawerService drawerService, TextAreaService textAreaService) {
        this.keyCombinationSubstitutionService = keyCombinationSubstitutionService;
        this.drawerService = drawerService;
        this.textAreaService = textAreaService;
    }
}

