/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import org.fxmisc.richtext.model.Codec;

public class ParStyle {
    public static final ParStyle EMPTY = new ParStyle();
    public static final Codec<ParStyle> CODEC = new /* Unavailable Anonymous Inner Class!! */;
    public final Optional<TextAlignment> alignment;
    public final Optional<Color> backgroundColor;

    public ParStyle() {
        this(Optional.empty(), Optional.empty());
    }

    public ParStyle(Optional<TextAlignment> alignment, Optional<Color> backgroundColor) {
        this.alignment = alignment;
        this.backgroundColor = backgroundColor;
    }

    public static ParStyle alignLeft() {
        return EMPTY.updateAlignment(TextAlignment.LEFT);
    }

    public static ParStyle alignCenter() {
        return EMPTY.updateAlignment(TextAlignment.CENTER);
    }

    public static ParStyle alignRight() {
        return EMPTY.updateAlignment(TextAlignment.RIGHT);
    }

    public static ParStyle alignJustify() {
        return EMPTY.updateAlignment(TextAlignment.JUSTIFY);
    }

    public static ParStyle fromCss(String style) {
        Optional<Object> alignment = Optional.empty();
        Optional<Object> backgroundColor = Optional.empty();
        if (!style.isEmpty()) {
            block8: for (String property : style.split(";", 0)) {
                String[] pair = property.split(":");
                String propName = pair[0].trim();
                String propValue = pair[1].trim();
                switch (propName) {
                    case "-fx-text-alignment": {
                        alignment = Optional.of(TextAlignment.valueOf((String)propValue.toUpperCase()));
                        continue block8;
                    }
                    case "-fx-background-color": {
                        backgroundColor = Optional.of(TextStyle.cssColor((String)propValue));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown CSS property: " + property);
                    }
                }
            }
        }
        return new ParStyle(alignment, backgroundColor);
    }

    public int hashCode() {
        return Objects.hash(this.alignment, this.backgroundColor);
    }

    public boolean equals(Object other) {
        if (other instanceof ParStyle) {
            ParStyle that = (ParStyle)other;
            return Objects.equals(this.alignment, that.alignment) && Objects.equals(this.backgroundColor, that.backgroundColor);
        }
        return false;
    }

    public String toString() {
        return this.toCss();
    }

    public String toCss() {
        StringBuilder sb = new StringBuilder();
        this.alignment.ifPresent(al -> sb.append("-fx-text-alignment: " + (switch (2.$SwitchMap$javafx$scene$text$TextAlignment[al.ordinal()]) {
            case 1 -> "left";
            case 2 -> "center";
            case 3 -> "right";
            case 4 -> "justify";
            default -> throw new AssertionError((Object)"unreachable code");
        }) + ";"));
        this.backgroundColor.ifPresent(color -> sb.append("-fx-background-color: " + TextStyle.cssColor((Color)color) + ";"));
        return sb.toString();
    }

    public ParStyle updateWith(ParStyle mixin) {
        return new ParStyle(mixin.alignment.isPresent() ? mixin.alignment : this.alignment, mixin.backgroundColor.isPresent() ? mixin.backgroundColor : this.backgroundColor);
    }

    public ParStyle updateAlignment(TextAlignment alignment) {
        return new ParStyle(Optional.of(alignment), this.backgroundColor);
    }

    public ParStyle updateBackgroundColor(Color backgroundColor) {
        return new ParStyle(this.alignment, Optional.of(backgroundColor));
    }
}

