/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.util.function.UnaryOperator;
import javafx.scene.control.IndexRange;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.TwoDimensional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphStyleManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParagraphStyleManager.class);
    private final TranscriptTextArea textArea;

    public void setRightToLeft() {
        this.updateParagraphStyleInSelection(ParStyle.alignRight());
    }

    public void setCenter() {
        this.updateParagraphStyleInSelection(ParStyle.alignCenter());
    }

    public void setJustify() {
        this.updateParagraphStyleInSelection(ParStyle.alignJustify());
    }

    public void setLeftToRight() {
        this.updateParagraphStyleInSelection(ParStyle.alignLeft());
    }

    private void updateParagraphStyleInSelection(ParStyle mixin) {
        this.updateParagraphStyleInSelection(style -> style.updateWith(mixin));
    }

    private void updateParagraphStyleInSelection(UnaryOperator<ParStyle> updater) {
        IndexRange selection = this.textArea.getSelection();
        int startPar = this.textArea.offsetToPosition(selection.getStart(), TwoDimensional.Bias.Forward).getMajor();
        int endPar = this.textArea.offsetToPosition(selection.getEnd(), TwoDimensional.Bias.Backward).getMajor();
        for (int i = startPar; i <= endPar; ++i) {
            Paragraph paragraph = this.textArea.getParagraph(i);
            this.textArea.setParagraphStyle(i, (Object)((ParStyle)updater.apply((ParStyle)paragraph.getParagraphStyle())));
        }
    }

    @Generated
    public ParagraphStyleManager(TranscriptTextArea textArea) {
        this.textArea = textArea;
    }
}

