/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AbstractPopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntry;
import java.util.Optional;
import javafx.geometry.Bounds;
import org.apache.commons.lang3.tuple.Triple;

public abstract class PositioningReferencePopup<Entry extends PopupEntry>
extends AbstractPopup<Entry, Triple<String, Integer, Integer>> {
    public void show(Triple<String, Integer, Integer> positioningReference) {
        TranscriptTextArea textArea = TranscriptTextArea.get();
        double x = -1.0;
        double y = -1.0;
        if (textArea.getCaretBounds().isEmpty() && this.getBoundsOfFirstCharacterOfLastWord(positioningReference).isEmpty()) {
            TranscriptTextArea.getVsPane().scrollYBy(100.0);
        }
        Optional characterBoundsOnScreen = this.getBoundsOfFirstCharacterOfLastWord(positioningReference);
        Optional caretBounds = textArea.getCaretBounds();
        if (caretBounds.isPresent()) {
            x = ((Bounds)caretBounds.get()).getMaxX();
            y = ((Bounds)caretBounds.get()).getMaxY();
        }
        if (characterBoundsOnScreen.isPresent()) {
            x = ((Bounds)characterBoundsOnScreen.get()).getMinX();
            y = ((Bounds)characterBoundsOnScreen.get()).getMaxY();
        }
        this.showAt(x, y);
    }

    private Optional<Bounds> getBoundsOfFirstCharacterOfLastWord(Triple<String, Integer, Integer> lastWord) {
        int charIndex;
        if (lastWord == null || lastWord.getLeft() == null || ((String)lastWord.getLeft()).isEmpty()) {
            return Optional.empty();
        }
        for (charIndex = ((Integer)lastWord.getMiddle()).intValue(); charIndex < (Integer)lastWord.getRight() && (Character.isISOControl(TranscriptTextArea.get().getText(charIndex, charIndex + 1).charAt(0)) || Character.isWhitespace(TranscriptTextArea.get().getText(charIndex, charIndex + 1).charAt(0))); ++charIndex) {
        }
        if (charIndex >= (Integer)lastWord.getRight()) {
            return Optional.empty();
        }
        int startIndex = Math.min(charIndex, TranscriptTextArea.get().getLength() - 1);
        int endIndex = Math.min(charIndex + 1, TranscriptTextArea.get().getLength());
        return TranscriptTextArea.get().getCharacterBoundsOnScreen(startIndex, endIndex);
    }
}

