/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.menubar;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.StatsFeature;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.JobCreationService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferProgressInfo;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.time.Duration;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import lombok.Generated;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class AutomaticTranscriptionStatusController
extends GridPane {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutomaticTranscriptionStatusController.class);
    @FXML
    private Button closeButton;
    @FXML
    private StatsFeature currentFilesOfTotalStatsFeature;
    @FXML
    private StatsFeature remainingTimeStatsFeature;
    private long eta = -1L;
    private final STTStatusService sttStatusService;
    private final JobCreationService jobCreationService;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    private void loadFXML() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setLocation(this.getClass().getClassLoader().getResource(this.getClass().getPackageName().replace(".", "/") + "/automaticTranscriptionStatus.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setResources(Utils.getLocaleBundle());
        fxmlLoader.load();
    }

    @FXML
    public void initialize() {
        this.sttStatusService.getTransferProgressInfo().getCompletedUploads().addListener(arg_0 -> this.onCompleted(arg_0));
        AutomaticTranscriptCreationInfo.get().getPersons().addListener(arg_0 -> this.onCompleted(arg_0));
        BooleanBinding isBiggerThanOne = Bindings.createBooleanBinding(() -> AutomaticTranscriptCreationInfo.get().getPersons().size() > 1, (Observable[])new Observable[]{AutomaticTranscriptCreationInfo.get().getPersons()});
        if (AutomaticTranscriptCreationInfo.get().getPersons().size() > 1) {
            this.setPrefHeight(342.0);
        } else {
            this.setPrefHeight(250.0);
        }
        this.currentFilesOfTotalStatsFeature.managedProperty().bind((ObservableValue)this.currentFilesOfTotalStatsFeature.visibleProperty());
        this.currentFilesOfTotalStatsFeature.visibleProperty().bind((ObservableValue)isBiggerThanOne);
        this.sttStatusService.getTransferProgressInfo().getWrittenPerSecond().addListener(arg_0 -> this.onTransferProgress(arg_0));
        this.sttStatusService.getTransferProgressInfo().etaFromGenerationServerProperty().addListener((obs, o, n) -> {
            this.eta = n.longValue();
        });
        Platform.runLater(() -> {
            this.sttStatusService.getStateMachine().addStateListener((StateMachineListener)new /* Unavailable Anonymous Inner Class!! */);
            this.onStateChanged(this.sttStatusService.getState());
        });
        FxTimer.runPeriodically((Duration)Duration.ofMillis(1000L), () -> {
            if (this.eta > 0L) {
                --this.eta;
                this.onETAUpdate();
            }
        });
    }

    public void delete() {
        this.jobCreationService.deleteAutomaticTranscriptionJob().subscribe();
    }

    private void onTransferProgress(ListChangeListener.Change<? extends Long> change) {
        if (this.sttStatusService.getTransferProgressInfo().getWrittenPerSecond().size() < 5) {
            return;
        }
        Long avgBytesPerSecond = this.sttStatusService.getAverageWrittenPerSecond();
        if (avgBytesPerSecond == null) {
            return;
        }
        Duration estimatedDuration = this.calculateRemainingTime(avgBytesPerSecond.longValue());
        this.updateRemainingTimeDisplay(estimatedDuration);
        this.logTransferProgress(avgBytesPerSecond.longValue(), estimatedDuration);
    }

    private Duration calculateRemainingTime(long avgBytesPerSecond) {
        TransferProgressInfo progressInfo = this.sttStatusService.getTransferProgressInfo();
        if (progressInfo.getTotalLength() <= 0L) {
            return Duration.ZERO;
        }
        long bytesRemaining = progressInfo.getTotalLength() - progressInfo.getTransferred();
        if (bytesRemaining < 0L) {
            return Duration.ZERO;
        }
        double secondsRemaining = (double)bytesRemaining / (double)avgBytesPerSecond;
        return Duration.ofSeconds(Math.max(0L, (long)secondsRemaining));
    }

    private void updateRemainingTimeDisplay(Duration duration) {
        Platform.runLater(() -> this.remainingTimeStatsFeature.setTitle(String.format("%02d:%02d:%02d", duration.toHours(), duration.toMinutesPart(), duration.toSecondsPart())));
    }

    private void logTransferProgress(long avgBytesPerSecond, Duration duration) {
        TransferProgressInfo progressInfo = this.sttStatusService.getTransferProgressInfo();
        double percentComplete = 0.0;
        if (progressInfo.getTotalLength() > 0L) {
            percentComplete = (double)progressInfo.getTransferred() / (double)progressInfo.getTotalLength() * 100.0;
        }
        log.info("{}, {} written, {} kb/s, {}%, {}:{} ETA", new Object[]{this.sttStatusService.getState(), progressInfo.getTransferred(), avgBytesPerSecond / 1000L, percentComplete, duration.toMinutes(), duration.toSecondsPart()});
    }

    private void onETAUpdate() {
        if (this.eta < 0L) {
            Platform.runLater(() -> this.remainingTimeStatsFeature.setTitle("?"));
            return;
        }
        Duration duration = Duration.ofSeconds(this.eta);
        Platform.runLater(() -> this.remainingTimeStatsFeature.setTitle(String.format("%02d:%02d:%02d", duration.toHours(), duration.toMinutesPart(), duration.toSecondsPart())));
    }

    private void onStateChanged(String status) {
        log.debug("Transcript generation switched to phase: {}, updating texts.", (Object)status);
        switch (status) {
            case "UPLOADING": {
                this.updateTextsOnNewPhase("automaticTranscriptionStatus.filesUploaded");
                break;
            }
            case "GENERATING": {
                this.updateTextsOnNewPhase("automaticTranscriptionStatus.filesTranscribed");
                break;
            }
            case "DOWNLOADING": {
                this.updateTextsOnNewPhase("automaticTranscriptionStatus.downloadingTranscript");
                break;
            }
            default: {
                this.updateTextsOnNewPhase(null);
            }
        }
    }

    private void updateTextsOnNewPhase(String key) {
        Platform.runLater(() -> {
            if (key != null) {
                this.currentFilesOfTotalStatsFeature.setDescription(Utils.getLocaleBundle().getString(key));
            } else {
                this.currentFilesOfTotalStatsFeature.setDescription("?");
            }
            this.remainingTimeStatsFeature.setTitle("?");
            if (this.sttStatusService.getState().equals("DOWNLOADING")) {
                this.currentFilesOfTotalStatsFeature.setTitle("1");
            }
        });
    }

    private void onCompleted(ListChangeListener.Change<?> change) {
        Platform.runLater(() -> this.currentFilesOfTotalStatsFeature.setTitle(this.sttStatusService.getTransferProgressInfo().getCompletedUploads().size() + " / " + AutomaticTranscriptCreationInfo.get().getPersons().size()));
    }

    @Generated
    public AutomaticTranscriptionStatusController(STTStatusService sttStatusService, JobCreationService jobCreationService) {
        this.sttStatusService = sttStatusService;
        this.jobCreationService = jobCreationService;
    }

    @Generated
    public Button getCloseButton() {
        return this.closeButton;
    }
}

