/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.menubar;

import afester.javafx.svg.SvgLoader;
import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.Tooltip;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.ExportUtils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.about.AboutController;
import eu.ewerkzeug.easytranscript3.mvc.license.LicenseController;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.mvc.main.MiscService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.DocumentSerializer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ZoomUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.AutomaticTranscriptionStatusController;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.MenuBarService;
import eu.ewerkzeug.easytranscript3.mvc.programsettings.ProgramSettingsController;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.TimeTrackingController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.TranscriptCreationUIHelperService;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.CreateTranscriptController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.importtranscript.ImportTranscriptController;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.print.PrinterJob;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.transform.Scale;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.apache.commons.exec.OS;
import org.controlsfx.control.PopOver;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.model.StyledDocument;
import org.jetbrains.annotations.NotNull;
import org.reactfx.EventStreams;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@FxmlView(value="menuBar.fxml")
@Component
@Lazy
public class MenuBarController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuBarController.class);
    private final LicenseService licenseService;
    private final ExportUtils exportUtils;
    private final SaveTranscriptService saveTranscriptService;
    private final MiscService miscService;
    private final CloseDialog closeDialog;
    private final UpdaterService updaterService;
    private final AutomaticTranscriptionStatusController automaticTranscriptionStatusController;
    private final StatusService statusService;
    private final MenuBarService menuBarService;
    private final LoadTranscriptService loadTranscriptService;
    private final List<Tooltip> tooltipList = new ArrayList();
    private final PopOver automaticTranscriptionStatusPopover = new PopOver();
    private final STTService sttService;
    private final STTStatusService sttStatusService;
    @FXML
    private MenuItem changeMediaFileMenuItem;
    @FXML
    private MenuItem closeTranscriptMenuItem;
    @FXML
    private MenuItem printMenuItem;
    @FXML
    private MenuItem timeTrackingMenuItem;
    @FXML
    private Menu viewMenu;
    @FXML
    private MenuItem saveAsMenuItem;
    @FXML
    private MenuItem newMenuItem;
    @FXML
    private Menu fileMenu;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Button undoButton;
    @FXML
    private Button redoButton;
    @FXML
    private Button cutButton;
    @FXML
    private Button copyButton;
    @FXML
    private Button pasteButton;
    @FXML
    private CheckMenuItem restrictWidthMenuItem;
    @FXML
    private CheckMenuItem showParagraphsNumberingMenuItem;
    @FXML
    private MenuItem saveMenuItem;
    @FXML
    private Button saveButton;
    @FXML
    private Menu recentlyOpenedMenu;
    @FXML
    private CheckMenuItem integrateVideoplayerMenuItem;
    @FXML
    private Button zoomInButton;
    @FXML
    private Button zoomOutButton;
    @FXML
    private Menu editMenu;
    @FXML
    private ToolBar toolBar;
    @FXML
    private Button automaticTranscriptionStatusButton;

    private static void printTextArea(Runnable action) {
        TranscriptTextArea.get().setShowCaret(Caret.CaretVisibility.OFF);
        IndexRange selection = TranscriptTextArea.get().getSelection();
        TranscriptTextArea.get().deselect();
        Scale zoom = ZoomUtils.getZoom();
        String dynamicCss = MenuBarController.addPrintingCss();
        action.run();
        TranscriptTextArea.get().setShowCaret(Caret.CaretVisibility.AUTO);
        TranscriptTextArea.get().selectRange(selection.getStart(), selection.getEnd());
        ZoomUtils.setZoom((Scale)zoom);
        GUIState.getMainStage().getScene().getStylesheets().remove((Object)dynamicCss);
    }

    @NotNull
    private static String addPrintingCss() {
        String css = ".styled-text-area-text {\n    -fx-fill: black !important;\n}\n\n.lct-text-new {\n    -fx-fill: -fx-lct-text-color !important;\n}\n\n.lineno {\n    -fx-text-fill: black !important;\n}\n";
        String dynamicCss = "data:text/css," + css;
        GUIState.getMainStage().getScene().getStylesheets().add((Object)dynamicCss);
        return dynamicCss;
    }

    public void reset() {
    }

    public void initializeController() {
        Platform.runLater(() -> {
            this.menuBar.useSystemMenuBarProperty().bindBidirectional((Property)this.menuBarService.getUseSystemBarMenu());
            this.restrictWidthMenuItem.setSelected(Configuration.get().getWidthOfTextAreaInCm() != -1.0);
            this.showParagraphsNumberingMenuItem.setSelected(Configuration.get().getShowParagraphNumbers());
            if (OS.isFamilyMac()) {
                this.menuBar.setVisible(false);
                this.menuBar.setManaged(false);
            }
            this.updaterService.startUpdateCheck(false);
        });
        this.editMenu.getItems().addAll((Collection)this.menuBarService.createEditMenuItems(true));
        log.debug("Binding properties.");
        this.saveMenuItem.disableProperty().bind((ObservableValue)this.statusService.savedProperty().or((ObservableBooleanValue)this.statusService.transcriptLoadedProperty().not()).or((ObservableBooleanValue)this.statusService.savingProperty()));
        this.saveButton.disableProperty().bind((ObservableValue)this.statusService.savedProperty().or((ObservableBooleanValue)this.statusService.transcriptLoadedProperty().not()).or((ObservableBooleanValue)this.statusService.savingProperty()));
        this.saveAsMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.changeMediaFileMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.closeTranscriptMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.timeTrackingMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.printMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.toolBar.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.editMenu.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.viewMenu.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.copyButton.disableProperty().bind((ObservableValue)this.menuBarService.getSelectionBinding());
        this.cutButton.disableProperty().bind((ObservableValue)this.menuBarService.getSelectionBinding());
        Configuration.get().getProgramRecentLoadedObservableList().addListener(change -> {
            log.debug("List changed: {}", (Object)Configuration.get().getProgramRecentLoadedObservableList());
            Platform.runLater(() -> this.fillRecentLoadedMenu());
        });
        this.fillRecentLoadedMenu();
        this.integrateVideoplayerMenuItem.selectedProperty().bindBidirectional((Property)Configuration.get().integrateVideoplayerProperty());
        EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribeForOne(change -> {
            this.zoomInButton.disableProperty().bind((ObservableValue)TranscriptTextArea.getScaledVirtualized().getZoom().xProperty().isEqualTo(5.0, 0.0));
            this.zoomOutButton.disableProperty().bind((ObservableValue)TranscriptTextArea.getScaledVirtualized().getZoom().xProperty().isEqualTo(0.8, 0.0));
        });
        TranscriptTextArea.get().redoAvailableProperty().addListener((observableValue, aBoolean, t1) -> this.redoButton.setDisable(t1 == false));
        TranscriptTextArea.get().undoAvailableProperty().addListener((observableValue, aBoolean, t1) -> this.undoButton.setDisable(t1 == false));
        this.toolBar.getItems().forEach(f -> {
            if (f instanceof Button) {
                this.tooltipList.add(new Tooltip(f, f.getAccessibleText()));
            }
        });
        this.initializesAutomaticTranscriptionStatusInfo();
    }

    private void initializesAutomaticTranscriptionStatusInfo() {
        this.sttStatusService.getShowStatusInfoPopOver().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.sttStatusService.getShowStatusInfoPopOver().set(false);
                this.showAutomaticTranscriptionStatusPopover();
            }
        });
        InputStream svgFile = this.getClass().getClassLoader().getResourceAsStream(this.getClass().getPackageName().replace(".", "/") + "/automatic_status.svg");
        SvgLoader loader = new SvgLoader();
        Group svgImage = loader.loadSvg(svgFile);
        Group graphic = new Group(new Node[]{svgImage});
        this.automaticTranscriptionStatusButton.setGraphic((Node)graphic);
        this.automaticTranscriptionStatusPopover.setContentNode((Node)this.automaticTranscriptionStatusController);
        this.setDisableOfStatusButton();
        this.automaticTranscriptionStatusController.getCloseButton().setOnAction(e -> this.automaticTranscriptionStatusPopover.hide());
        this.automaticTranscriptionStatusButton.setOnAction(ev -> this.showAutomaticTranscriptionStatusPopover());
        log.debug("Adding phase listener for status button, current phase: {}", (Object)this.sttStatusService.getState());
        this.sttStatusService.getStateMachine().addStateListener((StateMachineListener)new /* Unavailable Anonymous Inner Class!! */);
        this.handleTransferProgressInfoPhaseChange(this.sttStatusService.getState());
        this.automaticTranscriptionStatusPopover.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
        this.automaticTranscriptionStatusPopover.setArrowSize(0.0);
        this.automaticTranscriptionStatusPopover.setDetachable(false);
        this.automaticTranscriptionStatusPopover.setAutoFix(false);
        this.automaticTranscriptionStatusPopover.setCloseButtonEnabled(false);
        this.automaticTranscriptionStatusPopover.setTitle("");
        this.automaticTranscriptionStatusPopover.setAutoHide(true);
    }

    private void handleTransferProgressInfoPhaseChange(String newValue) {
        log.debug("Status of transcription job changed to {}, setting disable status of status button", (Object)newValue);
        if (newValue.equals("UPLOADING")) {
            FxTimer.runLater((Duration)Duration.ofSeconds(2L), () -> this.showAutomaticTranscriptionStatusPopover());
        } else if (newValue.equals("IDLE")) {
            this.automaticTranscriptionStatusPopover.hide();
        }
        this.setDisableOfStatusButton();
    }

    private void setDisableOfStatusButton() {
        this.automaticTranscriptionStatusButton.setVisible(!this.sttStatusService.getState().equals("IDLE"));
    }

    private void showAutomaticTranscriptionStatusPopover() {
        if (LicenseService.getUserLicense() == null || !LicenseService.getUserLicense().isSttEnabled()) {
            return;
        }
        Platform.runLater(() -> {
            Bounds bounds = this.automaticTranscriptionStatusButton.localToScreen(this.automaticTranscriptionStatusButton.getBoundsInLocal());
            this.automaticTranscriptionStatusPopover.show((Node)this.automaticTranscriptionStatusButton, bounds.getMinX() + bounds.getWidth() / 2.0 + 27.0, bounds.getMinY() + bounds.getHeight() + 18.0);
            ((Node)this.automaticTranscriptionStatusPopover.getContentNode().getScene().getRoot().getChildrenUnmodifiable().getFirst()).requestFocus();
        });
    }

    public void createNewTranscript() {
        this.showAdditionalScreen(CreateTranscriptController.class, Modality.WINDOW_MODAL, true);
    }

    public void loadTranscriptWithFileChooser() {
        this.loadTranscriptService.openTranscriptWithFileChooser();
    }

    public void loadOnOpenFilesAction(String path) {
        this.closeDialog.showAndWait(() -> this.loadTranscriptService.openTranscript(Path.of(path, new String[0])));
    }

    public void closeTranscript() {
        this.miscService.closeTranscript();
    }

    public void saveTranscript(ActionEvent e) {
        e.consume();
        log.info("Save triggered.");
        if (Transcript.get() != null && Transcript.get().getTranscriptLocation() != null) {
            this.saveTranscriptService.save(Transcript.get(), DocumentSerializer.serializeContent((StyledDocument)TranscriptTextArea.get().getDocument()), false);
        } else {
            log.error("Could not save transcript because transcript or location is null. Transcript != null? {}, Location != null? {}", (Object)(Transcript.get() != null ? 1 : 0), (Object)(Transcript.get().getTranscriptLocation() != null ? 1 : 0));
        }
        TranscriptTextArea.get().requestFocus();
    }

    public void saveAs() {
        if (!LicenseService.isUserLicenseValid()) {
            Platform.runLater(() -> ((LicenseService)this.licenseService).showLicenseNotValidDialog());
            return;
        }
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        fileChooser.getExtensionFilters().add((Object)Transcript.getEttFilter());
        File file = fileChooser.showSaveDialog((Window)GUIState.getMainStage());
        if (file != null) {
            if (!file.toPath().equals(Transcript.get().getTranscriptLocation())) {
                Transcript.get().setTranscriptLocation(file.toPath());
                Configuration.get().addToRecentLoaded(Transcript.get());
                Configuration.get().save();
                this.miscService.setTitle();
            }
            this.saveTranscript(new ActionEvent());
        }
    }

    public void changeMediaFile() {
        String pathS = TranscriptCreationUIHelperService.openMediaFile((Stage)GUIState.getMainStage());
        if (pathS == null || pathS.isBlank()) {
            return;
        }
        Path path = Path.of(pathS, new String[0]);
        if (path.getParent() != null && path.toFile().exists() && path.toFile().isFile()) {
            Transcript.get().setMediaLocation(path);
            this.statusService.mediaNeedsReloadProperty().set(true);
            this.statusService.setSaved(false);
        } else {
            ETDialog.get((String)Utils.getLocaleBundle().getString("problems.mediaFileNotFound")).showAndWait();
        }
    }

    public void importTranscript() {
        this.showAdditionalScreen(ImportTranscriptController.class, Modality.WINDOW_MODAL, false);
    }

    public void export() {
        log.debug("Triggered export menu item ...");
        if (Transcript.get().getTranscriptLocation() == null) {
            return;
        }
        this.exportUtils.showExportDialog(TranscriptTextArea.get().getDocument());
    }

    public void openTimeTracking() {
        if (Transcript.get().getTranscriptLocation() == null) {
            return;
        }
        this.showAdditionalScreen(TimeTrackingController.class, Modality.WINDOW_MODAL, null, (Window)GUIState.getMainStage(), true, null);
    }

    public void print() {
        if (Transcript.get().getTranscriptLocation() == null) {
            return;
        }
        log.debug("Printing transcript ...");
        if (!LicenseService.isUserLicenseValid()) {
            log.warn("License is not valid anymore.");
            this.licenseService.showLicenseNotValidDialog();
            return;
        }
        PrinterJob job = PrinterJob.createPrinterJob();
        log.debug("Created printer job.");
        if (job != null) {
            if (job.showPrintDialog((Window)GUIState.getMainStage())) {
                MenuBarController.printTextArea(() -> {
                    job.getJobSettings().setJobName("easytranscript - " + String.valueOf(Transcript.get().getTranscriptLocation().getFileName()));
                    job.printPage((Node)TranscriptTextArea.get());
                    job.endJob();
                    log.debug("Printed transcript.");
                });
            }
        } else {
            ETDialog.get((String)Utils.getLocaleBundle().getString("problems.cannotPrint")).showAndWait();
        }
        TranscriptTextArea.get().requestFocus();
    }

    public void openSettings() {
        this.showAdditionalScreen(ProgramSettingsController.class, Modality.WINDOW_MODAL);
    }

    public void closeProgram() {
        this.miscService.closeProgram();
    }

    public void toggleWidthRestriction() {
        if (!TranscriptTextArea.get().isVisible()) {
            return;
        }
        if (Configuration.get().getWidthOfTextAreaInCm() == -1.0) {
            Configuration.get().setWidthOfTextAreaInCm(22.0);
        } else {
            Configuration.get().setWidthOfTextAreaInCm(-1.0);
        }
    }

    public void toggleParagraphsNumbering() {
        if (!TranscriptTextArea.get().isVisible()) {
            return;
        }
        Configuration.get().setShowParagraphNumbers(!Configuration.get().getShowParagraphNumbers());
        Configuration.get().save();
    }

    public void showMailForSupport() {
        try {
            if (!Desktop.isDesktopSupported()) {
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.MAIL)) {
                URI mailto = new URI("mailto:support@easytranscript.de?subject=Feedback");
                desktop.mail(mailto);
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Could not send feedback", (Throwable)e);
        }
    }

    public void showAbout() {
        TranscriptTextArea.get().requestFocus();
        this.showAdditionalScreen(AboutController.class, Modality.WINDOW_MODAL);
    }

    public void checkForUpdates() {
        this.updaterService.startUpdateCheck(true);
    }

    public void registerEasytranscript() {
        TranscriptTextArea.get().requestFocus();
        ExtendedController extendedController = GUIState.getController().showAdditionalScreen(LicenseController.class, Modality.WINDOW_MODAL, false);
        extendedController.getStage().hide();
        extendedController.getStage().show();
    }

    private void fillRecentLoadedMenu() {
        log.debug("Going to fill recent loaded menu...");
        this.recentlyOpenedMenu.getItems().clear();
        ObservableList recent = Configuration.get().getProgramRecentLoadedObservableList();
        int i = 0;
        while (i < recent.size()) {
            MenuItem item = new MenuItem();
            String filename = Path.of((String)recent.get(i), new String[0]).getFileName().toString();
            if (filename.contains(".")) {
                filename = filename.substring(0, filename.lastIndexOf("."));
            }
            item.setText(filename);
            int finalI = i++;
            item.setOnAction(event -> this.closeDialog.showAndWait(() -> {
                if (new File((String)recent.get(finalI)).exists()) {
                    this.loadTranscriptService.openTranscript(Path.of((String)recent.get(finalI), new String[0]));
                } else {
                    ETDialog.get((String)Utils.getLocaleBundle().getString("problems.transcriptFileNotFound")).showAndWait();
                    recent.remove(recent.get(finalI));
                    Configuration.get().save();
                }
            }));
            this.recentlyOpenedMenu.getItems().add((Object)item);
        }
    }

    public void zoomOut() {
        if (TranscriptTextArea.get().isVisible()) {
            ZoomUtils.zoom((boolean)false);
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void zoomIn() {
        if (TranscriptTextArea.get().isVisible()) {
            ZoomUtils.zoom((boolean)true);
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void undo() {
        this.menuBarService.undo();
    }

    public void redo() {
        this.menuBarService.redo();
    }

    public void cut() {
        this.menuBarService.cut();
    }

    public void copy() {
        this.menuBarService.copy();
    }

    public void paste() {
        this.menuBarService.paste();
    }

    public void openSearch() {
        this.menuBarService.showSearch();
    }

    @Generated
    public MenuBarController(LicenseService licenseService, ExportUtils exportUtils, SaveTranscriptService saveTranscriptService, MiscService miscService, CloseDialog closeDialog, UpdaterService updaterService, AutomaticTranscriptionStatusController automaticTranscriptionStatusController, StatusService statusService, MenuBarService menuBarService, LoadTranscriptService loadTranscriptService, STTService sttService, STTStatusService sttStatusService) {
        this.licenseService = licenseService;
        this.exportUtils = exportUtils;
        this.saveTranscriptService = saveTranscriptService;
        this.miscService = miscService;
        this.closeDialog = closeDialog;
        this.updaterService = updaterService;
        this.automaticTranscriptionStatusController = automaticTranscriptionStatusController;
        this.statusService = statusService;
        this.menuBarService = menuBarService;
        this.loadTranscriptService = loadTranscriptService;
        this.sttService = sttService;
        this.sttStatusService = sttStatusService;
    }

    @Generated
    public MenuItem getNewMenuItem() {
        return this.newMenuItem;
    }

    @Generated
    public Menu getFileMenu() {
        return this.fileMenu;
    }

    @Generated
    public MenuBar getMenuBar() {
        return this.menuBar;
    }
}

