/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.player;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.player.Player;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import eu.ewerkzeug.easytranscript3.mvc.player.fx.FXPlayer;
import eu.ewerkzeug.easytranscript3.mvc.player.vlcj.VLCJPlayer;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.media.MediaException;
import lombok.Generated;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlayerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerService.class);
    private final StatusService statusService;
    private final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss-SS").withZone(ZoneId.of("GMT"));
    private boolean addedMediaNeedsReloadListener = false;
    private Subscription mediaNeedsReloadSubscription;

    public void playPause() {
        PlayerState state = (PlayerState)Main.getPlayer().stateProperty().getValue();
        log.debug("Player state: {}", (Object)state.toString());
        if (state.equals((Object)PlayerState.PAUSED) && Configuration.get().isAutoRewindAfterPause()) {
            this.changeTime(false);
        }
        if (state.equals((Object)PlayerState.LOADED) || state.equals((Object)PlayerState.PAUSED) || state.equals((Object)PlayerState.STOPPED)) {
            Main.getPlayer().play();
            log.debug("Playing.");
            log.debug("Speed: {}", (Object)Main.getPlayer().rateProperty().get());
            log.debug("Volume: {}", (Object)Main.getPlayer().volumeProperty().get());
            if (Configuration.get().isUseSavedLastPlayerTime() && !Transcript.get().isAlreadyJumpedToLastPlayerTime() && Transcript.get().getLastPlayerTime() >= 0L) {
                log.debug("Jumping to last player time {}.", (Object)Transcript.get().getLastPlayerTime());
                FxTimer.runLater((Duration)Duration.ofMillis(200L), () -> {
                    Main.getPlayer().setTime(Transcript.get().getLastPlayerTime());
                    Transcript.get().setAlreadyJumpedToLastPlayerTime(true);
                });
            }
            TranscriptTextArea.get().requestFocus();
        } else if (state.equals((Object)PlayerState.PLAYING)) {
            Main.getPlayer().pause();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void changeTime(boolean forward) {
        PlayerState state = (PlayerState)Main.getPlayer().stateProperty().getValue();
        if (!state.equals((Object)PlayerState.PAUSED) && !state.equals((Object)PlayerState.PLAYING)) {
            return;
        }
        if (!forward) {
            Main.getPlayer().rewind((long)Configuration.get().getWindingInterval());
        } else {
            Main.getPlayer().fastForward((long)Configuration.get().getWindingInterval());
        }
        Player player = Main.getPlayer();
        if (player instanceof VLCJPlayer) {
            VLCJPlayer vlcjPlayer = (VLCJPlayer)player;
            if (state.equals((Object)PlayerState.PAUSED)) {
                vlcjPlayer.getTimeProperty().setValue((Number)(vlcjPlayer.getTimeProperty().getValue() + (long)Configuration.get().getWindingInterval() * 1000L * (long)(forward ? 1 : -1)));
            }
        }
        TranscriptTextArea.get().requestFocus();
        log.debug("Changed playback time to position {} with interval {}", (Object)Main.getPlayer().getTime(), (Object)Configuration.get().getWindingInterval());
    }

    public void loadMedia() {
        log.debug("Loading media ...");
        log.debug("Current player state: {}", Main.getPlayer().stateProperty().get());
        Main.getPlayer().stateProperty().set((Object)PlayerState.INITIALIZED);
        try {
            Path media = Transcript.get().getMediaLocation();
            if (media == null || media.toFile().isDirectory()) {
                log.warn("Media is invalid: null or a directory.");
                return;
            }
            if (media.getParent() == null) {
                media = Transcript.get().getTemporaryTranscriptLocation().resolve(media);
            }
            Main.getPlayer().loadMedia(media);
        }
        catch (FileNotFoundException ex) {
            log.error("Media file not found.", (Throwable)ex);
            ExceptionAlert.get().showModal();
        }
        catch (MediaException ex) {
            Platform.runLater(() -> ETDialog.get((String)Utils.getLocaleBundle().getString("problems.FXnotSupported")).showAndWait());
            log.warn("Media format not supported: " + String.valueOf(Transcript.get().getMediaLocation()), (Throwable)ex);
        }
    }

    public void createPlayer() {
        log.debug("Creating player ...");
        boolean changeOfPlayer = Main.getPlayer() instanceof VLCJPlayer && !Configuration.get().isUseVLCPlayer() || Main.getPlayer() instanceof FXPlayer && Configuration.get().isUseVLCPlayer();
        log.debug("Player should be changed: {}", (Object)changeOfPlayer);
        if (Main.getPlayer() != null && changeOfPlayer) {
            Main.getPlayer().release();
            this.addedMediaNeedsReloadListener = false;
        }
        if (Main.getPlayer() == null || changeOfPlayer) {
            if (Configuration.get().isUseVLCPlayer()) {
                this.createVLCPlayerOrFallbackToFX();
            } else {
                Main.setPlayer((Player)new FXPlayer());
            }
        } else {
            log.debug("Player already created.");
        }
        this.addMediaNeedsReloadListener();
        log.info("Player is ready.");
    }

    private void createVLCPlayerOrFallbackToFX() {
        try {
            Main.setPlayer((Player)new VLCJPlayer());
        }
        catch (NullPointerException e) {
            log.error("VLC Installation was not found. Falling back to FXPlayer.", (Throwable)e);
            Main.setPlayer((Player)new FXPlayer());
            Configuration.get().setUseVLCPlayer(false);
        }
    }

    private void addMediaNeedsReloadListener() {
        if (this.addedMediaNeedsReloadListener) {
            return;
        }
        this.statusService.mediaNeedsReloadProperty().addListener((observable, oldBoolean, newBoolean) -> {
            log.debug("Media needs reload set to {}", newBoolean);
            if (this.statusService.isMediaNeedsReload()) {
                this.mediaNeedsReloadSubscription = EventStreams.changesOf((ObservableValue)Main.getPlayer().stateProperty()).subscribe(change -> {
                    if (change.getNewValue() == PlayerState.LOADED) {
                        this.statusService.setMediaNeedsReload(false);
                        this.mediaNeedsReloadSubscription.unsubscribe();
                    }
                });
                this.loadMedia();
            }
        });
        this.addedMediaNeedsReloadListener = true;
    }

    @Generated
    public PlayerService(StatusService statusService) {
        this.statusService = statusService;
    }

    @Generated
    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }
}

