/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.player.vlcj;

import com.sun.jna.NativeLibrary;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.io.ETFileNotFoundException;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.player.Player;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import eu.ewerkzeug.easytranscript3.mvc.player.vlcj.VLCJPlayer;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.lib.LibC;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.javafx.videosurface.ImageViewVideoSurface;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;

/*
 * Exception performing whole class analysis ignored.
 */
public class VLCJPlayer
implements Player {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VLCJPlayer.class);
    private static final BooleanProperty discovered = new SimpleBooleanProperty(false);
    private static final SimpleBooleanProperty interfaceListensToStatusChangesProperty = new SimpleBooleanProperty(false);
    private static final ArrayList<String> supportedExtensions = new ArrayList();
    private static final ArrayList<FileChooser.ExtensionFilter> supportedFormats = new ArrayList();
    private final MediaPlayerFactory mediaPlayerFactory;
    private final EmbeddedMediaPlayer mediaPlayer;
    private final Pane canvasPane;
    private final ObjectProperty<PlayerState> state = new SimpleObjectProperty((Object)PlayerState.NOT_INITIALIZED);
    private final ObjectProperty<Path> mediaPath = new SimpleObjectProperty();
    private final DoubleProperty volume = new SimpleDoubleProperty(1.0);
    private final DoubleProperty speed = new SimpleDoubleProperty(1.0);
    private final IntegerProperty maximumVolume = new SimpleIntegerProperty(200);
    private final LongProperty durationProperty = new SimpleLongProperty(0L);
    private final LongProperty timeProperty = new SimpleLongProperty();
    private final ImageView videoImageView;

    public VLCJPlayer() throws NullPointerException {
        log.info("Initializing VLCJPlayer...");
        if (!VLCJPlayer.discover()) {
            throw new NullPointerException("VLC was not found, thus VLCJPlayer is not supported.");
        }
        this.state.addListener((observable, oldValue, newValue) -> log.debug("Changed to state {}", newValue));
        this.mediaPlayerFactory = new MediaPlayerFactory();
        this.mediaPlayer = this.mediaPlayerFactory.mediaPlayers().newEmbeddedMediaPlayer();
        this.videoImageView = new ImageView();
        this.videoImageView.setPreserveRatio(true);
        ImageViewVideoSurface javaFxVideoSurface = new ImageViewVideoSurface(this.videoImageView);
        this.mediaPlayer.videoSurface().set((VideoSurface)javaFxVideoSurface);
        this.canvasPane = new StackPane();
        this.canvasPane.setStyle("-fx-background-color: transparent");
        this.canvasPane.getChildren().add((Object)this.videoImageView);
        this.videoImageView.fitWidthProperty().bind((ObservableValue)this.canvasPane.widthProperty());
        this.videoImageView.fitHeightProperty().bind((ObservableValue)this.canvasPane.heightProperty());
        this.mediaPlayer.events().addMediaPlayerEventListener((MediaPlayerEventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.speed.addListener(observable -> this.setRate(this.speed.doubleValue()));
        this.state.setValue((Object)PlayerState.INITIALIZED);
    }

    public static boolean discover() {
        log.debug("Searching for vlc libraries...");
        String path = Configuration.get().getVlcPath();
        log.debug("Path: {}", (Object)path);
        try {
            if (path.isEmpty()) {
                new NativeDiscovery(new NativeDiscoveryStrategy[0]).discover();
            } else {
                String libPath = path + "/lib";
                if (RuntimeUtil.isMac()) {
                    String pluginPath = path + "/plugins/";
                    NativeLibrary.addSearchPath((String)(RuntimeUtil.getLibVlcLibraryName() + "core"), (String)libPath);
                    System.setProperty("VLC_PLUGIN_PATH", pluginPath);
                    LibC.INSTANCE.setenv("VLC_PLUGIN_PATH", pluginPath, 1);
                    NativeLibrary.getInstance((String)(RuntimeUtil.getLibVlcLibraryName() + "core"));
                }
                NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)libPath);
            }
        }
        catch (Error | Exception e) {
            log.error("Could not discover vlc.", e);
            return false;
        }
        try {
            log.info("found VLC Version: {}", (Object)LibVlc.libvlc_get_version());
            discovered.set(true);
            return true;
        }
        catch (Error | Exception e) {
            log.info("vlc was not loaded.");
            log.debug("", e);
            return false;
        }
    }

    public static List<String> getSupportedExtensions() {
        return supportedExtensions;
    }

    public static List<FileChooser.ExtensionFilter> getSupportedFormats() {
        return supportedFormats;
    }

    public Pane getPlayerPane() {
        return this.canvasPane;
    }

    public void loadMedia(Path path) throws FileNotFoundException {
        log.debug("Loading Media ...");
        if (((PlayerState)this.stateProperty().get()).equals((Object)PlayerState.RELEASED)) {
            throw new IllegalStateException("Player is released.");
        }
        if (path == null || !path.toFile().exists()) {
            throw new ETFileNotFoundException(Utils.getLocaleBundle().getString("problems.mediaFileNotFound"), "Media file does not exist");
        }
        this.mediaPath.setValue((Object)path);
        this.mediaPlayer.media().startPaused(path.toString(), new String[0]);
        this.durationProperty.setValue((Number)this.mediaPlayer.status().length());
        this.timeProperty.setValue((Number)0);
        this.state.setValue((Object)PlayerState.LOADED);
        log.info("Media loaded.");
        this.mediaPlayer.media().events().addMediaEventListener((uk.co.caprica.vlcj.media.MediaEventListener)new MediaEventListener(this.durationProperty));
        FxTimer.runLater((Duration)Duration.of(10L, ChronoUnit.SECONDS), () -> Platform.runLater(() -> this.testMedia()));
    }

    private void testMedia() {
        if (this.mediaPlayer.media().info().duration() <= 0L) {
            log.error("Media seems to have odd properties.");
            log.error("Duration: {}", (Object)this.mediaPlayer.media().info().duration());
            ETDialog.get((String)Utils.getLocaleBundle().getString("problems.VLCnotSupported")).showAndWait();
        }
    }

    public void logMediaDebugInformation() {
        log.debug("Media debug information");
        log.debug("-----------------------");
        if (!this.mediaPlayer.media().isValid()) {
            log.debug("Media not loaded, no information available. Is the media path still correct?");
            return;
        }
        log.debug("Current State: {}", (Object)this.mediaPlayer.media().info().state().toString());
        log.debug("Duration: {}", (Object)this.mediaPlayer.media().info().duration());
        log.debug("Audio Tracks count: {}", (Object)this.mediaPlayer.media().info().audioTracks().size());
        log.debug("Video Tracks count: {}", (Object)this.mediaPlayer.media().info().videoTracks().size());
        if (!this.mediaPlayer.media().info().videoTracks().isEmpty()) {
            log.debug("Video dimension: [{},{}]", (Object)this.mediaPlayer.video().videoDimension().getWidth(), (Object)this.mediaPlayer.video().videoDimension().getHeight());
        }
    }

    public void play() {
        if (((PlayerState)this.state.getValue()).equals((Object)PlayerState.LOADED)) {
            if (this.mediaPlayer.controls().start()) {
                this.state.setValue((Object)PlayerState.PLAYING);
            } else {
                this.state.setValue((Object)PlayerState.ERROR);
            }
        } else if (((PlayerState)this.state.getValue()).equals((Object)PlayerState.PAUSED)) {
            this.mediaPlayer.controls().setPause(false);
            this.state.setValue((Object)PlayerState.PLAYING);
        } else if (((PlayerState)this.state.getValue()).equals((Object)PlayerState.STOPPED)) {
            boolean success = this.mediaPlayer.media().prepare(((Path)this.mediaPath.getValue()).toString(), new String[0]);
            if (success) {
                success = this.mediaPlayer.controls().start();
            }
            if (!success) {
                log.error("Failed to prepare media.");
            } else {
                this.state.setValue((Object)PlayerState.PLAYING);
            }
        }
    }

    public void pause() {
        this.mediaPlayer.controls().setPause(true);
        this.state.setValue((Object)PlayerState.PAUSED);
    }

    public void stop() {
        if (this.state.getValue() == PlayerState.PLAYING || this.state.getValue() == PlayerState.PAUSED || this.state.getValue() == PlayerState.LOADED) {
            this.mediaPlayer.controls().stop();
        }
        this.state.setValue((Object)PlayerState.STOPPED);
    }

    public void release() {
        log.debug("Releasing media player ...");
        this.stop();
        this.state.setValue((Object)PlayerState.RELEASED);
        interfaceListensToStatusChangesProperty.set(false);
        this.mediaPlayer.release();
        this.mediaPlayerFactory.release();
        log.info("Media Player released.");
    }

    public void rewind(long s) {
        this.fastForward(-s);
    }

    public void fastForward(long s) {
        this.mediaPlayer.controls().setTime(this.mediaPlayer.status().time() + s * 1000L);
    }

    public boolean isVideo() {
        return !((PlayerState)this.state.get()).equals((Object)PlayerState.STOPPED) && !((PlayerState)this.state.get()).equals((Object)PlayerState.NOT_INITIALIZED) && !((PlayerState)this.state.get()).equals((Object)PlayerState.RELEASED) && this.mediaPlayer != null && this.mediaPlayer.media() != null && this.mediaPlayer.media().info() != null && this.mediaPlayer.media().info().videoTracks() != null && !this.mediaPlayer.media().info().videoTracks().isEmpty();
    }

    public Dimension getVideoDimension() {
        return this.mediaPlayer.video().videoDimension();
    }

    public long getTime() {
        return this.mediaPlayer.status().time();
    }

    public void setTime(long ms) {
        this.mediaPlayer.controls().setTime(ms);
        log.debug("Set time of media player to {} ms. Actual time now: {}", (Object)ms, (Object)this.getTime());
    }

    public long getDuration() {
        return this.durationProperty.get();
    }

    public LongProperty durationProperty() {
        return this.durationProperty;
    }

    public long getDurationOf(Path path) {
        MediaPlayer tmpMediaPlayer = this.mediaPlayerFactory.mediaPlayers().newMediaPlayer();
        tmpMediaPlayer.media().startPaused(path.toString(), new String[0]);
        long duration = tmpMediaPlayer.media().info().duration();
        tmpMediaPlayer.controls().stop();
        tmpMediaPlayer.release();
        return duration;
    }

    public void setVolume(double value) {
        this.volume.setValue((Number)value);
        if (value > 1.5) {
            value = 1.5;
        } else if (value < 0.0) {
            value = 0.0;
        }
        this.mediaPlayer.audio().setVolume((int)(value * 100.0));
    }

    public void setRate(double value) {
        this.speed.setValue((Number)value);
        if (value > 2.0) {
            value = 2.0;
        } else if (value < 0.5) {
            value = 0.5;
        }
        this.mediaPlayer.controls().setRate((float)value);
    }

    public ObjectProperty<Path> mediaPathProperty() {
        return this.mediaPath;
    }

    public ObjectProperty<PlayerState> stateProperty() {
        return this.state;
    }

    public DoubleProperty volumeProperty() {
        return this.volume;
    }

    public DoubleProperty rateProperty() {
        return this.speed;
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public boolean isMediaLoaded() {
        return this.mediaPlayer.media().isValid();
    }

    public boolean doesInterfaceListenToStatusChanges() {
        return interfaceListensToStatusChangesProperty.getValue();
    }

    public void setInterfaceListensToStatusChanges(boolean addedTimeListener) {
        interfaceListensToStatusChangesProperty.set(addedTimeListener);
    }

    public IntegerProperty maximumVolumeProperty() {
        return this.maximumVolume;
    }

    private void showVideo(boolean show) {
        Platform.runLater(() -> this.getPlayerPane().setVisible(show));
    }

    @Generated
    public LongProperty getTimeProperty() {
        return this.timeProperty;
    }

    static {
        FileChooser.ExtensionFilter audioFilter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("createTranscriptScreen.filePickerAudioFiles"), new String[]{"*.mpg", "*.mpeg", "*.m1v", "*.mp2", "*.mp3", "*.mpa", "*.mpe", "*.aiff", "*.aif", "*.wav", "*.m3u", "*.ogg", "*.oga", "*.wma", "*.flac", "*.m4a", "*.aac", "*.caf", "*.spx", "*.aa3", "*.oma", "*.at3", "*.at9", "*.wv", "*.wvc", "*.mod", "*.ape", "*.ra", "*.ram", "*.amr", "*.3ga", "*.midi", "*.pcm", "*.qcp"});
        FileChooser.ExtensionFilter videoFilter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("createTranscriptScreen.filePickerVideoFiles"), new String[]{"*.es", "*.ps", "*.ts", "*.pva", "*.flv", "*.f4v", "*.mp4", "*.m4v", "*.avi", "*.asf", "*.wmv", "*.mp4", "*.mov", "*.3gp", "*.ogg", "*.ogm", "*.mkv"});
        FileChooser.ExtensionFilter mediaFilter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("createTranscriptScreen.filePickerMediaFiles"), (String[])Stream.of(audioFilter.getExtensions(), videoFilter.getExtensions()).flatMap(Collection::stream).toArray(String[]::new));
        supportedFormats.add(mediaFilter);
        supportedFormats.add(audioFilter);
        supportedFormats.add(videoFilter);
        supportedExtensions.addAll(audioFilter.getExtensions());
        supportedExtensions.addAll(videoFilter.getExtensions());
    }
}

