/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript;

import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.shape.SVGPath;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class DictionaryUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryUtils.class);

    static void addNewDictionaryEntry(GridPane dictionaryGridPane, String entry) {
        log.debug("Adding new dictionary entry.");
        JFXTextField full = new JFXTextField(entry);
        full.setPromptText(Utils.getLocaleBundle().getString("createTranscriptScreen.dictionaryWord"));
        full.textProperty().addListener((observableValue, s, t1) -> {
            if (s.isEmpty() && !t1.isEmpty() && GridPane.getRowIndex((Node)full) + 1 == Utils.getGridPaneRowCount((GridPane)dictionaryGridPane)) {
                DictionaryUtils.addNewDictionaryEntry((GridPane)dictionaryGridPane, (String)"");
            }
        });
        Button deleteButton = new Button();
        SVGPath svgPath = new SVGPath();
        svgPath.setContent("M9.05160734,0.162718455 C9.26856528,-0.054239485 9.62032361,-0.054239485 9.83728155,0.162718455 C10.034516,0.359952946 10.0524464,0.668592711 9.89107277,0.886082706 L9.83728155,0.948392656 L0.948392656,9.83728155 C0.731434716,10.0542395 0.379676395,10.0542395 0.162718455,9.83728155 C-0.0345160359,9.64004705 -0.0524464441,9.33140729 0.10892723,9.11391729 L0.162718455,9.05160734 L9.05160734,0.162718455 ZM9.05160734,0.162718455 C9.26856528,-0.054239485 9.62032361,-0.054239485 9.83728155,0.162718455 C10.034516,0.359952946 10.0524464,0.668592711 9.89107277,0.886082706 L9.83728155,0.948392656 L0.948392656,9.83728155 C0.731434716,10.0542395 0.379676395,10.0542395 0.162718455,9.83728155 C-0.0345160359,9.64004705 -0.0524464441,9.33140729 0.10892723,9.11391729 L0.162718455,9.05160734 L9.05160734,0.162718455 Z M0.162718455,0.162718455 C0.359952946,-0.0345160359 0.668592711,-0.0524464441 0.886082706,0.10892723 L0.948392656,0.162718455 L9.83728155,9.05160734 C10.0542395,9.26856528 10.0542395,9.62032361 9.83728155,9.83728155 C9.64004705,10.034516 9.33140729,10.0524464 9.11391729,9.89107277 L9.05160734,9.83728155 L0.162718455,0.948392656 C-0.054239485,0.731434716 -0.054239485,0.379676395 0.162718455,0.162718455 ZM0.162718455,0.162718455 C0.359952946,-0.0345160359 0.668592711,-0.0524464441 0.886082706,0.10892723 L0.948392656,0.162718455 L9.83728155,9.05160734 C10.0542395,9.26856528 10.0542395,9.62032361 9.83728155,9.83728155 C9.64004705,10.034516 9.33140729,10.0524464 9.11391729,9.89107277 L9.05160734,9.83728155 L0.162718455,0.948392656 C-0.054239485,0.731434716 -0.054239485,0.379676395 0.162718455,0.162718455 Z");
        svgPath.getStyleClass().add((Object)"delete-icon");
        deleteButton.setGraphic((Node)svgPath);
        deleteButton.setOnAction(event -> {
            Utils.deleteRow((GridPane)dictionaryGridPane, (int)GridPane.getRowIndex((Node)deleteButton));
            if (Utils.getGridPaneRowCount((GridPane)dictionaryGridPane) == 1) {
                dictionaryGridPane.getChildren().forEach(f -> f.setOpacity(1.0));
            }
            if (Utils.getGridPaneRowCount((GridPane)dictionaryGridPane) == 0) {
                DictionaryUtils.addNewDictionaryEntry((GridPane)dictionaryGridPane, (String)"");
            }
        });
        deleteButton.disableProperty().bind((ObservableValue)full.opacityProperty().lessThan(1));
        dictionaryGridPane.addRow(Utils.getGridPaneRowCount((GridPane)dictionaryGridPane), new Node[]{full, deleteButton});
        if (GridPane.getRowIndex((Node)full) != 0 && full.getText().isEmpty()) {
            full.setOpacity(0.5);
            deleteButton.setOpacity(0.5);
        }
        ChangeListener focusedListener = (observable, oldValue, newValue) -> {
            if (Boolean.FALSE.equals(oldValue) && Boolean.TRUE.equals(newValue)) {
                full.setOpacity(1.0);
                deleteButton.setOpacity(1.0);
            } else if (!newValue.booleanValue() && full.getText().isEmpty()) {
                full.setOpacity(0.5);
                deleteButton.setOpacity(0.5);
            }
        };
        full.focusedProperty().addListener(focusedListener);
    }

    static void readDictionaryFromFile(GridPane dictionaryGridPane) {
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Text", new String[]{"*.txt"});
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        fileChooser.getExtensionFilters().add((Object)filter);
        File file = fileChooser.showOpenDialog(dictionaryGridPane.getScene().getWindow());
        if (file == null) {
            return;
        }
        Main.setRecentOpenedFileChooserPath((File)file.toPath().getParent().toFile());
        dictionaryGridPane.getChildren().clear();
        try {
            List<String> strings = Files.readAllLines(file.toPath());
            for (String s : strings) {
                DictionaryUtils.addNewDictionaryEntry((GridPane)dictionaryGridPane, (String)s);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        DictionaryUtils.addNewDictionaryEntry((GridPane)dictionaryGridPane, (String)"");
    }

    static void clearDictionary(GridPane dictionaryGridPane) {
        dictionaryGridPane.getChildren().clear();
        DictionaryUtils.addNewDictionaryEntry((GridPane)dictionaryGridPane, (String)"");
    }

    @Generated
    private DictionaryUtils() {
    }
}

