/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.RequiredFieldValidator;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.DurationPicker;
import eu.ewerkzeug.easytranscript3.mvc.transcript.TranscriptCreationUIHelperService;
import java.io.IOException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeakerFileEntry
extends VBox {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerFileEntry.class);
    private final SimpleBooleanProperty validProperty = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty showDetailsProperty = new SimpleBooleanProperty(false);
    @FXML
    private Label mediaPathLabel;
    @FXML
    private Button removeSpeakerButton;
    @FXML
    private Button mediaFileButton;
    @FXML
    private JFXTextField speakerNameTextField;
    @FXML
    private DurationPicker durationPicker;
    @FXML
    private HBox detailsHBox;

    public SpeakerFileEntry() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setLocation(this.getClass().getClassLoader().getResource(this.getClass().getPackageName().replace(".", "/") + "/speakerFileEntry.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setResources(Utils.getLocaleBundle());
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.detailsHBox.visibleProperty().bind((ObservableValue)this.showDetailsProperty);
        this.detailsHBox.managedProperty().bind((ObservableValue)this.showDetailsProperty);
        this.mediaFileButton.setText(this.mediaFileButton.getText() + " \u203a");
        this.removeSpeakerButton.setOnAction(event -> this.removeSpeaker());
        this.mediaFileButton.setOnAction(event -> {
            String media = TranscriptCreationUIHelperService.openMediaFile((Stage)((Stage)this.mediaFileButton.getScene().getWindow()));
            if (!media.isEmpty()) {
                this.mediaPathLabel.setText(media);
            }
        });
        this.mediaPathLabel.textProperty().addListener((observable, oldValue, newValue) -> this.checkForValidity());
        this.speakerNameTextField.textProperty().addListener((observable, oldValue, newValue) -> this.checkForValidity());
        this.speakerNameTextField.getValidators().add((Object)new RequiredFieldValidator(Utils.getLocaleBundle().getString("createTranscriptScreen.pleaseEnterName")));
        this.speakerNameTextField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.speakerNameTextField.validate();
            }
        });
        this.showDetailsProperty.addListener((observable, oldValue, newValue) -> this.checkForValidity());
    }

    public SpeakerFileEntry(String mediaPath, BooleanProperty showDetails) {
        this();
        this.mediaPathLabel.setText(mediaPath);
        this.showDetailsProperty.bind((ObservableValue)showDetails);
    }

    private void checkForValidity() {
        this.validProperty.set(!this.mediaPathLabel.getText().isBlank() && (!this.showDetailsProperty.get() || !this.speakerNameTextField.getText().isBlank()));
    }

    public void removeSpeaker() {
        Parent parent = this.getParent();
        if (parent instanceof Pane) {
            Pane pane = (Pane)parent;
            pane.getChildren().remove((Object)this);
        } else {
            log.error("Could not remove this speakerFileEntry because parent is not a pane.");
        }
    }

    @Generated
    public SimpleBooleanProperty getShowDetailsProperty() {
        return this.showDetailsProperty;
    }

    @Generated
    public Label getMediaPathLabel() {
        return this.mediaPathLabel;
    }

    @Generated
    public Button getRemoveSpeakerButton() {
        return this.removeSpeakerButton;
    }

    @Generated
    public Button getMediaFileButton() {
        return this.mediaFileButton;
    }

    @Generated
    public JFXTextField getSpeakerNameTextField() {
        return this.speakerNameTextField;
    }

    @Generated
    public DurationPicker getDurationPicker() {
        return this.durationPicker;
    }

    @Generated
    public HBox getDetailsHBox() {
        return this.detailsHBox;
    }

    @Generated
    public SimpleBooleanProperty getValidProperty() {
        return this.validProperty;
    }
}

