/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.updater;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.MarkdownToFXConverter;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETProgressBar;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MiscService;
import eu.ewerkzeug.easytranscript3.mvc.updater.DownloadTask;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@FxmlView(value="updaterScreen.fxml")
@StageTitle(value="%updaterScreen.Title")
@Lazy
public class UpdaterController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdaterController.class);
    private final ExecutorService executorService;
    private final DecimalFormat percentageFormat = new DecimalFormat("#0");
    private final DecimalFormat mbTwoDecimals = new DecimalFormat("#0.00");
    private final MiscService miscService;
    @FXML
    public SpacedText updateChannelInformation;
    @FXML
    private Label totalSizeText;
    @FXML
    private Label currentSizeText;
    @FXML
    private ETProgressBar progressBar;
    @FXML
    private Label progressBarText;
    @FXML
    private VBox downloadProgressInformationVBox;
    @FXML
    private Button cancelButton;
    @FXML
    private Button installButton;
    @FXML
    private VBox changelogVBox;
    @FXML
    private Label currentVersionText;
    @FXML
    private Label newVersionText;
    private String newVersion;
    private String channel;
    private ChangeListener<? super Number> percentageListener;
    private ChangeListener<? super Number> workDoneListener;
    private ChangeListener<? super Number> totalWorkListener;
    private DownloadTask task;

    @FXML
    void close() {
        if (this.task != null) {
            this.task.cancel(true);
            if (this.task.getDownloadInputStream() != null) {
                try {
                    this.task.getDownloadInputStream().close();
                }
                catch (IOException e) {
                    log.error("Could not close input Stream.", (Throwable)e);
                }
            }
        }
        ((Stage)this.cancelButton.getScene().getWindow()).close();
    }

    public void setNewVersion(Version newVersion) {
        this.newVersion = newVersion.toString();
    }

    @FXML
    public void initializeController() {
        log.debug("Initialized update controller screen.");
    }

    public void install() {
        log.debug("Installing update ...");
        this.installButton.setDisable(true);
        this.downloadProgressInformationVBox.setVisible(true);
        this.progressBar.setValue(0.0);
        String fileName = this.determineFilename();
        String os = this.determineOS();
        if (os == null) {
            return;
        }
        Path localInstallerTmpPath = Main.getEasytranscriptTempDirectory().resolve(fileName);
        URL downloadURL = this.getDownloadURL(os, fileName);
        if (downloadURL == null) {
            log.error("DownloadURL is null in UpdateController#install.");
            ExceptionAlert.get().showModal();
            return;
        }
        this.task = new DownloadTask(downloadURL, localInstallerTmpPath);
        this.workDoneListener = (observable, oldValue, newValue) -> this.currentSizeText.setText(this.mbTwoDecimals.format(newValue.doubleValue() / 1000.0));
        this.totalWorkListener = (observable, oldValue, newValue) -> this.totalSizeText.setText(this.mbTwoDecimals.format(newValue.doubleValue() / 1000.0) + " MB");
        this.percentageListener = (observable, oldValue, newValue) -> {
            double val = Math.round(newValue.doubleValue() * 100.0);
            this.progressBarText.setText(this.percentageFormat.format(val < 0.0 ? 0.0 : val) + "%");
        };
        this.progressBar.valueProperty().bind((ObservableValue)this.task.progressProperty().multiply(100));
        this.task.workDoneProperty().addListener((ChangeListener)new WeakChangeListener(this.workDoneListener));
        this.task.totalWorkProperty().addListener((ChangeListener)new WeakChangeListener(this.totalWorkListener));
        this.task.progressProperty().addListener((ChangeListener)new WeakChangeListener(this.percentageListener));
        this.task.setOnSucceeded(event -> this.onFinishedDownload(localInstallerTmpPath, downloadURL));
        this.task.setOnFailed(workerStateEvent -> this.onFailedDownload());
        this.executorService.submit((Runnable)this.task);
    }

    @Nullable
    private String determineOS() {
        String os;
        if (SystemUtils.IS_OS_MAC) {
            os = "mac";
        } else if (SystemUtils.IS_OS_WINDOWS) {
            os = "windows";
        } else {
            log.error("Unsupported os: {}", (Object)System.getProperty("os.name"));
            ExceptionAlert.get().showModal();
            return null;
        }
        return os;
    }

    @NotNull
    private String determineFilename() {
        String postfix = "";
        String installExtension = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            postfix = "-setup";
            installExtension = "exe";
        } else if (SystemUtils.IS_OS_MAC) {
            if (System.getProperty("os.arch").equals("aarch64")) {
                postfix = "_aarch64";
            }
            installExtension = "dmg";
        }
        return "easytranscript_" + this.newVersion + postfix + "." + installExtension;
    }

    private void onFailedDownload() {
        ETDialog.get((String)Utils.getLocaleBundle().getString("updaterScreen.failedToDownload"), (Alert.AlertType)Alert.AlertType.WARNING).showAndWait();
        this.close();
    }

    private void onFinishedDownload(Path localInstallerTmpPath, URL downloadURL) {
        log.debug("Download was successful. Validating...");
        this.percentageListener = null;
        this.workDoneListener = null;
        this.totalWorkListener = null;
        this.progressBar.valueProperty().unbind();
        this.progressBar.setValue(0.0);
        this.progressBarText.setText(Utils.getLocaleBundle().getString("updaterScreen.validating"));
        if (this.isHashOfDownloadInvalid(localInstallerTmpPath, downloadURL)) {
            return;
        }
        this.startInstaller(localInstallerTmpPath);
    }

    private void startInstaller(Path localInstallerTmpPath) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                log.debug("Launching installer on Windows...");
                Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"\"", localInstallerTmpPath.toString()});
            } else if (SystemUtils.IS_OS_MAC) {
                log.debug("Mounting dmg on macOS...");
                Runtime.getRuntime().exec(new String[]{"open", localInstallerTmpPath.toString()});
            } else {
                log.debug("Running installer on Linux/other...");
                Runtime.getRuntime().exec(new String[]{localInstallerTmpPath.toString()});
            }
            Platform.runLater(() -> ((MiscService)this.miscService).closeProgram());
        }
        catch (Exception e) {
            log.error("Could not start installer.", (Throwable)e);
            ETDialog.get((String)Utils.getLocaleBundle().getString("updaterScreen.couldNotStartInstaller")).showAndWait();
        }
    }

    private boolean isHashOfDownloadInvalid(Path localInstallerTmpPath, URL downloadURL) {
        try {
            URL url = URI.create(downloadURL.toString() + ".sha256").toURL();
            InputStreamReader isr = new InputStreamReader(url.openStream());
            String downloadedHash = IOUtils.toString((Reader)isr);
            downloadedHash = downloadedHash.substring(0, downloadedHash.indexOf(" "));
            FileInputStream fileInputStream = new FileInputStream(localInstallerTmpPath.toFile());
            String calculatedHash = DigestUtils.sha256Hex((InputStream)fileInputStream);
            fileInputStream.close();
            if (!downloadedHash.equals(calculatedHash)) {
                log.error("Hashes are not equal. {}(downloaded) != {}(calculated)", (Object)downloadedHash, (Object)calculatedHash);
                ExceptionAlert.get().showModal();
                this.close();
                return true;
            }
            log.info("Hashes are equal: {}", (Object)downloadedHash);
        }
        catch (IOException e) {
            log.error("Download of hash failed.", (Throwable)e);
            ExceptionAlert.get().showModal();
            this.close();
            return false;
        }
        return false;
    }

    private URL getDownloadURL(String os, String fileName) {
        try {
            return URI.create(String.join((CharSequence)"/", "https://get.easytranscript.de/easytranscript3", this.channel, this.newVersion, os, fileName).replace(" ", "%20")).toURL();
        }
        catch (MalformedURLException e) {
            log.error("Could not create download url.", (Throwable)e);
            return null;
        }
    }

    public void reset() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.progressBar.setChangeable(false);
        this.downloadProgressInformationVBox.setVisible(false);
        this.newVersionText.setText(this.newVersion);
        this.currentVersionText.setText(Configuration.get().getVersion().toString());
        this.updateChannelInformation.setText(MessageFormat.format(Utils.getLocaleBundle().getString("updaterScreen.updateChannelInformation"), Configuration.get().getChannel().equals((Object)Channel.BETA) ? Utils.getLocaleBundle().getString("updaterScreen.betaVersion") : Utils.getLocaleBundle().getString("updaterScreen.stableVersion")));
        this.progressBarText.setText("");
        this.progressBar.valueProperty().unbind();
        this.progressBar.setValue(0.0);
        this.currentSizeText.textProperty().unbind();
        this.currentSizeText.setText("");
        this.totalSizeText.textProperty().unbind();
        this.totalSizeText.setText("");
        this.installButton.setDisable(false);
        Platform.runLater(() -> {
            this.changelogVBox.getChildren().clear();
            VBox content = MarkdownToFXConverter.parseMarkdownToTextFlow((String)((String)this.getStage().getUserData()));
            content.setDisable(true);
            this.changelogVBox.getChildren().add((Object)content);
        });
    }

    @Generated
    public UpdaterController(ExecutorService executorService, MiscService miscService) {
        this.executorService = executorService;
        this.miscService = miscService;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }
}

