/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.updater;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.SpringBootJavaFxApplication;
import eu.ewerkzeug.easytranscript3.commons.RuntimeUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterController;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.utils.StringUtils;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UpdaterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdaterService.class);
    static final String BASE_URL = "https://get.easytranscript.de/easytranscript3";
    private final UpdaterController updaterController;
    private final ExecutorService executorService;
    private final WebClient.Builder webClientBuilder;
    private WebClient webClient;

    private static Pair<Version, Channel> check(Version versionToCheckAgainst, boolean checkBetaChannel) {
        log.debug("Checking for new version, current version: {}, checking beta: {}", (Object)versionToCheckAgainst.toString(), (Object)checkBetaChannel);
        String versionStringStable = UpdaterService.getVersionString((Channel)Channel.STABLE);
        Version version = null;
        Channel channel = null;
        if (versionStringStable != null) {
            try {
                version = Version.parse((String)versionStringStable);
                channel = Channel.STABLE;
            }
            catch (Exception e) {
                log.error("could not parse version string to version.", (Throwable)e);
            }
        }
        if (checkBetaChannel) {
            String versionStringBeta = UpdaterService.getVersionString((Channel)Channel.BETA);
            Version betaVersion = null;
            if (versionStringBeta != null) {
                try {
                    betaVersion = Version.parse((String)versionStringBeta);
                }
                catch (Exception e) {
                    log.error("could not parse version string to version.", (Throwable)e);
                }
            }
            if (betaVersion != null && betaVersion.isHigherThan(version)) {
                version = betaVersion;
                channel = Channel.BETA;
            }
        }
        if (version != null && versionToCheckAgainst.isLowerThan(version)) {
            return Pair.of((Object)version, (Object)channel);
        }
        return Pair.of((Object)Configuration.get().getVersion(), (Object)Configuration.get().getChannel());
    }

    private static String getVersionString(Channel channel) {
        URL url;
        try {
            url = new URL("https://get.easytranscript.de/easytranscript3/" + channel.toString().toLowerCase() + "/latest-version");
        }
        catch (MalformedURLException e) {
            log.warn("Unable to detect latest version with channel " + String.valueOf(channel), (Throwable)e);
            return null;
        }
        try {
            InputStreamReader isr = new InputStreamReader(url.openStream());
            Object versionString = IOUtils.toString((Reader)isr).trim();
            if (((String)versionString).split("\\.").length == 2) {
                versionString = (String)versionString + ".0";
            }
            log.debug("Got version string \"{}\" for channel {} from server.", versionString, (Object)channel);
            return versionString;
        }
        catch (IOException e) {
            log.warn("Unable to detect latest version with channel {}", (Object)channel, (Object)e);
            return null;
        }
    }

    @PostConstruct
    public void setup() {
        this.webClient = this.webClientBuilder.build();
    }

    public void startUpdateCheck(boolean informUserIfUpToDate) {
        boolean[] startUpdateScreen = new boolean[]{false};
        Version[] newVersion = new Version[1];
        Channel[] newChannel = new Channel[1];
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        this.executorService.submit((Runnable)task);
        task.setOnSucceeded(e -> FxTimer.runLater((Duration)Duration.of(4L, ChronoUnit.SECONDS), () -> Platform.runLater(() -> {
            if (startUpdateScreen[0]) {
                if (this.isNotBundledJRE() || this.areUpdatesManagedBySystem()) {
                    log.debug("Showing website dialog instead of changelog.");
                    this.showInstructionsOnHowToUpdate();
                } else {
                    this.updaterController.setNewVersion(newVersion[0]);
                    this.updaterController.setChannel(newChannel[0].toString());
                    String url = "%s/changelogs/changelog_%s.md".formatted("https://get.easytranscript.de/easytranscript3", Configuration.get().getProgramLanguage());
                    log.debug("Loading changelog from {}", (Object)url);
                    this.webClient.get().uri(url, new Object[0]).retrieve().bodyToMono(String.class).onErrorResume(error -> {
                        log.error("Failed to retrieve changelog.", error);
                        return Mono.just((Object)Utils.getLocaleBundle().getString("updaterScreen.couldNotLoadChangelog"));
                    }).subscribe(originalResult -> Platform.runLater(() -> {
                        String result = StringUtils.isBlank((String)originalResult) ? Utils.getLocaleBundle().getString("updaterScreen.couldNotLoadChangelog") : originalResult;
                        GUIState.getController().showAdditionalScreen(UpdaterController.class, Modality.WINDOW_MODAL, (Object)result);
                    }));
                }
            } else if (informUserIfUpToDate) {
                ETDialog.get((String)Utils.getLocaleBundle().getString("updaterScreen.easytranscriptIsUpToDateTitle"), (String)Utils.getLocaleBundle().getString("updaterScreen.easytranscriptIsUpToDate")).showAndWait();
            }
        })));
    }

    private void showInstructionsOnHowToUpdate() {
        ETButtonType toWebsite = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("updaterScreen.goToWebsite"), ButtonBar.ButtonData.NEXT_FORWARD), false, false);
        ETButtonType cancelType = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("general.cancel"), ButtonBar.ButtonData.CANCEL_CLOSE), false, true);
        ButtonType response = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("updaterScreen.howToUpdateTitle"), (String)Utils.getLocaleBundle().getString("updaterScreen.howToUpdateContent"), (Modality)Modality.WINDOW_MODAL, List.of(cancelType, toWebsite)).showAndWait();
        if (response == toWebsite.getButtonType()) {
            SpringBootJavaFxApplication.getApplication().getHostServices().showDocument("https://easytranscript.de");
        }
    }

    private boolean areUpdatesManagedBySystem() {
        return false;
    }

    private boolean isNotBundledJRE() {
        return !RuntimeUtils.isBundledJRE();
    }

    @Generated
    public UpdaterService(UpdaterController updaterController, ExecutorService executorService, WebClient.Builder webClientBuilder) {
        this.updaterController = updaterController;
        this.executorService = executorService;
        this.webClientBuilder = webClientBuilder;
    }
}

