/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.welcome;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.RecentLoaded;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.programsettings.ProgramSettingsController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.CreateTranscriptController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.importtranscript.ImportTranscriptController;
import eu.ewerkzeug.easytranscript3.mvc.welcome.RecentListCell;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseButton;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="welcomeScreen.fxml")
@StageTitle(value="easytranscript")
@Component
@Lazy
public class WelcomeScreenController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WelcomeScreenController.class);
    private final LoadTranscriptService loadTranscriptService;
    @FXML
    private Label versionLabel;
    @FXML
    private ListView<RecentLoaded> recentListView;

    public void reset() {
    }

    public void initializeController() {
        this.getStage().setResizable(false);
        log.debug("Initializing welcome screen.");
        this.fillRecentList();
        this.versionLabel.setText(Configuration.get().getVersion().toString());
    }

    private void fillRecentList() {
        log.debug("Filling recent loaded list.");
        ObservableList recent = Configuration.get().getProgramRecentLoadedObservableList();
        LinkedHashSet<RecentLoaded> recentLoaded = new LinkedHashSet<RecentLoaded>();
        for (String s : recent) {
            String name = Path.of(s, new String[0]).getFileName().toString();
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            RecentLoaded recentLoaded1 = new RecentLoaded(name, s);
            recentLoaded.add(recentLoaded1);
            recentLoaded1.toBeDeletedProperty().addListener((observable, oldValue, newValue) -> {
                this.recentListView.getItems().remove((Object)recentLoaded1);
                Configuration.get().getProgramRecentLoadedObservableList().remove((Object)s);
            });
        }
        this.recentListView.getItems().addAll(recentLoaded);
        this.recentListView.setOnMouseClicked(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 1 && this.recentListView.getSelectionModel().getSelectedItem() != null) {
                this.loadTranscript(((RecentLoaded)this.recentListView.getSelectionModel().getSelectedItem()).getPath());
            }
        });
        this.recentListView.setCellFactory(param -> new RecentListCell(this.recentListView.getWidth()));
    }

    @FXML
    protected void createTranscript() {
        log.debug("User clicked createTranscript.");
        GUIState.getController().showAdditionalScreen(CreateTranscriptController.class, Modality.WINDOW_MODAL, true);
        this.getStage().close();
    }

    @FXML
    protected void loadTranscript() {
        this.loadTranscript("");
    }

    private void loadTranscript(String path) {
        log.debug("User clicked loadTranscript.");
        Path toUse = null;
        if (path.isEmpty()) {
            FileChooser fileChooser = new FileChooser();
            if (Main.getRecentOpenedFileChooserPath() != null) {
                fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
            }
            fileChooser.getExtensionFilters().addAll((Collection)Transcript.getTranscriptExtensionFilters());
            File file = fileChooser.showOpenDialog(this.getRoot().getScene().getWindow());
            if (file != null) {
                toUse = file.toPath();
            }
        } else {
            toUse = Path.of(path, new String[0]);
        }
        if (toUse != null) {
            if (toUse.toFile().exists()) {
                this.getStage().close();
                this.loadTranscriptService.openTranscript(toUse);
            } else {
                ETDialog.get((String)Utils.getLocaleBundle().getString("problems.transcriptFileNotFound")).showAndWait();
                log.warn("Transcript with path \"" + path + "\" does not exist anymore.");
                Configuration.get().getProgramRecentLoadedObservableList().remove((Object)path);
                Path finalToUse = toUse;
                this.recentListView.getItems().removeIf(recentLoaded -> Path.of(recentLoaded.getPath(), new String[0]).equals(finalToUse));
                Configuration.get().save();
            }
        }
    }

    @FXML
    protected void importTranscript() {
        log.debug("User clicked importTranscript.");
        GUIState.getController().showAdditionalScreen(ImportTranscriptController.class, Modality.WINDOW_MODAL, false);
        this.getStage().close();
    }

    @FXML
    protected void openSettings() {
        log.debug("User clicked openSettings.");
        this.showAdditionalScreen(ProgramSettingsController.class, Modality.WINDOW_MODAL, false);
    }

    @Generated
    public WelcomeScreenController(LoadTranscriptService loadTranscriptService) {
        this.loadTranscriptService = loadTranscriptService;
    }
}

