/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.config;

import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration
public class HttpClientConfig {
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;

    @Bean
    public HttpClientBuilder sttHttpClientBuilder() {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setExpectContinueEnabled(true).setConnectionRequestTimeout(30000).setSocketTimeout(30000).setConnectTimeout(30000).build();
        return HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig);
    }

    @Bean
    public WebClient sttWebClient() {
        HttpClient httpClient = (HttpClient)HttpClient.create().resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
        return WebClient.builder().baseUrl(this.licenseServerUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }
}

