/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.listener;

import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.STTEvent;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDownloadService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTUploadService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTWebSocketService;
import java.nio.file.Path;
import javafx.scene.control.ButtonType;
import lombok.Generated;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.state.State;
import org.springframework.stereotype.Component;

@Component
public class STTStateListener
extends StateMachineListenerAdapter<String, STTEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTStateListener.class);
    private final STTUploadService sttUploadService;
    private final STTWebSocketService webSocketService;
    private final STTDownloadService downloadService;
    private final STTDialogService dialogService;
    private final STTStatusService statusService;
    private final CloseDialog closeDialog;
    private final LoadTranscriptService loadTranscriptService;
    private final STTDeletionService sttDeletionService;

    public void stateChanged(State<String, STTEvent> from, State<String, STTEvent> to) {
        log.info("State changed from {} to {}", from, to);
    }

    public void eventNotAccepted(Message<STTEvent> event) {
        log.error("Event not accepted: {}", event.getPayload());
    }

    public void stateMachineError(StateMachine<String, STTEvent> stateMachine, Exception exception) {
        log.error("StateMachine error", (Throwable)exception);
    }

    public void stateEntered(State<String, STTEvent> state) {
        if (((String)state.getId()).equals("IDLE")) {
            this.onIdleEntry();
        } else if (((String)state.getId()).equals("UPLOADING")) {
            this.onUploadingEntry();
        } else if (((String)state.getId()).equals("GENERATING")) {
            this.onGeneratingEntry();
        } else if (((String)state.getId()).equals("DOWNLOADING")) {
            this.onDownloadingEntry();
        } else if (((String)state.getId()).equals("SUCCESS")) {
            this.onSuccessEntry();
        }
    }

    private void onIdleEntry() {
        this.statusService.getOngoingRequests().forEach(AbstractExecutionAwareRequest::abort);
        this.statusService.getOngoingRequests().clear();
    }

    private void onUploadingEntry() {
        this.sttUploadService.handleUploadingPhase();
    }

    private void onGeneratingEntry() {
        this.webSocketService.handleGeneratingPhase();
    }

    private void onDownloadingEntry() {
        this.downloadService.handleDownloadingPhase();
    }

    private void onSuccessEntry() {
        this.dialogService.showSuccessfulDownloadDialog().doOnNext(buttonType -> {
            if (buttonType.equals(ButtonType.YES)) {
                log.debug("Opening downloaded transcript...");
                Path path = AutomaticTranscriptCreationInfo.get().getTranscriptLocation();
                this.closeDialog.showAndWait(() -> this.loadTranscriptService.openTranscript(path));
            } else if (buttonType.equals(ButtonType.NO)) {
                log.debug("User chose not to open the transcript.");
            }
        }).doOnError(error -> log.error("Error occurred while showing dialog: ", error)).subscribe();
        this.sttDeletionService.deleteTranscriptionJob().subscribe();
    }

    @Generated
    public STTStateListener(STTUploadService sttUploadService, STTWebSocketService webSocketService, STTDownloadService downloadService, STTDialogService dialogService, STTStatusService statusService, CloseDialog closeDialog, LoadTranscriptService loadTranscriptService, STTDeletionService sttDeletionService) {
        this.sttUploadService = sttUploadService;
        this.webSocketService = webSocketService;
        this.downloadService = downloadService;
        this.dialogService = dialogService;
        this.statusService = statusService;
        this.closeDialog = closeDialog;
        this.loadTranscriptService = loadTranscriptService;
        this.sttDeletionService = sttDeletionService;
    }
}

