/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class STTDeletionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTDeletionService.class);
    private final STTStatusService statusService;
    private final WebClient sttWebClient;

    public void cancelAllOngoingTransfers() {
        this.statusService.resetCurrentProcess();
    }

    public Mono<ResponseEntity<Void>> deleteTranscriptionJob() {
        log.debug("Deleting active project ...");
        this.statusService.getLatestStatus().set(null);
        this.cancelAllOngoingTransfers();
        WebClient.RequestHeadersSpec request = this.sttWebClient.delete().uri("/projects", new Object[0]);
        Consumer headers = CredentialsUtils.getAuthHeadersConsumer();
        if (headers == null) {
            return Mono.error(NullPointerException::new);
        }
        request = request.headers(headers);
        return request.retrieve().toBodilessEntity().onErrorResume(WebClientResponseException.class, Mono::error).doOnSuccess(voidResponseEntity -> log.info("Deleted active project.")).doOnError(throwable -> log.error("Failed to delete transcription job.", throwable));
    }

    @Generated
    public STTDeletionService(STTStatusService statusService, WebClient sttWebClient) {
        this.statusService = statusService;
        this.sttWebClient = sttWebClient;
    }
}

