/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.reactfx.EventStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class STTDialogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTDialogService.class);
    private final StatusService statusService;

    public void showUploadInfoDialog() {
        Platform.runLater(() -> ETDialog.createDialog((String)"", (String)Utils.getLocaleBundle().getString("createTranscriptScreen.uploadForAutomaticTranscriptionNotification"), (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    public Mono<ButtonType> showSuccessfulDownloadDialog() {
        log.debug("Preparing successful download dialog...");
        return Mono.create(sink -> {
            Runnable openDialog = () -> {
                ETDialog dialog = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.successfullyDownloadedTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.successfullyDownloaded"), (Modality)Modality.APPLICATION_MODAL, Arrays.asList(new ETButtonType(ButtonType.YES, true, false), new ETButtonType(ButtonType.NO, false, true)));
                dialog.getStage().setAlwaysOnTop(true);
                ButtonType buttonType = dialog.showAndWait();
                sink.success((Object)buttonType);
            };
            Platform.runLater(() -> {
                if (this.statusService.isTranscriptLoading()) {
                    EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribeForOne(booleanChange -> openDialog.run());
                } else {
                    openDialog.run();
                }
            });
        });
    }

    public void showUnauthorizedError() {
        String title = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.unauthorizedTitle");
        String content = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.unauthorized");
        Platform.runLater(() -> ETDialog.createDialog((String)title, (String)content, (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    public static ETDialog createUploadDownloadCancelAlert(boolean downloading, boolean uploading) {
        String content;
        log.debug("Creating upload download cancel alert ...");
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType buttonTypeYes = new ETButtonType(ButtonType.YES, true, false);
        ETButtonType buttonTypeNo = new ETButtonType(ButtonType.NO, false, false);
        buttons.add(buttonTypeYes);
        buttons.add(buttonTypeNo);
        if (downloading) {
            content = Utils.getLocaleBundle().getString("mainScreen.filesAreBeingDownloaded");
        } else if (uploading) {
            content = Utils.getLocaleBundle().getString("mainScreen.filesAreBeingUploaded");
        } else {
            return null;
        }
        return ETDialog.createDialog((String)Utils.getLocaleBundle().getString("mainScreen.filesAutomaticTranscriptionNotificationTitle"), (String)content, (Modality)Modality.WINDOW_MODAL, buttons);
    }

    @Generated
    public STTDialogService(StatusService statusService) {
        this.statusService = statusService;
    }
}

