/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import io.netty.channel.ConnectTimeoutException;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class STTDownloadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTDownloadService.class);
    private static final int MAX_DOWNLOAD_RETRIES = 3;
    private static final long DOWNLOAD_RETRY_DELAY_MS = 2000L;
    private final STTStatusService sttStatusService;
    private final HttpClientBuilder sttHttpClientBuilder;
    private final STTDeletionService sttDeletionService;
    private final STTDialogService sttDialogService;
    private final CloseDialog closeDialog;
    private final LoadTranscriptService loadTranscriptService;
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;

    public void handleDownloadingPhase() {
        Runnable download = () -> this.asyncDownloadTranscript(AutomaticTranscriptCreationInfo.get()).subscribe(res -> log.info("Downloaded project successfully."));
        if (AutomaticTranscriptCreationInfo.get().getTranscriptLocation() != null && !AutomaticTranscriptCreationInfo.get().getTranscriptLocation().toString().isEmpty()) {
            download.run();
        } else {
            Platform.runLater(() -> {
                ETButtonType chooseFolder = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("automaticTranscriptionStatus.chooseLocation"), ButtonBar.ButtonData.YES), true, false);
                ButtonType buttonType = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.chooseFolderForDownloadTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.chooseFolderForDownload"), (Modality)Modality.WINDOW_MODAL, Arrays.asList(new ETButtonType(ButtonType.CANCEL, false, true), chooseFolder)).showAndWait();
                if (buttonType != null && buttonType.equals(chooseFolder.getButtonType())) {
                    File file = this.chooseAlternativeTranscriptLocation();
                    if (file != null) {
                        AutomaticTranscriptCreationInfo.get().setTranscriptLocation(file.toPath());
                        download.run();
                    } else {
                        this.sttStatusService.resetCurrentProcess();
                    }
                } else {
                    this.sttStatusService.resetCurrentProcess();
                }
            });
        }
    }

    private Mono<Void> asyncDownloadTranscript(AutomaticTranscriptCreationInfo info) {
        log.debug("Downloading transcript {}...", (Object)info.getUuid());
        Runnable runnable = () -> {
            Path path = this.downloadTranscript(info);
            log.info("Downloaded transcript {}", (Object)info.getUuid());
            this.moveDownloadedTranscript(path);
        };
        return Mono.fromFuture(CompletableFuture.runAsync(runnable));
    }

    private Path downloadTranscript(AutomaticTranscriptCreationInfo info) {
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                return this.attemptDownload(info);
            }
            catch (ConnectTimeoutException | SocketTimeoutException e) {
                log.warn("Attempt {} failed due to timeout: {}", (Object)attempt, (Object)e.getMessage());
                if (attempt < 3) {
                    log.info("Retrying in {} ms...", (Object)2000L);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        log.warn("Retry sleep interrupted", (Throwable)ex);
                    }
                    continue;
                }
                log.error("All {} attempts failed due to timeout", (Object)3, (Object)e);
                continue;
            }
            catch (IOException e) {
                log.error("Failed to download project on attempt {}: {}", new Object[]{attempt, e.getMessage(), e});
                Utils.showGenericResponseServerErrorDialog();
                break;
            }
        }
        return null;
    }

    private Path attemptDownload(AutomaticTranscriptCreationInfo info) throws IOException {
        HttpGet httpget = new HttpGet(this.licenseServerUrl + "/projects/" + info.getUuid() + "/download");
        this.sttStatusService.getOngoingRequests().add(httpget);
        try {
            Path path;
            block18: {
                CloseableHttpResponse response;
                CloseableHttpClient httpClient;
                block16: {
                    Path path2;
                    block17: {
                        block14: {
                            Path path3;
                            block15: {
                                httpClient = this.sttHttpClientBuilder.build();
                                try {
                                    HashMap authHeaders = CredentialsUtils.getAuthHeaders();
                                    if (authHeaders != null) {
                                        authHeaders.forEach((arg_0, arg_1) -> ((HttpGet)httpget).addHeader(arg_0, arg_1));
                                    }
                                    if ((response = httpClient.execute((HttpUriRequest)httpget)) != null) break block14;
                                    log.error("Received null response from server");
                                    Utils.showGenericResponseServerErrorDialog();
                                    path3 = null;
                                    if (httpClient == null) break block15;
                                }
                                catch (Throwable throwable) {
                                    if (httpClient != null) {
                                        try {
                                            httpClient.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                httpClient.close();
                            }
                            return path3;
                        }
                        int statusCode = response.getStatusLine().getStatusCode();
                        log.info("Status is: {} - {}", (Object)statusCode, (Object)response.getStatusLine().getReasonPhrase());
                        if (this.handleResponseErrors(httpget, (HttpResponse)response, statusCode)) break block16;
                        path2 = null;
                        if (httpClient == null) break block17;
                        httpClient.close();
                    }
                    return path2;
                }
                path = this.handleSuccessfulResponse(httpget, (HttpResponse)response);
                if (httpClient == null) break block18;
                httpClient.close();
            }
            return path;
        }
        finally {
            this.sttStatusService.getOngoingRequests().remove(httpget);
        }
    }

    private void moveDownloadedTranscript(Path tmpEttFile) {
        log.debug("Moving downloaded transcript ...");
        try {
            Path destination = AutomaticTranscriptCreationInfo.get().getTranscriptLocation();
            destination = STTDownloadService.moveFilesSafely((Path)tmpEttFile, (Path)destination);
            AutomaticTranscriptCreationInfo.get().setTranscriptLocation(destination);
            this.finishProjectGeneration();
            AutomaticTranscriptCreationInfo.get().deleteSavedFile();
            log.info("Moved downloaded transcript.");
        }
        catch (IOException e) {
            log.error("Could not move transcript.", (Throwable)e);
            Platform.runLater(() -> {
                ETButtonType chooseFolder = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("automaticTranscriptionStatus.chooseLocation"), ButtonBar.ButtonData.YES), true, false);
                ButtonType buttonType = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.folderNotWritableTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.folderNotWritable"), (Modality)Modality.APPLICATION_MODAL, Arrays.asList(chooseFolder, new ETButtonType(ButtonType.CANCEL, false, true))).showAndWait();
                if (buttonType.equals(chooseFolder.getButtonType())) {
                    AutomaticTranscriptCreationInfo.get().setTranscriptLocation(this.chooseAlternativeTranscriptLocation().toPath());
                    this.moveDownloadedTranscript(tmpEttFile);
                } else {
                    this.sttStatusService.resetCurrentProcess();
                }
            });
        }
    }

    @NotNull
    private static Path moveFilesSafely(Path tmpEttFile, Path destination) throws IOException {
        int i = 2;
        while (Files.exists(destination, new LinkOption[0])) {
            destination = Path.of(destination.getParent().toString(), String.valueOf(destination.getFileName()) + " (" + i + ")");
            ++i;
        }
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        Files.move(tmpEttFile, destination, new CopyOption[0]);
        return destination;
    }

    private boolean handleResponseErrors(HttpGet httpget, HttpResponse response, int statusCode) {
        if (statusCode == HttpStatus.UNAUTHORIZED.value()) {
            log.error("User is not authorized to download.");
            this.sttDialogService.showUnauthorizedError();
        } else if (statusCode == HttpStatus.NOT_FOUND.value()) {
            log.error("Illegal state reached. Project should be ready to download but server says otherwise.");
            ExceptionAlert.get().showModal();
        } else if (statusCode >= 400) {
            log.error("Server error during project download: {}", (Object)statusCode);
            Utils.showGenericResponseServerErrorDialog();
        } else {
            return true;
        }
        this.sttStatusService.getOngoingRequests().remove(httpget);
        return false;
    }

    /*
     * Exception decompiling
     */
    private Path handleSuccessfulResponse(HttpGet httpget, HttpResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Path createTempDownloadFile() {
        Path tempZipFile = Main.getEasytranscriptTempDirectory().resolve("et3-" + String.valueOf(UUID.randomUUID()) + ".zip");
        tempZipFile.toFile().deleteOnExit();
        return tempZipFile;
    }

    private File chooseAlternativeTranscriptLocation() {
        File file;
        log.warn("Original transcript location was not usable. Choosing alternative transcript location ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)Transcript.getEttFilter());
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        if ((file = fileChooser.showSaveDialog((Window)GUIState.getMainStage())) != null) {
            Main.setRecentOpenedFileChooserPath((File)file.toPath().getParent().toFile());
        }
        return file;
    }

    private void finishProjectGeneration() {
        this.sttStatusService.switchToFinishedPhase();
    }

    @Generated
    public STTDownloadService(STTStatusService sttStatusService, HttpClientBuilder sttHttpClientBuilder, STTDeletionService sttDeletionService, STTDialogService sttDialogService, CloseDialog closeDialog, LoadTranscriptService loadTranscriptService) {
        this.sttStatusService = sttStatusService;
        this.sttHttpClientBuilder = sttHttpClientBuilder;
        this.sttDeletionService = sttDeletionService;
        this.sttDialogService = sttDialogService;
        this.closeDialog = closeDialog;
        this.loadTranscriptService = loadTranscriptService;
    }
}

