/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.ETFileBody;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferException;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferProgressInfo;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class STTUploadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTUploadService.class);
    private final STTDialogService sttDialogService;
    private final STTStatusService statusService;
    private final STTDeletionService deletionService;
    private final WebClient sttWebClient;
    private final HttpClientBuilder sttHttpClientBuilder;
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;

    public Mono<List<Person>> uploadMediaFiles() {
        log.debug("Uploading media files ...");
        try {
            this.statusService.getTransferProgressInfo().calculateTotalLength();
        }
        catch (IOException e) {
            log.error("Could not calculate total upload size.", (Throwable)e);
            return Mono.error((Throwable)e);
        }
        AutomaticTranscriptCreationInfo info = AutomaticTranscriptCreationInfo.get();
        if (info.getPersons().isEmpty()) {
            log.error("Could not upload media files. No persons added.");
            return Mono.error(IllegalArgumentException::new);
        }
        if (info.getUuid() == null || info.getUuid().isBlank()) {
            log.error("Could not upload media files. Uuid is empty.");
            return Mono.error(IllegalArgumentException::new);
        }
        return Flux.concat(info.getPersons().stream().map(person -> Mono.fromFuture((CompletableFuture)this.asyncUploadMedia(info.getUuid(), person)).handle((p, synchronousSink) -> {
            if (p.getException() == null) {
                synchronousSink.next(p);
            } else {
                synchronousSink.error((Throwable)p.getException());
            }
        }).cast(Person.class).doOnSuccess(p -> {
            this.statusService.getTransferProgressInfo().getCompletedUploads().add((Object)p.getUuid());
            log.info("Uploaded media file for person {}", (Object)p.getUuid());
        }).doOnError(throwable -> log.error("Upload of media file for person {} failed.", (Object)person.getUuid(), (Object)person.getException()))).toList()).doOnComplete(() -> log.info("Upload media files for project {}", (Object)info.getUuid())).collectList();
    }

    private CompletableFuture<Person> asyncUploadMedia(String projectUuid, Person person) {
        log.debug("Uploading file for person {} of project {}...", (Object)person.getUuid(), (Object)projectUuid);
        Supplier<Person> runnable = () -> this.uploadMedia(projectUuid, person);
        return CompletableFuture.supplyAsync(runnable);
    }

    public void handleUploadingPhase() {
        AutomaticTranscriptCreationInfo.get().save();
        this.sttDialogService.showUploadInfoDialog();
        this.statusService.getShowStatusInfoPopOver().setValue(Boolean.valueOf(true));
        Mono uploadMono = this.uploadMediaFiles().publishOn(Schedulers.boundedElastic()).doOnError(Exception.class, e -> {
            this.handleMediaFileUploadError(e);
            this.deletionService.deleteTranscriptionJob().subscribe();
        }).onErrorReturn(Collections.emptyList());
        Mono startTranscriptionMono = this.startTranscription(AutomaticTranscriptCreationInfo.get().getUuid()).doOnError(WebClientResponseException.class, arg_0 -> this.handleStartTranscriptionError(arg_0));
        uploadMono.flatMap(people -> {
            if (people.isEmpty()) {
                return Mono.empty();
            }
            return startTranscriptionMono;
        }).subscribe(res -> {
            if (res == null) {
                return;
            }
            log.info("Started transcript: {}", (Object)res.getStatusCode().value());
            if (res.getStatusCode().is2xxSuccessful()) {
                this.statusService.switchToGeneratingPhase();
            }
        }, err -> log.error("Could not start transcription", err), () -> log.info("Finished starting transcription"));
    }

    private void handleStartTranscriptionError(WebClientResponseException e) {
        Platform.runLater(() -> {
            HttpStatusCode statusCode = e.getStatusCode();
            if (statusCode.value() == HttpStatus.UNAUTHORIZED.value()) {
                log.error("Got unauthorized error when trying to upload.");
                this.sttDialogService.showUnauthorizedError();
            } else if (statusCode.value() == HttpStatus.CONFLICT.value()) {
                log.error("Got conflict error when trying to upload.");
                ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectGenericClientError"), (Modality)Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.value() == HttpStatus.BAD_REQUEST.value()) {
                log.error("Got bad request error when trying to upload.");
                ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectAlreadyRunning"), (Modality)Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.value() == HttpStatus.PAYMENT_REQUIRED.value()) {
                log.error("insufficient balance when trying to start transcription.");
                ETDialog.createDialog((String)"", (String)Utils.getLocaleBundle().getString("createTranscriptScreen.insufficientBalance"), (Modality)Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.is4xxClientError()) {
                log.error("Got other client error when trying to upload.");
                ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectGenericClientError"), (Modality)Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.is5xxServerError()) {
                log.error("Got server error when trying to upload.");
                Utils.showGenericResponseServerErrorDialog();
            }
            this.statusService.resetCurrentProcess();
        });
    }

    @NotNull
    private Person uploadMedia(String projectUuid, Person person) {
        HttpPost post = this.createHttpPost(projectUuid, person);
        try (CloseableHttpClient httpClient = this.sttHttpClientBuilder.build();){
            this.addAuthHeaders(post);
            MultipartEntityBuilder builder = this.createMultipartEntityBuilder(person);
            post.setEntity(builder.build());
            this.statusService.getOngoingRequests().add(post);
            this.executeUploadRequest(httpClient, post, projectUuid, person);
        }
        catch (TransferException | IOException e) {
            this.handleUploadException(post, (Exception)e, person);
        }
        return person;
    }

    private HttpPost createHttpPost(String projectUuid, Person person) {
        String url = this.licenseServerUrl + "/projects/" + projectUuid + "/" + person.getUuid();
        return new HttpPost(url);
    }

    private void addAuthHeaders(HttpPost post) {
        HashMap authHeaders = CredentialsUtils.getAuthHeaders();
        if (authHeaders != null) {
            for (Map.Entry entry : authHeaders.entrySet()) {
                post.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private MultipartEntityBuilder createMultipartEntityBuilder(Person person) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ETFileBody fileBody = new ETFileBody(person.getMediaPath().toFile());
        fileBody.setListener(arg_0 -> this.updateTransferProgress(arg_0));
        builder.addPart("file", (ContentBody)fileBody);
        return builder;
    }

    private void updateTransferProgress(long delta) {
        TransferProgressInfo transferProgressInfo = this.statusService.getTransferProgressInfo();
        transferProgressInfo.setWrittenPerSecondTmp(transferProgressInfo.getWrittenPerSecondTmp() + delta);
        transferProgressInfo.setTransferred(transferProgressInfo.getTransferred() + delta);
        long diff = new Date().getTime() - transferProgressInfo.getSecondsDate().getTime();
        if (diff >= 1000L) {
            this.handleTransferRateAdjustment(diff, transferProgressInfo);
        }
    }

    private void handleTransferRateAdjustment(long diff, TransferProgressInfo transferProgressInfo) {
        if (diff > 1500L) {
            log.warn("High RTT for sending 4096b: {}ms!", (Object)diff);
        }
        transferProgressInfo.setSecondsDate(new Date());
        transferProgressInfo.getWrittenPerSecond().add((Object)transferProgressInfo.getWrittenPerSecondTmp());
        transferProgressInfo.setWrittenPerSecondTmp(0L);
        if (transferProgressInfo.getWrittenPerSecond().size() > 5) {
            transferProgressInfo.getWrittenPerSecond().removeFirst();
        }
    }

    private void executeUploadRequest(CloseableHttpClient httpClient, HttpPost post, String projectUuid, Person person) throws IOException, TransferException {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            this.statusService.getOngoingRequests().remove(post);
            if (response == null) {
                throw new NullPointerException("Response is null.");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            this.handleResponseStatus(statusCode, projectUuid, person);
        }
    }

    private void handleResponseStatus(int statusCode, String projectUuid, Person person) throws TransferException {
        if (statusCode != 200) {
            throw new TransferException("Failed to upload: " + statusCode, statusCode);
        }
        log.info("Uploaded file for person {} of project {}.", (Object)person.getUuid(), (Object)projectUuid);
    }

    private void handleUploadException(HttpPost post, Exception e, Person person) {
        if (post.isAborted()) {
            log.info("Upload has been aborted.");
            person.setException((Exception)new RequestAbortedException("request was aborted", (Throwable)e));
        } else {
            person.setException(e);
        }
    }

    public void handleMediaFileUploadError(Exception e) {
        log.error("Could not upload media file.", (Throwable)e);
        this.statusService.resetCurrentProcess();
        if (e instanceof IllegalArgumentException) {
            ExceptionAlert.get().showModal();
        } else if (e instanceof RequestAbortedException) {
            log.error("Media file upload was aborted");
        } else if (e instanceof NullPointerException) {
            log.error("Exception is a NullPointerException.");
            Utils.showGenericResponseServerErrorDialog();
        } else if (e instanceof WebClientRequestException || e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
            Utils.showGenericRequestErrorDialog();
        } else if (e instanceof IOException) {
            log.error("Exception is an IOException.");
            Platform.runLater(() -> ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToReadMediaFile"), (Modality)Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
        } else if (e instanceof TransferException) {
            TransferException ex = (TransferException)((Object)e);
            log.error("Exception is a TransferException.");
            log.error("Status code: {}", (Object)ex.getStatus());
            if (ex.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                log.error("User is not authorized to upload media.");
                this.sttDialogService.showUnauthorizedError();
            } else if (ex.getStatus() == HttpStatus.LOCKED.value()) {
                log.error("Project is already running.");
                ExceptionAlert.get().showModal();
            } else if (ex.getStatus() == HttpStatus.BAD_REQUEST.value()) {
                log.error("Upload was not a multipart request.");
                ExceptionAlert.get().showModal();
            } else if (ex.getStatus() == HttpStatus.INSUFFICIENT_STORAGE.value()) {
                ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.quotaExceededWhileUploading"), (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (ex.getStatus() == HttpStatus.ALREADY_REPORTED.value()) {
                log.error("File for speaker already uploaded.");
                ExceptionAlert.get().showModal();
                log.error("");
            } else {
                Utils.showGenericResponseServerErrorDialog();
            }
        } else {
            Utils.showGenericResponseServerErrorDialog();
        }
    }

    private Mono<ResponseEntity<Void>> startTranscription(String uuid) {
        log.debug("Starting transcription of project with uuid {} ...", (Object)uuid);
        Consumer headers = CredentialsUtils.getAuthHeadersConsumer();
        if (headers == null) {
            return Mono.error(NullPointerException::new);
        }
        WebClient.RequestBodySpec uri = (WebClient.RequestBodySpec)this.sttWebClient.post().uri("/projects/" + uuid, new Object[0]);
        uri = (WebClient.RequestBodySpec)uri.headers(headers);
        return uri.retrieve().toBodilessEntity().onErrorResume(WebClientResponseException.class, Mono::error);
    }

    @Generated
    public STTUploadService(STTDialogService sttDialogService, STTStatusService statusService, STTDeletionService deletionService, WebClient sttWebClient, HttpClientBuilder sttHttpClientBuilder) {
        this.sttDialogService = sttDialogService;
        this.statusService = statusService;
        this.deletionService = deletionService;
        this.sttWebClient = sttWebClient;
        this.sttHttpClientBuilder = sttHttpClientBuilder;
    }
}

