/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import java.util.Collections;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

@Service
public class STTWebSocketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTWebSocketService.class);
    private WebSocketStompClient stompClient;
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;
    private final STTStatusService statusService;

    public void handleGeneratingPhase() {
        this.statusService.setReconnectTriesLeft(3);
        this.connectToWebSocket(AutomaticTranscriptCreationInfo.get().getUuid());
    }

    public void connectToWebSocket(String uuid) {
        log.debug("Connecting to websocket for project {} ...", (Object)uuid);
        eu.ewerkzeug.easytranscript3.networking.automatictranscription.websocket.StompSessionHandler sessionHandler = new eu.ewerkzeug.easytranscript3.networking.automatictranscription.websocket.StompSessionHandler(uuid, this.statusService, this);
        StompHeaders headers = new StompHeaders();
        HashMap authHeaders = CredentialsUtils.getAuthHeaders();
        if (authHeaders == null) {
            throw new NullPointerException("auth headers are empty.");
        }
        authHeaders.forEach((arg_0, arg_1) -> ((StompHeaders)headers).add(arg_0, arg_1));
        WebSocketHttpHeaders webSocketHttpHeaders = new WebSocketHttpHeaders();
        try {
            this.getWebSocketClient().connectAsync(this.licenseServerUrl + "/stomp", webSocketHttpHeaders, headers, (StompSessionHandler)sessionHandler, new Object[0]);
        }
        catch (Exception e) {
            log.error("Could not connect to websocket.", (Throwable)e);
            Utils.showGenericResponseServerErrorDialog();
        }
    }

    private WebSocketStompClient getWebSocketClient() {
        if (this.stompClient != null) {
            return this.stompClient;
        }
        SockJsClient client = new SockJsClient(Collections.singletonList(new WebSocketTransport((WebSocketClient)new StandardWebSocketClient())));
        this.stompClient = new WebSocketStompClient((WebSocketClient)client);
        this.stompClient.setMessageConverter((MessageConverter)new MappingJackson2MessageConverter());
        return this.stompClient;
    }

    @Generated
    public STTWebSocketService(STTStatusService statusService) {
        this.statusService = statusService;
    }
}

