/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.GnomeThemeDetector;
import com.jthemedetecor.MacOSThemeDetector;
import com.jthemedetecor.OsThemeDetector;
import com.jthemedetecor.WindowsThemeDetector;
import com.jthemedetecor.util.OsInfo;
import java.util.function.Consumer;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(OsThemeDetector.class);
    private static OsThemeDetector osThemeDetector;

    OsThemeDetector() {
    }

    @NotNull
    public static synchronized OsThemeDetector getDetector() {
        if (osThemeDetector != null) {
            return osThemeDetector;
        }
        if (OsInfo.isWindows10OrLater()) {
            OsThemeDetector.logDetection((String)"Windows 10", WindowsThemeDetector.class);
            osThemeDetector = new WindowsThemeDetector();
            return osThemeDetector;
        }
        if (OsInfo.isGnome()) {
            OsThemeDetector.logDetection((String)"Gnome", GnomeThemeDetector.class);
            osThemeDetector = new GnomeThemeDetector();
            return osThemeDetector;
        }
        if (OsInfo.isMacOsMojaveOrLater()) {
            OsThemeDetector.logDetection((String)"MacOS", MacOSThemeDetector.class);
            osThemeDetector = new MacOSThemeDetector();
            return osThemeDetector;
        }
        logger.debug("Theme detection is not supported on the system: {} {}", (Object)SystemUtils.OS_NAME, (Object)SystemUtils.OS_VERSION);
        logger.debug("Creating empty detector...");
        osThemeDetector = new EmptyDetector();
        return osThemeDetector;
    }

    private static void logDetection(String desktop, Class<? extends OsThemeDetector> detectorClass) {
        logger.debug("Supported Desktop detected: {}", (Object)desktop);
        logger.debug("Creating {}...", (Object)detectorClass.getName());
    }

    public static boolean isSupported() {
        return OsInfo.isWindows10OrLater() || OsInfo.isMacOsMojaveOrLater() || OsInfo.isGnome();
    }

    public abstract boolean isDark();

    public abstract void registerListener(@NotNull Consumer<Boolean> var1);

    public abstract void removeListener(@Nullable Consumer<Boolean> var1);
}

