/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfPicture;
import com.tutego.jrtf.RtfText;
import com.tutego.jrtf.RtfUnit;
import java.io.IOException;
import java.io.InputStream;

public class RtfPicture {
    private final StringBuilder hexPicData = new StringBuilder(4096);
    private int widthInTwips = -1;
    private int heightInTwips = -1;
    private int scaleX = -1;
    private int scaleY = -1;

    RtfPicture(InputStream source) throws IOException {
        int b;
        if (source == null) {
            throw new IllegalArgumentException("Image source can't be null");
        }
        int pos = 1;
        while ((b = source.read()) != -1) {
            String hexString = Integer.toHexString(b);
            if (hexString.length() == 1) {
                this.hexPicData.append('0').append(hexString);
            } else {
                this.hexPicData.append(hexString);
            }
            if (pos++ != 40) continue;
            pos = 1;
            this.hexPicData.append('\n');
        }
    }

    public RtfPicture width(double width, RtfUnit unit) {
        this.widthInTwips = unit.toTwips(width);
        return this;
    }

    public RtfPicture height(double height, RtfUnit unit) {
        this.heightInTwips = unit.toTwips(height);
        return this;
    }

    public RtfPicture size(double width, double height, RtfUnit unit) {
        this.widthInTwips = unit.toTwips(width);
        this.heightInTwips = unit.toTwips(height);
        return this;
    }

    public RtfPicture scaleX(int scale) {
        this.scaleX = scale;
        return this;
    }

    public RtfPicture scaleY(int scale) {
        this.scaleY = scale;
        return this;
    }

    public RtfPicture scale(int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        return this;
    }

    public RtfText type(PictureType pictureType) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

